/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.security.simple;

import java.security.SecureRandom;

class SecureIDGenerator {
    private static final String ZERO16 = "0000000000000000";
    private static final String ZERO8 = "00000000";
    private static SecureRandom seeder = new SecureRandom();

    SecureIDGenerator() {
    }

    public static synchronized String createID(Object obj) {
        long currentTime = System.currentTimeMillis();
        String currentTimeStr = SecureIDGenerator.toHexString(currentTime);
        String hashCodeStr = SecureIDGenerator.toHexString(System.identityHashCode(obj));
        String randomStr = SecureIDGenerator.toHexString(seeder.nextInt());
        String secureID = currentTimeStr + hashCodeStr + randomStr;
        return secureID;
    }

    private static String toHexString(int num) {
        String hexStr = Integer.toHexString(num);
        String zeroStr = ZERO8.substring(0, 8 - hexStr.length());
        return zeroStr + hexStr;
    }

    private static String toHexString(long num) {
        String hexStr = Long.toHexString(num);
        String zeroStr = ZERO16.substring(0, 16 - hexStr.length());
        return zeroStr + hexStr;
    }
}

