/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.wfmc;

import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.omg.WfState;

public final class WorkItemState
implements WfState {
    private static final long serialVersionUID = 20050000000000001L;
    public static final WorkItemState OPEN_NOT_RUNNING_NOT_STARTED = new WorkItemState("open.not_running.not_started", 1);
    public static final WorkItemState OPEN_NOT_RUNNING_SUSPENDED = new WorkItemState("open.not_running.suspended", 2);
    public static final WorkItemState OPEN_RUNNING = new WorkItemState("open.running", 3);
    public static final WorkItemState CLOSED_COMPLETED = new WorkItemState("closed.completed", 4);
    public static final WorkItemState CLOSED_TERMINATED = new WorkItemState("closed.terminated", 5);
    public static final WorkItemState CLOSED_ABORTED = new WorkItemState("closed.aborted", 6);
    private String stateString;
    private int stateNum;

    public static WorkItemState getState(int n) {
        switch (n) {
            case 1: {
                return OPEN_NOT_RUNNING_NOT_STARTED;
            }
            case 2: {
                return OPEN_NOT_RUNNING_SUSPENDED;
            }
            case 3: {
                return OPEN_RUNNING;
            }
            case 4: {
                return CLOSED_COMPLETED;
            }
            case 5: {
                return CLOSED_TERMINATED;
            }
            case 6: {
                return CLOSED_ABORTED;
            }
        }
        return null;
    }

    public static WorkItemState[] getTransitableStates(int n) {
        ArrayList<WorkItemState> states = new ArrayList<WorkItemState>();
        switch (n) {
            case 1: 
            case 2: {
                states.add(OPEN_RUNNING);
                states.add(CLOSED_COMPLETED);
                states.add(CLOSED_TERMINATED);
                states.add(CLOSED_ABORTED);
                break;
            }
            case 3: {
                states.add(OPEN_NOT_RUNNING_SUSPENDED);
                states.add(CLOSED_COMPLETED);
                states.add(CLOSED_TERMINATED);
                states.add(CLOSED_ABORTED);
            }
        }
        return states.toArray(new WorkItemState[0]);
    }

    private WorkItemState(String s, int i) {
        this.stateString = s;
        this.stateNum = i;
    }

    public String toString() {
        return this.stateString;
    }

    public int toInt() {
        return this.stateNum;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WorkItemState)) {
            return false;
        }
        WorkItemState s = (WorkItemState)obj;
        return this.stateNum == s.stateNum && this.stateString.equals(s.stateString);
    }

    public int hashCode() {
        return this.stateString.hashCode();
    }
}

