/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.soap;

import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.filter.AttributeFilter;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.soap.message.Activity;
import jp.co.argo21.nautica.workflow.soap.message.ActivityState;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.ProcDef;
import jp.co.argo21.nautica.workflow.soap.message.Process;
import jp.co.argo21.nautica.workflow.soap.message.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.soap.message.ProcessState;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;
import jp.co.argo21.nautica.workflow.soap.message.WorkItemState;

class SoapMessageConverter {
    private static int NAME_FILTER_TYPE = 5001;
    private static int STATE_FILTER_TYPE = 5002;
    private static int ATTRIBUTE_FILTER_TYPE = 5003;
    private static int GROUP_FILTER_TYPE = 5004;
    private static String PROC_DEF_STATE_TYPE = "ProcessDefinitionState";
    private static String PROCESS_STATE_TYPE = "ProcessState";
    private static String ACTIVITY_STATE_TYPE = "ActivityState";
    private static String WORK_ITEM_STATE_TYPE = "WorkItemState";

    SoapMessageConverter() {
    }

    static GroupFilter convertToGroupFilter(Filter[] filters) {
        if (filters == null || filters.length < 1) {
            return null;
        }
        ArrayList<Object> groupFilters = new ArrayList<Object>();
        for (int i = 0; i < filters.length; ++i) {
            Filter filter = filters[i];
            int filterType = filter.getType();
            if (filterType == ATTRIBUTE_FILTER_TYPE) {
                AttributeFilter af = new AttributeFilter(filter.getFilterName(), filter.getComparison(), filter.getFilterString());
                groupFilters.add(af);
                continue;
            }
            if (filterType == NAME_FILTER_TYPE) {
                NameFilter nf = new NameFilter(filter.getFilterString(), filter.getComparison());
                groupFilters.add(nf);
                continue;
            }
            if (filterType == STATE_FILTER_TYPE) {
                Filter[] stateFilters = new Filter[]{filter};
                StateFilter sf = SoapMessageConverter.convertToStateFilter(stateFilters);
                groupFilters.add(sf);
                continue;
            }
            if (filterType == GROUP_FILTER_TYPE) {
                throw new IllegalArgumentException("Illegal Filter Type(FilterType=" + filterType + ")");
            }
            throw new IllegalArgumentException("Illegal Filter Type(FilterType=" + filterType + ")");
        }
        return new GroupFilter(groupFilters.toArray(new jp.co.argo21.nautica.workflow.wfmc.Filter[0]));
    }

    static StateFilter convertToStateFilter(Filter[] filters) {
        if (filters == null || filters.length < 1) {
            return null;
        }
        if (filters.length > 1) {
            throw new IllegalArgumentException("Illegal Number of StateFilter(Number of Filter=" + filters.length + ")");
        }
        StateFilter filter = null;
        String stateType = filters[0].getFilterName();
        if (stateType.equalsIgnoreCase(WORK_ITEM_STATE_TYPE)) {
            WorkItemState state = new WorkItemState(filters[0].getFilterString());
            filter = new StateFilter((WfState)state.toWfmcWorkItemState());
        } else if (stateType.equalsIgnoreCase(PROC_DEF_STATE_TYPE)) {
            ProcessDefinitionState state = new ProcessDefinitionState(filters[0].getFilterString());
            filter = new StateFilter((WfState)state.toWfmcProcessDefinitionState());
        } else if (stateType.equalsIgnoreCase(PROCESS_STATE_TYPE)) {
            ProcessState state = new ProcessState(filters[0].getFilterString());
            filter = new StateFilter((WfState)state.toWfmcProcessState());
        } else if (stateType.equalsIgnoreCase(ACTIVITY_STATE_TYPE)) {
            ActivityState state = new ActivityState(filters[0].getFilterString());
            filter = new StateFilter((WfState)state.toWfmcActivityState());
        } else {
            throw new IllegalArgumentException("Illegal StateFilter's State Type(StateType=" + stateType + ")");
        }
        return filter;
    }

    static Activity[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.Activity[] was) {
        Activity[] as = new Activity[was.length];
        for (int i = 0; i < was.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.Activity wa = was[i];
            as[i] = new Activity(wa);
        }
        return as;
    }

    static ActivityState[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.ActivityState[] wass) {
        ActivityState[] ass = new ActivityState[wass.length];
        for (int i = 0; i < wass.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.ActivityState was = wass[i];
            ass[i] = new ActivityState(was);
        }
        return ass;
    }

    static ProcDef[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.ProcDef[] wpds) {
        ProcDef[] pds = new ProcDef[wpds.length];
        for (int i = 0; i < wpds.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.ProcDef wpd = wpds[i];
            pds[i] = new ProcDef(wpd);
        }
        return pds;
    }

    static ProcessDefinitionState[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState[] wpdss) {
        ProcessDefinitionState[] pdss = new ProcessDefinitionState[wpdss.length];
        for (int i = 0; i < wpdss.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState wpds = wpdss[i];
            pdss[i] = new ProcessDefinitionState(wpds);
        }
        return pdss;
    }

    static Process[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.Process[] wps) {
        Process[] ps = new Process[wps.length];
        for (int i = 0; i < wps.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.Process wp = wps[i];
            ps[i] = new Process(wp);
        }
        return ps;
    }

    static ProcessState[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.ProcessState[] wpss) {
        ProcessState[] pss = new ProcessState[wpss.length];
        for (int i = 0; i < wpss.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.ProcessState wps = wpss[i];
            pss[i] = new ProcessState(wps);
        }
        return pss;
    }

    static Attribute[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.Attribute[] wattrs) {
        Attribute[] attrs = new Attribute[wattrs.length];
        for (int i = 0; i < wattrs.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.Attribute wattr = wattrs[i];
            attrs[i] = new Attribute(wattr);
        }
        return attrs;
    }

    static WorkItem[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.WorkItem[] wwis) {
        WorkItem[] wis = new WorkItem[wwis.length];
        for (int i = 0; i < wwis.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.WorkItem wwi = wwis[i];
            wis[i] = new WorkItem(wwi);
        }
        return wis;
    }

    static WorkItemState[] convertToSoapMessage(jp.co.argo21.nautica.workflow.wfmc.WorkItemState[] wwiss) {
        WorkItemState[] wiss = new WorkItemState[wwiss.length];
        for (int i = 0; i < wwiss.length; ++i) {
            jp.co.argo21.nautica.workflow.wfmc.WorkItemState wwis = wwiss[i];
            wiss[i] = new WorkItemState(wwis);
        }
        return wiss;
    }
}

