/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.security.jassjacc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQTopic;
import org.activemq.security.jassjacc.BrokerSecurityConfig;
import org.activemq.security.jassjacc.DestinationSecurityConfig;
import org.activemq.security.jassjacc.JassJaccSecurityAdapter;

public class PropertiesConfigLoader {
    HashMap destinationMap = new HashMap();
    BrokerSecurityConfig brokerSecurityConfig = new BrokerSecurityConfig();

    public PropertiesConfigLoader(String brokerName, Properties props) throws IOException {
        String dest;
        String type;
        Matcher matcher;
        String prop;
        this.brokerSecurityConfig.setBrokerName(brokerName);
        Pattern brokerConnectRoles = Pattern.compile("^connect\\.roles$");
        Pattern destNames = Pattern.compile("^(queue|topic)\\.([^\\.]+)\\.names$");
        Pattern destConsumeRoles = Pattern.compile("^(queue|topic)\\.([^\\.]+)\\.consume\\.roles$");
        Pattern destProduceRoles = Pattern.compile("^(queue|topic)\\.([^\\.]+)\\.produce\\.roles$");
        Pattern destSendRoles = Pattern.compile("^(queue|topic)\\.([^\\.]+)\\.send\\.roles$");
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            prop = (String)enumeration.nextElement();
            matcher = brokerConnectRoles.matcher(prop);
            if (matcher.matches()) {
                String[] roles = PropertiesConfigLoader.trim(props.getProperty(prop).split("\\,"));
                this.brokerSecurityConfig.setConnectRoles(new HashSet<String>(Arrays.asList(roles)));
                continue;
            }
            matcher = destNames.matcher(prop);
            if (!matcher.matches()) continue;
            type = matcher.group(1);
            dest = matcher.group(2);
            this.setDestNames(type, dest, PropertiesConfigLoader.trim(props.getProperty(prop).split("\\,")));
        }
        enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            prop = (String)enumeration.nextElement();
            matcher = destConsumeRoles.matcher(prop);
            if (matcher.matches()) {
                type = matcher.group(1);
                dest = matcher.group(2);
                this.setDestConsumeRoles(type, dest, PropertiesConfigLoader.trim(props.getProperty(prop).split("\\,")));
                continue;
            }
            matcher = destProduceRoles.matcher(prop);
            if (matcher.matches()) {
                type = matcher.group(1);
                dest = matcher.group(2);
                this.setDestProduceRoles(type, dest, PropertiesConfigLoader.trim(props.getProperty(prop).split("\\,")));
                continue;
            }
            matcher = destSendRoles.matcher(prop);
            if (!matcher.matches()) continue;
            type = matcher.group(1);
            dest = matcher.group(2);
            this.setDestSendRoles(type, dest, PropertiesConfigLoader.trim(props.getProperty(prop).split("\\,")));
        }
    }

    private void setDestSendRoles(String type, String dest, String[] roles) throws IOException {
        List configs = this.getDestConfig(type, dest);
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            DestinationSecurityConfig config = (DestinationSecurityConfig)iter.next();
            config.setProduceRoles(new HashSet<String>(Arrays.asList(roles)));
        }
    }

    private void setDestProduceRoles(String type, String dest, String[] roles) throws IOException {
        List configs = this.getDestConfig(type, dest);
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            DestinationSecurityConfig config = (DestinationSecurityConfig)iter.next();
            config.setProduceRoles(new HashSet<String>(Arrays.asList(roles)));
        }
    }

    private void setDestConsumeRoles(String type, String dest, String[] roles) throws IOException {
        List configs = this.getDestConfig(type, dest);
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            DestinationSecurityConfig config = (DestinationSecurityConfig)iter.next();
            config.setConsumeRoles(new HashSet<String>(Arrays.asList(roles)));
        }
    }

    private List getDestConfig(String type, String dest) throws IOException {
        List rc = (List)this.destinationMap.get(type + ":" + dest);
        if (rc == null) {
            throw new IOException("Expected property not found: " + type + "." + dest + ".names");
        }
        return rc;
    }

    private void setDestNames(String type, String dest, String[] names) throws IOException {
        ArrayList<DestinationSecurityConfig> list = new ArrayList<DestinationSecurityConfig>();
        for (int i = 0; i < names.length; ++i) {
            DestinationSecurityConfig config = new DestinationSecurityConfig();
            config.setBrokerName(this.brokerSecurityConfig.getBrokerName());
            if ("queue".equals(type)) {
                config.setDestination(new ActiveMQQueue(dest));
            } else {
                config.setDestination(new ActiveMQTopic(dest));
            }
            list.add(config);
        }
        this.destinationMap.put(type + ":" + dest, list);
    }

    private static String[] trim(String[] brokers) {
        for (int i = 0; i < brokers.length; ++i) {
            brokers[i] = brokers[i].trim();
        }
        return brokers;
    }

    public DestinationSecurityConfig[] getDestinationSecurityConfigs() {
        ArrayList answer = new ArrayList();
        Iterator iter = this.destinationMap.values().iterator();
        while (iter.hasNext()) {
            List l = (List)iter.next();
            answer.addAll(l);
        }
        DestinationSecurityConfig[] rc = new DestinationSecurityConfig[answer.size()];
        answer.toArray(rc);
        return rc;
    }

    public BrokerSecurityConfig getBrokerSecurityConfig() {
        return this.brokerSecurityConfig;
    }

    public void installSecurity() {
        JassJaccSecurityAdapter.secure(this.brokerSecurityConfig);
        DestinationSecurityConfig[] destinationSecurityConfigs = this.getDestinationSecurityConfigs();
        for (int i = 0; i < destinationSecurityConfigs.length; ++i) {
            DestinationSecurityConfig config = destinationSecurityConfigs[i];
            JassJaccSecurityAdapter.secure(config);
        }
    }
}

