/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import java.util.Map;
import javax.transaction.xa.XAException;
import org.activemq.service.impl.AbstractTransaction;
import org.activemq.store.TransactionStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalTransactionCommand
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog((Class)LocalTransactionCommand.class);
    private Map localTxs;
    private String txid;
    private final TransactionStore transactionStore;

    public LocalTransactionCommand(Map localTxs, String txid, TransactionStore transactionStore) {
        this.localTxs = localTxs;
        this.txid = txid;
        this.transactionStore = transactionStore;
    }

    public void commit(boolean onePhase) throws XAException {
        try {
            this.prePrepare();
        }
        catch (XAException e) {
            throw e;
        }
        catch (Throwable e) {
            log.warn((Object)"COMMIT FAILED: ", e);
            this.rollback();
            XAException xae = new XAException("COMMIT FAILED: Transaction rolled back.");
            xae.errorCode = 104;
            xae.initCause(e);
            throw xae;
        }
        this.setState((byte)3);
        this.localTxs.remove(this.txid);
        this.transactionStore.commit(this.getTransactionId(), false);
        try {
            this.postCommit();
        }
        catch (Throwable e) {
            log.warn((Object)"POST COMMIT FAILED: ", e);
            XAException xae = new XAException("POST COMMIT FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public void rollback() throws XAException {
        this.setState((byte)3);
        this.localTxs.remove(this.txid);
        this.transactionStore.rollback(this.getTransactionId());
        try {
            this.postRollback();
        }
        catch (Throwable e) {
            log.warn((Object)"POST ROLLBACK FAILED: ", e);
            XAException xae = new XAException("POST ROLLBACK FAILED");
            xae.errorCode = -3;
            xae.initCause(e);
            throw xae;
        }
    }

    public int prepare() throws XAException {
        XAException xae = new XAException("Prepare not implemented on Local Transactions.");
        xae.errorCode = -3;
        throw xae;
    }

    public boolean isXaTransacted() {
        return false;
    }

    public Object getTransactionId() {
        return this.txid;
    }
}

