/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import javax.jms.JMSException;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageContainer;
import org.activemq.service.MessageIdentity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MessagePointer {
    private static final Log log = LogFactory.getLog((Class)MessagePointer.class);
    private MessageContainer container;
    private MessageIdentity messageIdentity;
    private boolean dispatched;
    private boolean read;
    private boolean redelivered;
    private boolean deleted;

    public MessagePointer(MessagePointer copy) throws JMSException {
        this.container = copy.container;
        this.messageIdentity = copy.messageIdentity;
        this.container.registerMessageInterest(this.messageIdentity);
    }

    public MessagePointer(MessageContainer container, ActiveMQMessage message) throws JMSException {
        this.container = container;
        this.messageIdentity = message.getJMSMessageIdentity();
        this.redelivered = message.getJMSRedelivered();
        this.container.registerMessageInterest(this.messageIdentity);
    }

    public void reset() {
        this.dispatched = false;
        this.read = false;
        this.deleted = false;
    }

    public void clear() throws JMSException {
        this.container.unregisterMessageInterest(this.messageIdentity);
    }

    public void delete(MessageAck ack) throws JMSException {
        this.clear();
        this.deleted = true;
        this.container.delete(this.messageIdentity, ack);
    }

    public MessageContainer getContainer() {
        return this.container;
    }

    public void setContainer(MessageContainer container) {
        this.container = container;
    }

    public boolean isDispatched() {
        return this.dispatched;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDispatched(boolean dispatched) {
        this.dispatched = dispatched;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public MessageIdentity getMessageIdentity() {
        return this.messageIdentity;
    }

    public void setMessageIdentity(MessageIdentity messageIdentity) {
        this.messageIdentity = messageIdentity;
    }

    public boolean isRedelivered() {
        return this.redelivered;
    }

    public void setRedelivered(boolean redelivered) throws JMSException {
        if (!this.deleted) {
            this.redelivered = redelivered;
            ActiveMQMessage message = this.getContainer().getMessage(this.getMessageIdentity());
            if (message == null) {
                log.warn((Object)("Could not find message: " + this.getMessageIdentity() + " when trying to set redelivered to: " + redelivered));
            } else {
                message.setJMSRedelivered(redelivered);
            }
        }
    }
}

