/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import pnuts.compiler.ByteBuffer;
import pnuts.compiler.ClassFileException;
import pnuts.compiler.ConstantPool;
import pnuts.compiler.Label;
import pnuts.compiler.Opcode;

public class ClassFile {
    private static final long MAGIC = -3819410108756852691L;
    private static final boolean DEBUG = false;
    private ConstantPool constantPool;
    private Vector methods = new Vector();
    private MethodInfo currentMethod;
    private Vector fields = new Vector();
    private Vector exceptionTable;
    private Vector interfaces = new Vector();
    private short thisClassIndex;
    private short superClassIndex;
    private short sourceFileNameIndex;
    private short accessFlags;
    private short maxStack;
    private short stackTop;
    private boolean[] locals;
    public ClassFile parent;
    private String className;
    private int maxLocal;
    ByteBuffer codeBuffer;

    public ClassFile(String thisClass, String superClass, String sourceFile, short accessFlags) {
        this.constantPool = new ConstantPool();
        this.thisClassIndex = this.constantPool.addClass(thisClass);
        this.superClassIndex = this.constantPool.addClass(superClass);
        if (sourceFile != null) {
            this.sourceFileNameIndex = this.constantPool.addUTF8(sourceFile);
        }
        this.accessFlags = accessFlags;
        this.className = thisClass;
    }

    public String getClassName() {
        return this.className;
    }

    public int codeSize() {
        return this.codeBuffer.size();
    }

    public void addInterface(String interfaceName) {
        this.interfaces.addElement(new Short(this.constantPool.addClass(interfaceName)));
    }

    public void addField(String fieldName, String type, short accessFlags) {
        this.fields.addElement(new FieldInfo(this.constantPool.addUTF8(fieldName), this.constantPool.addUTF8(type), accessFlags));
    }

    public short addConstant(String value) {
        return this.constantPool.addConstant(value);
    }

    public void addConstant(String fieldName, String type, short flags, short valueIndex) {
        short fieldNameIndex = this.constantPool.addUTF8(fieldName);
        short typeIndex = this.constantPool.addUTF8(type);
        short[] cvAttr = new short[]{this.constantPool.addUTF8("ConstantValue"), 0, 2, valueIndex};
        this.fields.addElement(new FieldInfo(fieldNameIndex, typeIndex, flags, cvAttr));
    }

    public void addConstant(String fieldName, String type, short flags, int value) {
        this.addConstant(fieldName, type, flags, this.constantPool.addConstant(value));
    }

    public void addConstant(String fieldName, String type, short flags, long value) {
        this.addConstant(fieldName, type, flags, this.constantPool.addConstant(value));
    }

    public void addConstant(String fieldName, String type, short flags, double value) {
        this.addConstant(fieldName, type, flags, this.constantPool.addConstant(value));
    }

    public void addConstant(String fieldName, String type, short flags, String value) {
        this.addConstant(fieldName, type, flags, this.constantPool.addConstant(value));
    }

    public void openMethod(String methodName, String type, short flag) {
        this.openMethod(methodName, type, flag, null);
    }

    public void openMethod(String methodName, String type, short flag, String[] exceptions) {
        this.codeBuffer = new ByteBuffer();
        int sig = ClassFile.sizeOfParameters(type);
        int nlocals = sig & 0xFF;
        if ((flag & 8) != 8) {
            ++nlocals;
        }
        this.locals = new boolean[nlocals + 32];
        for (int i = 0; i < nlocals; ++i) {
            this.locals[i] = true;
        }
        this.maxLocal = nlocals;
        ExceptionAttr exceptionAttr = null;
        if (exceptions != null) {
            short exceptionAttributeIndex = this.constantPool.addUTF8("Exceptions");
            short[] e = new short[exceptions.length];
            for (int i = 0; i < exceptions.length; ++i) {
                e[i] = this.constantPool.addClass(exceptions[i]);
            }
            exceptionAttr = new ExceptionAttr(exceptionAttributeIndex, e);
        }
        this.currentMethod = new MethodInfo(this.constantPool.addUTF8(methodName), this.constantPool.addUTF8(type), flag, exceptionAttr);
        this.methods.addElement(this.currentMethod);
    }

    public void closeMethod() {
        if ((this.currentMethod.accessFlags & 0x400) == 1024) {
            return;
        }
        int codeSize = this.codeSize();
        if (codeSize > 65535) {
            throw new ClassFormatError("code size is too large " + codeSize);
        }
        int exceptionSize = 0;
        if (this.exceptionTable != null) {
            exceptionSize = this.exceptionTable.size();
        }
        int attrLength = 14 + codeSize + 2 + exceptionSize * 8 + 2;
        ByteBuffer codeAttr = new ByteBuffer(attrLength);
        short codeAttrIndex = this.constantPool.addUTF8("Code");
        codeAttr.add(codeAttrIndex);
        int attr_len = attrLength - 6;
        codeAttr.add(attr_len);
        codeAttr.add(this.maxStack);
        codeAttr.add((short)this.maxLocal);
        codeAttr.add(codeSize);
        codeAttr.append(this.codeBuffer);
        if (exceptionSize > 0) {
            codeAttr.add((short)this.exceptionTable.size());
            Enumeration e = this.exceptionTable.elements();
            while (e.hasMoreElements()) {
                ExceptionTableEntry entry = (ExceptionTableEntry)e.nextElement();
                codeAttr.add(entry.start.getPosition());
                codeAttr.add(entry.end.getPosition());
                codeAttr.add(entry.handler.getPosition());
                codeAttr.add(entry.catchType);
            }
        } else {
            codeAttr.add((short)0);
        }
        codeAttr.add((short)0);
        this.currentMethod.setCodeAttribute(codeAttr);
        this.exceptionTable = null;
        this.codeBuffer.setSize(0);
        this.currentMethod = null;
        this.maxStack = 0;
        this.stackTop = 0;
    }

    public void add(byte opcode) {
        this.codeBuffer.add(opcode);
        this.stackTop = (short)(this.stackTop + Opcode.stackGrowth[opcode & 0xFF]);
        if (this.stackTop > this.maxStack) {
            this.maxStack = this.stackTop;
        }
    }

    public void addByte(byte val) {
        this.codeBuffer.add(val);
    }

    public void addInt(int ival) {
        this.codeBuffer.add((byte)(ival >> 24 & 0xFF));
        this.codeBuffer.add((byte)(ival >> 16 & 0xFF));
        this.codeBuffer.add((byte)(ival >> 8 & 0xFF));
        this.codeBuffer.add((byte)(ival >> 0 & 0xFF));
    }

    public Label getLabel() {
        return this.getLabel(false);
    }

    public Label getLabel(boolean fixed) {
        Label label = new Label(this);
        if (fixed) {
            label.fix();
        }
        return label;
    }

    public int declareLocal() {
        if (this.maxLocal >= this.locals.length) {
            boolean[] new_locals = new boolean[this.locals.length * 2];
            System.arraycopy(this.locals, 0, new_locals, 0, this.locals.length);
            this.locals = new_locals;
        }
        this.locals[this.maxLocal] = true;
        return this.maxLocal++;
    }

    public int getLocal() {
        for (int i = 0; i < this.maxLocal; ++i) {
            if (this.locals[i]) continue;
            this.locals[i] = true;
            return i;
        }
        if (this.maxLocal >= this.locals.length) {
            boolean[] new_locals = new boolean[this.locals.length * 2];
            System.arraycopy(this.locals, 0, new_locals, 0, this.locals.length);
            this.locals = new_locals;
        }
        this.locals[this.maxLocal] = true;
        return this.maxLocal++;
    }

    public void freeLocal(int index) {
        this.locals[index] = false;
    }

    public void istoreLocal(int index) {
        if (index >= 0 && index < 4) {
            this.add((byte)(59 + index));
        } else {
            this.add((byte)54, index);
        }
    }

    public void iloadLocal(int index) {
        if (index >= 0 && index < 4) {
            this.add((byte)(26 + index));
        } else {
            this.add((byte)21, index);
        }
    }

    public void lloadLocal(int index) {
        if (index >= 0 && index < 4) {
            this.add((byte)(30 + index));
        } else {
            this.add((byte)22, index);
        }
    }

    public void floadLocal(int index) {
        if (index >= 0 && index < 4) {
            this.add((byte)(34 + index));
        } else {
            this.add((byte)23, index);
        }
    }

    public void dloadLocal(int index) {
        if (index >= 0 && index < 4) {
            this.add((byte)(38 + index));
        } else {
            this.add((byte)24, index);
        }
    }

    public void loadLocal(int index) {
        if (index >= 0 && index < 4) {
            this.add((byte)(42 + index));
        } else {
            this.add((byte)25, index);
        }
    }

    public void storeLocal(int index) {
        if (index >= 0 && index < 4) {
            this.add((byte)(75 + index));
        } else {
            this.add((byte)58, index);
        }
    }

    public void add(byte opcode, Label label) {
        switch (opcode) {
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -58: 
            case -57: {
                int pc = this.codeBuffer.size();
                this.codeBuffer.add(opcode);
                label.register(pc, 2);
                this.stackTop = (short)(this.stackTop + Opcode.stackGrowth[opcode & 0xFF]);
            }
        }
    }

    public void pushInteger(int number) {
        if (number >= -1 && number <= 5) {
            this.add((byte)(3 + number));
        } else if (number > -128 && number < 128) {
            this.add((byte)16, number);
        } else if (number > Short.MIN_VALUE && number < 32768) {
            this.add((byte)17, number);
        } else {
            this.add((byte)18, this.constantPool.addConstant(number));
        }
    }

    public void pushLong(long number) {
        if (number == 0L) {
            this.add((byte)9);
        } else if (number == 1L) {
            this.add((byte)10);
        } else {
            this.add((byte)20, this.constantPool.addConstant(number));
        }
    }

    public void pushFloat(float number) {
        if (number == 0.0f) {
            this.add((byte)11);
        } else if (number == 1.0f) {
            this.add((byte)12);
        } else if (number == 2.0f) {
            this.add((byte)13);
        } else {
            this.add((byte)19, this.constantPool.addConstant(number));
        }
    }

    public void pushDouble(double number) {
        if (number == 0.0) {
            this.add((byte)14);
        } else if (number == 1.0) {
            this.add((byte)15);
        } else {
            this.add((byte)20, this.constantPool.addConstant(number));
        }
    }

    public void add(byte opcode, int operand) {
        this.stackTop = (short)(this.stackTop + Opcode.stackGrowth[opcode & 0xFF]);
        if (this.stackTop > this.maxStack) {
            this.maxStack = this.stackTop;
        }
        switch (opcode) {
            case 16: {
                this.codeBuffer.add(opcode);
                this.codeBuffer.add((byte)operand);
                break;
            }
            case 17: {
                this.codeBuffer.add(opcode);
                this.codeBuffer.add((short)operand);
                break;
            }
            case -68: {
                this.codeBuffer.add(opcode);
                this.codeBuffer.add((byte)operand);
                break;
            }
            case -76: 
            case -75: {
                this.codeBuffer.add(opcode);
                this.codeBuffer.add(operand);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                if (operand >= 256 || opcode == 19 || opcode == 20) {
                    if (opcode == 18) {
                        this.codeBuffer.add((byte)19);
                    } else {
                        this.codeBuffer.add(opcode);
                    }
                    this.codeBuffer.add((short)operand);
                    break;
                }
                this.codeBuffer.add(opcode);
                this.codeBuffer.add((byte)operand);
                break;
            }
            case -87: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (operand >= 256) {
                    this.codeBuffer.add((byte)-60);
                    this.codeBuffer.add(opcode);
                    this.codeBuffer.add(operand);
                    break;
                }
                this.codeBuffer.add(opcode);
                this.codeBuffer.add((byte)operand);
                break;
            }
            default: {
                throw new ClassFileException("Unexpected opcode for 1 operand");
            }
        }
    }

    public void add(byte opcode, int operand1, int operand2) {
        this.stackTop = (short)(this.stackTop + Opcode.stackGrowth[opcode & 0xFF]);
        if (this.stackTop > this.maxStack) {
            this.maxStack = this.stackTop;
        }
        if (opcode == -124) {
            if (operand1 > 255 || operand2 < -128 || operand2 > 127) {
                this.codeBuffer.add((byte)-60);
                this.codeBuffer.add((byte)-124);
                this.codeBuffer.add((short)operand1);
                this.codeBuffer.add((short)operand2);
            } else {
                this.codeBuffer.add((byte)-124);
                this.codeBuffer.add((byte)operand1);
                this.codeBuffer.add((byte)operand2);
            }
        } else if (opcode == -59) {
            this.codeBuffer.add((byte)-59);
            this.codeBuffer.add((short)operand1);
            this.codeBuffer.add((byte)operand2);
        } else {
            throw new ClassFileException("Unexpected opcode for 2 operands");
        }
    }

    public void add(byte opcode, String className) {
        this.stackTop = (short)(this.stackTop + Opcode.stackGrowth[opcode & 0xFF]);
        switch (opcode) {
            case -69: 
            case -67: 
            case -64: 
            case -63: {
                short classIndex = this.constantPool.addClass(className);
                this.codeBuffer.add(opcode);
                this.codeBuffer.add(classIndex);
                break;
            }
            default: {
                throw new ClassFileException("bad opcode for class reference:" + opcode);
            }
        }
        if (this.stackTop > this.maxStack) {
            this.maxStack = this.stackTop;
        }
    }

    public void add(byte opcode, String className, String fieldName, String fieldType) {
        this.stackTop = (short)(this.stackTop + Opcode.stackGrowth[opcode & 0xFF]);
        char fieldTypeChar = fieldType.charAt(0);
        int fieldSize = fieldTypeChar == 'J' || fieldTypeChar == 'D' ? 2 : 1;
        switch (opcode) {
            case -78: 
            case -76: {
                this.stackTop = (short)(this.stackTop + fieldSize);
                break;
            }
            case -77: 
            case -75: {
                this.stackTop = (short)(this.stackTop - fieldSize);
                break;
            }
            default: {
                throw new ClassFileException("bad opcode for field reference:" + opcode);
            }
        }
        short fieldRefIndex = this.constantPool.addFieldRef(className, fieldName, fieldType);
        this.codeBuffer.add(opcode);
        this.codeBuffer.add(fieldRefIndex);
        if (this.stackTop > this.maxStack) {
            this.maxStack = this.stackTop;
        }
    }

    public void add(byte opcode, String className, String methodName, String parametersType, String returnType) {
        int info = ClassFile.sizeOfParameters(parametersType);
        int arg_size = info & 0xFFFF;
        this.stackTop = (short)(this.stackTop - arg_size);
        this.stackTop = (short)(this.stackTop + Opcode.stackGrowth[opcode & 0xFF]);
        if (this.stackTop > this.maxStack) {
            this.maxStack = this.stackTop;
        }
        switch (opcode) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.stackTop = (short)(this.stackTop + ClassFile.sizeOfReturn(returnType));
                this.codeBuffer.add(opcode);
                if (opcode == -71) {
                    short ifMethodRefIndex = this.constantPool.addInterfaceMethodRef(className, methodName, parametersType + returnType);
                    this.codeBuffer.add(ifMethodRefIndex);
                    this.codeBuffer.add((byte)(arg_size + 1));
                    this.codeBuffer.add((byte)0);
                    break;
                }
                short methodRefIndex = this.constantPool.addMethodRef(className, methodName, parametersType + returnType);
                this.codeBuffer.add(methodRefIndex);
                break;
            }
            default: {
                throw new ClassFileException("bad opcode for method reference:" + opcode);
            }
        }
        if (this.stackTop > this.maxStack) {
            this.maxStack = this.stackTop;
        }
    }

    public void reserveStack(int size) {
        this.stackTop = (short)(this.stackTop + size);
        if (this.stackTop > this.maxStack) {
            this.maxStack = this.stackTop;
        }
    }

    public static final int sizeOfReturn(String sig) {
        int size = 0;
        char c = sig.charAt(0);
        if (c != 'V') {
            size = c == 'J' || c == 'D' ? (size += 2) : ++size;
        }
        return size;
    }

    public static final int sizeOfParameters(String sig) {
        return ClassFile.sizeOfParameters(sig.toCharArray(), 1);
    }

    static int sizeOfParameters(char[] c, int offset) {
        int index = offset;
        int size = 0;
        int narg = 0;
        block7: while (index < c.length) {
            switch (c[index]) {
                case 'D': 
                case 'J': {
                    size += 2;
                    ++index;
                    ++narg;
                    continue block7;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++size;
                    ++index;
                    ++narg;
                    continue block7;
                }
                case '[': {
                    while (c[index] == '[') {
                        ++index;
                    }
                    if (c[index] != 'L') {
                        ++size;
                        ++index;
                        ++narg;
                        continue block7;
                    }
                }
                case 'L': {
                    ++size;
                    ++narg;
                    while (c[index++] != ';') {
                    }
                    continue block7;
                }
                case ')': {
                    break block7;
                }
                default: {
                    throw new ClassFileException("Bad signature character:" + c[index]);
                }
            }
        }
        return narg << 16 | size;
    }

    public void addExceptionHandler(Label startLabel, Label endLabel, Label handlerLabel, String catchClassName) {
        short catch_type = catchClassName != null ? this.constantPool.addClass(catchClassName) : (short)0;
        ExceptionTableEntry newEntry = new ExceptionTableEntry(startLabel, endLabel, handlerLabel, catch_type);
        if (this.exceptionTable == null) {
            this.exceptionTable = new Vector();
        }
        this.exceptionTable.addElement(newEntry);
    }

    public void write(OutputStream stream) throws IOException {
        int i;
        DataOutputStream out = stream instanceof DataOutputStream ? (DataOutputStream)stream : new DataOutputStream(stream);
        short sourceFileIndex = 0;
        if (this.sourceFileNameIndex != 0) {
            sourceFileIndex = this.constantPool.addUTF8("SourceFile");
        }
        out.writeLong(-3819410108756852691L);
        this.constantPool.write(out);
        out.writeShort(this.accessFlags);
        out.writeShort(this.thisClassIndex);
        out.writeShort(this.superClassIndex);
        out.writeShort(this.interfaces.size());
        for (i = 0; i < this.interfaces.size(); ++i) {
            out.writeShort(((Short)this.interfaces.elementAt(i)).shortValue());
        }
        out.writeShort(this.fields.size());
        for (i = 0; i < this.fields.size(); ++i) {
            ((FieldInfo)this.fields.elementAt(i)).write(out);
        }
        out.writeShort(this.methods.size());
        for (i = 0; i < this.methods.size(); ++i) {
            ((MethodInfo)this.methods.elementAt(i)).write(out);
        }
        if (this.sourceFileNameIndex != 0) {
            out.writeShort(1);
            out.writeShort(sourceFileIndex);
            out.writeInt(2);
            out.writeShort(this.sourceFileNameIndex);
        } else {
            out.writeShort(0);
        }
    }

    public static String signature(Class[] paramTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = 0; i < paramTypes.length; ++i) {
            buf.append(ClassFile.signature(paramTypes[i]));
        }
        buf.append(')');
        return buf.toString();
    }

    public static String signature(Class clazz) {
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz.isArray()) {
            return "[" + ClassFile.signature(clazz.getComponentType());
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.className + "]";
    }

    static class ExceptionTableEntry {
        Label start;
        Label end;
        Label handler;
        short catchType;

        ExceptionTableEntry(Label start, Label end, Label handler, short catchType) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.catchType = catchType;
        }
    }

    static class FieldInfo {
        private short nameIndex;
        private short descriptorIndex;
        private short accessFlags;
        private short[] attributes;

        FieldInfo(short nameIndex, short descriptorIndex, short accessFlags) {
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
            this.accessFlags = accessFlags;
        }

        FieldInfo(short nameIndex, short descriptorIndex, short accessFlags, short[] attributes) {
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
            this.accessFlags = accessFlags;
            this.attributes = attributes;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeShort(this.accessFlags);
            out.writeShort(this.nameIndex);
            out.writeShort(this.descriptorIndex);
            if (this.attributes == null) {
                out.writeShort(0);
            } else {
                out.writeShort(1);
                out.writeShort(this.attributes[0]);
                out.writeShort(this.attributes[1]);
                out.writeShort(this.attributes[2]);
                out.writeShort(this.attributes[3]);
            }
        }
    }

    static class MethodInfo {
        short nameIndex;
        short descriptorIndex;
        short accessFlags;
        ExceptionAttr exceptions;
        ByteBuffer codeAttribute;

        MethodInfo(short nameIndex, short descriptorIndex, short accessFlags, ExceptionAttr exceptions) {
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
            this.accessFlags = accessFlags;
            this.exceptions = exceptions;
        }

        ByteBuffer getCodeAttribute() {
            return this.codeAttribute;
        }

        void setCodeAttribute(ByteBuffer codeAttribute) {
            this.codeAttribute = codeAttribute;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeShort(this.accessFlags);
            out.writeShort(this.nameIndex);
            out.writeShort(this.descriptorIndex);
            int count = 0;
            if (this.codeAttribute != null) {
                ++count;
            }
            if (this.exceptions != null) {
                ++count;
            }
            out.writeShort(count);
            if (this.exceptions != null) {
                this.exceptions.write(out);
            }
            if (this.codeAttribute != null) {
                this.codeAttribute.writeTo(out);
            }
        }
    }

    static class ExceptionAttr {
        private short nameIndex;
        private short[] exceptionIndex;

        ExceptionAttr(short nameIndex, short[] exceptionIndex) {
            this.nameIndex = nameIndex;
            this.exceptionIndex = exceptionIndex;
        }

        void write(DataOutputStream out) throws IOException {
            out.writeShort(this.nameIndex);
            int n = this.exceptionIndex.length;
            out.writeInt(n * 2 + 2);
            out.writeShort(n);
            for (int i = 0; i < n; ++i) {
                out.writeShort(this.exceptionIndex[i]);
            }
        }
    }
}

