/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.pnuts.lang.ConstraintsTransformer;
import pnuts.compiler.ByteBuffer;
import pnuts.compiler.ClassFile;
import pnuts.compiler.ClassFileHandler;
import pnuts.compiler.CodeLoader;
import pnuts.compiler.CodeLoader0;
import pnuts.compiler.CompileContext;
import pnuts.compiler.Compiled;
import pnuts.compiler.FrameInfo;
import pnuts.compiler.Label;
import pnuts.compiler.MultiClassLoader;
import pnuts.compiler.Preprocessor;
import pnuts.compiler.Reference;
import pnuts.compiler.TranslateContext;
import pnuts.ext.UnparseVisitor;
import pnuts.lang.Context;
import pnuts.lang.Function;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.PnutsInterpreter;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.Visitor;

public class Compiler
extends Runtime
implements Visitor {
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = false;
    private static final Object INLINED_BOOLEAN = new Object();
    private static final Integer ONE = new Integer(1);
    private static PnutsInterpreter interpreter = new PnutsInterpreter();
    private static Preprocessor preproc = new Preprocessor();
    private static UnparseVisitor unparser;
    private static boolean optimize;
    static boolean hasBootClassLoader;
    static boolean hasJava2Security;
    static CodeLoaderFactory codeLoaderFactory;
    static CodeLoaderFactory privilegedCodeLoaderFactory;
    private static boolean proxyConf;
    private long s;
    boolean _includeLineNo = !optimize;
    boolean includeMainMethod = false;
    private long classCount = 0L;
    boolean automatic;
    String className;
    String runtimeClassName;
    boolean useDynamicProxy = proxyConf;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$pnuts$lang$Pnuts;

    static UnparseVisitor getUnparseVisitor() {
        if (unparser == null) {
            unparser = new UnparseVisitor(false);
        }
        return unparser;
    }

    static boolean getBoolean(String key) {
        String sval;
        Properties p = Pnuts.getDefaults();
        if (p != null && (sval = p.getProperty(key)) != null) {
            return sval.equalsIgnoreCase("true");
        }
        try {
            return Boolean.getBoolean(key);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Compiler() {
        this(null);
    }

    public Compiler(String className) {
        this(className, true);
    }

    public Compiler(String className, boolean automatic) {
        this(className, automatic, proxyConf);
    }

    public Compiler(String className, boolean automatic, boolean useDynamicProxy) {
        this.className = className == null ? "_pnuts_" : className;
        this.automatic = automatic;
        this.useDynamicProxy(useDynamicProxy);
    }

    public void includeLineNo(boolean flag) {
        this._includeLineNo = flag;
    }

    public void includeMainMethod(boolean flag) {
        this.includeMainMethod = flag;
    }

    public void useDynamicProxy(boolean flag) {
        this.useDynamicProxy = flag;
        this.runtimeClassName = flag ? "pnuts.compiler.DynamicRuntime" : "pnuts.lang.Runtime";
    }

    protected Object execute(CompileContext cc, Context context, boolean catchJump) {
        try {
            CodeLoader loader = Compiler.createCodeLoader(context.getClassLoader(), true);
            Class cls = cc.loadClasses(loader);
            Runtime rt = (Runtime)cls.newInstance();
            return rt.run(context);
        }
        catch (IOException io) {
            throw new PnutsException(io, context);
        }
        catch (InstantiationException ie) {
            throw new PnutsException(ie, context);
        }
        catch (IllegalAccessException iae) {
            throw new PnutsException(iae, context);
        }
    }

    public Object startSet(SimpleNode node, Context context) {
        if (!this._includeLineNo && context.isVerbose()) {
            this._includeLineNo = true;
        }
        return this.start(node, context);
    }

    public Object start(SimpleNode node, Context context) {
        try {
            return this._start(node, context, true);
        }
        catch (ClassFormatError cfe) {
            if (this.automatic) {
                return node.accept(interpreter, context);
            }
            throw cfe;
        }
    }

    Object _start(SimpleNode node, Context context, boolean catchJump) {
        CompileContext cc = this.automatic ? new CompileContext() : (CompileContext)context;
        cc.constClassName = this.className;
        ClassFile cf = cc.cf = new ClassFile(this.className, this.runtimeClassName, null, 1);
        cf.addInterface("pnuts.compiler.Compiled");
        cf.openMethod("<init>", "()V", (short)1);
        cf.add((byte)42);
        cf.add((byte)-73, this.runtimeClassName, "<init>", "()", "V");
        cf.add((byte)-79);
        cf.closeMethod();
        if (this.includeMainMethod) {
            cf.openMethod("main", "([Ljava/lang/String;)V", (short)9);
            cf.add((byte)-69, this.className);
            cf.add((byte)89);
            cf.add((byte)-73, this.className, "<init>", "()", "V");
            Label catchStart = cf.getLabel(true);
            cf.add((byte)-69, "pnuts.lang.Context");
            cf.add((byte)89);
            cf.add((byte)-73, "pnuts.lang.Context", "<init>", "()", "V");
            cf.add((byte)-71, "pnuts.lang.Executable", "run", "(Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            cf.add((byte)87);
            cf.add((byte)-79);
            Label catchEnd = cf.getLabel(true);
            Label catchTarget = cf.getLabel(true);
            cf.reserveStack(1);
            cf.add((byte)-74, "pnuts.lang.Jump", "getValue", "()", "Ljava/lang/Object;");
            cf.add((byte)87);
            cf.add((byte)-79);
            cf.addExceptionHandler(catchStart, catchEnd, catchTarget, "pnuts.lang.Jump");
            cf.closeMethod();
        }
        cf.openMethod("exec", "(Lpnuts/lang/Context;)Ljava/lang/Object;", (short)4);
        int ctx = 1;
        cc.setContextIndex(ctx);
        Label start = cf.getLabel(true);
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            int m = n - 1;
            for (int i = 0; i < m; ++i) {
                this.accept(node, i, cc);
                cf.add((byte)87);
            }
            this.accept(node, m, cc);
        } else {
            cf.add((byte)1);
        }
        cf.add((byte)-80);
        cf.closeMethod();
        cf.openMethod("<clinit>", "()V", (short)8);
        cf.addField("NO_PARAM", "[Ljava/lang/Object;", (short)8);
        cf.add((byte)3);
        cf.add((byte)-67, "java.lang.Object");
        cf.add((byte)-77, this.className, "NO_PARAM", "[Ljava/lang/Object;");
        Enumeration e = cc.constants.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            String k = (String)cc.constants.get(obj);
            if (obj instanceof Integer) {
                int value = (Integer)obj;
                cf.addField(k, "Ljava/lang/Integer;", (short)8);
                cf.add((byte)-69, "java.lang.Integer");
                cf.add((byte)89);
                cf.pushInteger(value);
                cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Integer;");
                continue;
            }
            if (obj instanceof Byte) {
                byte value = (Byte)obj;
                cf.addField(k, "Ljava/lang/Byte;", (short)8);
                cf.add((byte)-69, "java.lang.Byte");
                cf.add((byte)89);
                cf.pushInteger(value);
                cf.add((byte)-73, "java.lang.Byte", "<init>", "(B)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Byte;");
                continue;
            }
            if (obj instanceof Character) {
                char value = ((Character)obj).charValue();
                cf.addField(k, "Ljava/lang/Character;", (short)8);
                cf.add((byte)-69, "java.lang.Character");
                cf.add((byte)89);
                cf.pushInteger(value);
                cf.add((byte)-73, "java.lang.Character", "<init>", "(C)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Character;");
                continue;
            }
            if (obj instanceof Long) {
                long value = (Long)obj;
                cf.addField(k, "Ljava/lang/Long;", (short)8);
                cf.add((byte)-69, "java.lang.Long");
                cf.add((byte)89);
                cf.pushLong(value);
                cf.add((byte)-73, "java.lang.Long", "<init>", "(J)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Long;");
                continue;
            }
            if (obj instanceof Float) {
                float value = ((Float)obj).floatValue();
                cf.addField(k, "Ljava/lang/Float;", (short)8);
                cf.add((byte)-69, "java.lang.Float");
                cf.add((byte)89);
                cf.pushFloat(value);
                cf.add((byte)-73, "java.lang.Float", "<init>", "(F)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Float;");
                continue;
            }
            if (obj instanceof Double) {
                double value = (Double)obj;
                cf.addField(k, "Ljava/lang/Double;", (short)8);
                cf.add((byte)-69, "java.lang.Double");
                cf.add((byte)89);
                cf.pushDouble(value);
                cf.add((byte)-73, "java.lang.Double", "<init>", "(D)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/lang/Double;");
                continue;
            }
            if (obj instanceof BigDecimal) {
                cf.addField(k, "Ljava/math/BigDecimal;", (short)8);
                cf.add((byte)-69, "java.math.BigDecimal");
                cf.add((byte)89);
                cf.add((byte)18, cf.addConstant(obj.toString()));
                cf.add((byte)-73, "java.math.BigDecimal", "<init>", "(Ljava/lang/String;)", "V");
                cf.add((byte)-77, this.className, k, "Ljava/math/BigDecimal;");
                continue;
            }
            if (!(obj instanceof BigInteger)) continue;
            cf.addField(k, "Ljava/math/BigInteger;", (short)8);
            cf.add((byte)-69, "java.math.BigInteger");
            cf.add((byte)89);
            cf.add((byte)18, cf.addConstant(obj.toString()));
            cf.add((byte)-73, "java.math.BigInteger", "<init>", "(Ljava/lang/String;)", "V");
            cf.add((byte)-77, this.className, k, "Ljava/math/BigInteger;");
        }
        cf.add((byte)-79);
        cf.closeMethod();
        if (this.automatic) {
            return this.execute(cc, context, catchJump);
        }
        return null;
    }

    public Object expressionList(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            int m = n - 1;
            for (int i = 0; i < m; ++i) {
                this.accept(node, i, context);
                cf.add((byte)87);
            }
            this.accept(node, m, context);
        } else {
            cf.add((byte)1);
        }
        return null;
    }

    public Object integerNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        String str = node.str;
        Object[] p = (Object[])node.info;
        Number n = (Number)p[0];
        String assoc = (String)cc.constants.get(n);
        if (assoc == null) {
            assoc = Compiler.gensym(context);
            cc.constants.put(n, assoc);
        }
        if (n instanceof Integer) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Integer;");
        } else if (n instanceof Long) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Long;");
        } else if (n instanceof Byte) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Byte;");
        } else if (n instanceof BigInteger) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigInteger;");
        } else if (n instanceof BigDecimal) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigDecimal;");
        } else {
            throw new InternalError("compiler error");
        }
        if (p[1] != null) {
            int offset = ((int[])p[1])[0];
            cf.add((byte)-64, "java.lang.Number");
            cf.add((byte)18, cf.addConstant(str.substring(0, offset)));
            cf.add((byte)18, cf.addConstant(str.substring(offset)));
            cf.loadLocal(cc.getContextIndex());
            cf.add((byte)-72, "pnuts.lang.Runtime", "quantity", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object floatingNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        String str = node.str;
        Object[] p = (Object[])node.info;
        Number n = (Number)p[0];
        String assoc = (String)cc.constants.get(n);
        if (assoc == null) {
            assoc = Compiler.gensym(context);
            cc.constants.put(n, assoc);
        }
        if (n instanceof Float) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Float;");
        } else if (n instanceof Double) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Double;");
        } else if (n instanceof BigDecimal) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigDecimal;");
        } else {
            throw new InternalError("compiler error");
        }
        if (p[1] != null) {
            int offset = ((int[])p[1])[0];
            cf.add((byte)-64, "java.lang.Number");
            cf.add((byte)18, cf.addConstant(str.substring(0, offset)));
            cf.add((byte)18, cf.addConstant(str.substring(offset)));
            cf.loadLocal(cc.getContextIndex());
            cf.add((byte)-72, "pnuts.lang.Runtime", "quantity", "(Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object stringNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        cf.add((byte)18, cf.addConstant(node.str));
        return null;
    }

    public Object characterNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        Character ch = (Character)node.info;
        String assoc = (String)cc.constants.get(ch);
        if (assoc == null) {
            assoc = Compiler.gensym(context);
            cc.constants.put(ch, assoc);
        }
        cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Character;");
        return null;
    }

    public Object classNode(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        int n = node.jjtGetNumChildren();
        String name = node.str;
        if (name == null) {
            cf.add((byte)-78, "pnuts.lang.PnutsFunction", "CLASS", "Lpnuts/lang/PnutsFunction;");
            return null;
        }
        for (int i = 0; i < n; ++i) {
            SimpleNode ch = node.jjtGetChild(i);
            if (ch.id != 9) continue;
            name = name + ".";
            name = name + ch.str;
        }
        cf.add((byte)18, cf.addConstant(name));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Pnuts", "loadClass", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Class;");
        return null;
    }

    void booleanCheck(int id, ClassFile cf, Context context) {
        if (id != 22 && id != 23 && id != 47 && id != 45 && id != 48 && id != 46 && id != 42 && id != 43 && id != 44 && id != 39 && id != 41 && id != 60) {
            int index = cf.getLocal();
            cf.add((byte)89);
            cf.storeLocal(index);
            cf.add((byte)-63, "java.lang.Boolean");
            Label l_next = cf.getLabel();
            cf.add((byte)-102, l_next);
            this.error(cf, "boolean.expected", new int[]{index}, (CompileContext)context);
            l_next.fix();
            cf.loadLocal(index);
            cf.freeLocal(index);
        }
    }

    public Object logAndNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
        cf.add((byte)-64, "java.lang.Boolean");
        int tgt1 = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt1);
        cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
        Label l_else = cf.getLabel();
        cf.add((byte)-103, l_else);
        this.accept(node, 1, context);
        this.booleanCheck(node.jjtGetChild((int)1).id, cf, context);
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        l_else.fix();
        cf.loadLocal(tgt1);
        next.fix();
        cf.freeLocal(tgt1);
        return null;
    }

    public Object logOrNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
        cf.add((byte)-64, "java.lang.Boolean");
        int tgt1 = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt1);
        cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
        Label l_else = cf.getLabel();
        cf.add((byte)-102, l_else);
        this.accept(node, 1, context);
        this.booleanCheck(node.jjtGetChild((int)1).id, cf, context);
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        l_else.fix();
        cf.loadLocal(tgt1);
        next.fix();
        cf.freeLocal(tgt1);
        return null;
    }

    public Object logNotNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
        cf.add((byte)-64, "java.lang.Boolean");
        cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
        Label t = cf.getLabel();
        Label next = cf.getLabel();
        cf.add((byte)-103, t);
        cf.add((byte)-78, "java.lang.Boolean", "FALSE", "Ljava/lang/Boolean;");
        cf.add((byte)-89, next);
        t.fix();
        cf.add((byte)-78, "java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
        next.fix();
        return null;
    }

    static boolean canConstantFold(SimpleNode node) {
        return Compiler.isConstant(node.jjtGetChild(0)) && Compiler.isConstant(node.jjtGetChild(1));
    }

    static boolean isConstant(SimpleNode node) {
        switch (node.id) {
            case 18: 
            case 19: {
                Object[] p = (Object[])node.info;
                return p[1] == null;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    Object binary(String operator, SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        SimpleNode n0 = node.jjtGetChild(0);
        SimpleNode n1 = node.jjtGetChild(1);
        n0.accept(this, context);
        n1.accept(this, context);
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", operator, "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        return null;
    }

    public Object shiftLeftNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Compiler.addConstant(interpreter.shiftLeftNode(node, context), context);
            return null;
        }
        return this.binary("shiftLeft", node, context);
    }

    public Object shiftRightNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Compiler.addConstant(interpreter.shiftRightNode(node, context), context);
            return null;
        }
        return this.binary("shiftRight", node, context);
    }

    public Object shiftArithmeticNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Compiler.addConstant(interpreter.shiftArithmeticNode(node, context), context);
            return null;
        }
        return this.binary("shiftArithmetic", node, context);
    }

    static void addConstant(Object n, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        if (n instanceof String) {
            cf.add((byte)18, cf.addConstant((String)n));
            return;
        }
        String assoc = (String)cc.constants.get(n);
        if (assoc == null) {
            assoc = Compiler.gensym(cc);
            cc.constants.put(n, assoc);
        }
        if (n instanceof Integer) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Integer;");
        } else if (n instanceof Long) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Long;");
        } else if (n instanceof Byte) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Byte;");
        } else if (n instanceof BigInteger) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigInteger;");
        } else if (n instanceof BigDecimal) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/math/BigDecimal;");
        } else if (n instanceof Float) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Float;");
        } else if (n instanceof Double) {
            cf.add((byte)-78, cc.constClassName, assoc, "Ljava/lang/Double;");
        } else {
            throw new InternalError("compiler error");
        }
    }

    public Object addNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Compiler.addConstant(interpreter.addNode(node, context), context);
            return null;
        }
        return this.binary("add", node, context);
    }

    public Object subtractNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Compiler.addConstant(interpreter.subtractNode(node, context), context);
            return null;
        }
        return this.binary("subtract", node, context);
    }

    public Object multNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Compiler.addConstant(interpreter.multNode(node, context), context);
            return null;
        }
        return this.binary("multiply", node, context);
    }

    public Object divideNode(SimpleNode node, Context context) {
        try {
            if (Compiler.canConstantFold(node)) {
                Compiler.addConstant(interpreter.divideNode(node, context), context);
                return null;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return this.binary("divide", node, context);
    }

    public Object modNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Compiler.addConstant(interpreter.modNode(node, context), context);
            return null;
        }
        return this.binary("mod", node, context);
    }

    public Object xorNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Object xor = interpreter.xorNode(node, context);
            if (xor instanceof Number) {
                Compiler.addConstant(xor, context);
                return null;
            }
            if (xor instanceof Boolean) {
                CompileContext cc = (CompileContext)context;
                ClassFile cf = cc.cf;
                if (((Boolean)xor).booleanValue()) {
                    cf.add((byte)3);
                } else {
                    cf.add((byte)4);
                }
            }
        }
        return this.binary("xor", node, context);
    }

    public Object orNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Object or = interpreter.orNode(node, context);
            if (or instanceof Number) {
                Compiler.addConstant(or, context);
                return null;
            }
            if (or instanceof Boolean) {
                CompileContext cc = (CompileContext)context;
                ClassFile cf = cc.cf;
                if (((Boolean)or).booleanValue()) {
                    cf.add((byte)3);
                } else {
                    cf.add((byte)4);
                }
            }
        }
        return this.binary("or", node, context);
    }

    public Object andNode(SimpleNode node, Context context) {
        if (Compiler.canConstantFold(node)) {
            Object and = interpreter.andNode(node, context);
            if (and instanceof Number) {
                Compiler.addConstant(and, context);
                return null;
            }
            if (and instanceof Boolean && ((Boolean)and).booleanValue()) {
                CompileContext cc = (CompileContext)context;
                ClassFile cf = cc.cf;
                if (((Boolean)and).booleanValue()) {
                    cf.add((byte)3);
                } else {
                    cf.add((byte)4);
                }
            }
        }
        return this.binary("and", node, context);
    }

    Object unary(String operator, SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        int ctx = cc.getContextIndex();
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", operator, "(Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        return null;
    }

    public Object negativeNode(SimpleNode node, Context context) {
        return this.unary("negate", node, context);
    }

    public Object notNode(SimpleNode node, Context context) {
        return this.unary("not", node, context);
    }

    Object bool(String operator, SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.accept(node, 0, cc);
        this.accept(node, 1, cc);
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", operator, "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Z");
        int id = node.jjtGetParent().id;
        if (id == 69 || id == 70 || id == 73 || id == 72) {
            node.info = INLINED_BOOLEAN;
        } else {
            Label deny = cf.getLabel();
            cf.add((byte)-103, deny);
            cf.add((byte)-78, "java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
            Label next = cf.getLabel();
            cf.add((byte)-89, next);
            deny.fix();
            cf.add((byte)-78, "java.lang.Boolean", "FALSE", "Ljava/lang/Boolean;");
            next.fix();
        }
        return null;
    }

    public Object ltNode(SimpleNode node, Context context) {
        return this.bool("lt", node, context);
    }

    public Object leNode(SimpleNode node, Context context) {
        return this.bool("le", node, context);
    }

    public Object gtNode(SimpleNode node, Context context) {
        return this.bool("gt", node, context);
    }

    public Object geNode(SimpleNode node, Context context) {
        return this.bool("ge", node, context);
    }

    public Object equalNode(SimpleNode node, Context context) {
        return this.bool("eq", node, context);
    }

    public Object notEqNode(SimpleNode node, Context context) {
        return this.bool("ne", node, context);
    }

    public Object ifStatement(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(line);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        SimpleNode condNode = node.jjtGetChild(0);
        condNode.accept(this, context);
        Label l_else = cf.getLabel();
        Label next = cf.getLabel();
        if (condNode.info == INLINED_BOOLEAN) {
            cf.add((byte)-103, l_else);
            this.accept(node, 1, context);
            cf.add((byte)-89, next);
            l_else.fix();
        } else {
            this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
            cf.add((byte)-64, "java.lang.Boolean");
            cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
            cf.add((byte)-103, l_else);
            this.accept(node, 1, context);
            cf.add((byte)-89, next);
            l_else.fix();
        }
        int n = node.jjtGetNumChildren();
        boolean j = false;
        for (int i = 2; i < n; ++i) {
            SimpleNode _node = node.jjtGetChild(i);
            if (_node.id == 70) {
                SimpleNode _condNode = _node.jjtGetChild(0);
                _condNode.accept(this, context);
                Label next_else = cf.getLabel();
                if (_condNode.info == INLINED_BOOLEAN) {
                    cf.add((byte)-103, next_else);
                    this.accept(_node, 1, context);
                    cf.add((byte)-89, next);
                    next_else.fix();
                    continue;
                }
                this.booleanCheck(_node.jjtGetChild((int)0).id, cf, context);
                cf.add((byte)-64, "java.lang.Boolean");
                cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
                cf.add((byte)-103, next_else);
                this.accept(_node, 1, context);
                cf.add((byte)-89, next);
                next_else.fix();
                continue;
            }
            if (_node.id != 71) continue;
            this.accept(_node, 0, context);
            if (i == n - 1) {
                next.fix();
                return null;
            }
            cf.add((byte)-89, next);
        }
        cf.add((byte)1);
        next.fix();
        return null;
    }

    static boolean isLeafFrame(SimpleNode node) {
        FrameInfo info = (FrameInfo)node.info;
        if (!info.leafCheckDone) {
            Compiler.scanLeafFrames(node);
        }
        return info.isLeaf;
    }

    static boolean scanLeafFrames(SimpleNode node) {
        boolean c2;
        FrameInfo info;
        boolean c = true;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode child = node.jjtGetChild(i);
            if (Compiler.scanLeafFrames(child)) continue;
            if (node.id == 82) {
                info = (FrameInfo)node.info;
                if (info == null) {
                    info = new FrameInfo();
                    node.info = info;
                }
                info.isLeaf = false;
                info.leafCheckDone = true;
            }
            c = false;
        }
        boolean c1 = node.id != 82;
        boolean bl = c2 = c && c1;
        if (node.id == 82) {
            info = (FrameInfo)node.info;
            if (info == null) {
                info = new FrameInfo();
                node.info = info;
            }
            info.isLeaf = c;
            info.leafCheckDone = true;
        }
        return c2;
    }

    void preprocess(SimpleNode node) {
        node.accept(preproc, new TranslateContext());
    }

    /*
     * Unable to fully structure code
     */
    public Object functionStatement(SimpleNode node, Context context) {
        info = (FrameInfo)node.info;
        if (info == null) {
            info = new FrameInfo();
            node.info = info;
        }
        if (!info.preprocessed) {
            this.preprocess(node);
        }
        cc = (CompileContext)context;
        ctx = cc.getContextIndex();
        cf = cc.cf;
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        block = null;
        param = null;
        n = node.jjtGetChild(0);
        if (n.id == 83) {
            param = n;
            block = node.jjtGetChild(1);
        } else if (n.id == 68) {
            block = n;
        }
        nargs = param.jjtGetNumChildren();
        locals = new String[nargs];
        n0 = null;
        if (nargs != 1) ** GOTO lbl-1000
        n0 = param.jjtGetChild(0);
        if (n0.id == 17) {
            nargs = -1;
            locals[0] = n0.jjtGetChild((int)0).str;
        } else lbl-1000:
        // 3 sources

        {
            for (j = 0; j < nargs; ++j) {
                locals[j] = param.jjtGetChild((int)j).str;
            }
        }
        cls = this.className + "$" + (this.classCount++ & 0x7FFFFFFFFFFFFFFFL);
        cf = new ClassFile(cls, "pnuts.lang.Function", null, 1);
        cf.addInterface("pnuts.compiler.Compiled");
        cc.classFiles.addElement(cf);
        cf.parent = cc.cf;
        cf.openMethod("register", "(Lpnuts/lang/PnutsFunction;Z)Lpnuts/lang/PnutsFunction;", (short)1);
        cf.add((byte)42);
        cf.add((byte)43);
        cf.add((byte)28);
        cf.add((byte)-73, "pnuts.lang.Function", "register", "(Lpnuts/lang/PnutsFunction;Z)", "Lpnuts/lang/PnutsFunction;");
        cf.add((byte)-80);
        cf.closeMethod();
        cf.openMethod("unparse", "(Lpnuts/lang/Context;)Ljava/lang/String;", (short)4);
        cf.add((byte)18, cf.addConstant((String)node.accept(Compiler.getUnparseVisitor(), context)));
        cf.add((byte)-80);
        cf.closeMethod();
        fname = node.str;
        cc._openFrame(fname, locals, Compiler.isLeafFrame(node));
        cf.openMethod("exec", "([Ljava/lang/Object;Lpnuts/lang/Context;)Ljava/lang/Object;", (short)4);
        cc2 = (CompileContext)cc.clone();
        cc2.line = -1;
        cc2.cf = cf;
        cc2.setContextIndex(2);
        cc2.returnLabel = cf.getLabel();
        code = cf.codeBuffer;
        cf.codeBuffer = blockCode = new ByteBuffer();
        if (fname != null) {
            f = cf.getLocal();
            cc2._declare(fname, f, -1);
            cf.add((byte)42);
            cf.add((byte)-76, "pnuts.lang.Function", "function", "Lpnuts/lang/PnutsFunction;");
            cf.storeLocal(f);
        }
        expt = cf.getLocal();
        cc2._declare("!exception", expt, -1);
        block.accept(this, cc2);
        cc2.returnLabel.fix();
        cf.codeBuffer = code;
        keys = cc.env.bottom.keys;
        infos = cc.env.bottom.info;
        count = cc.env.bottom.count;
        for (i = 0; i < cc.env.bottom.count; ++i) {
            cf.add((byte)1);
            cf.storeLocal(infos[i].map);
        }
        eref = cc2.getReference("!exception");
        cf.add((byte)1);
        cf.storeLocal(eref.index);
        catchStart = cf.getLabel(true);
        blockCode.prepend(code);
        cf.codeBuffer = blockCode;
        cf.add((byte)-80);
        catchEnd = cf.getLabel(true);
        catchTarget = cf.getLabel(true);
        cf.reserveStack(1);
        caught = cf.getLocal();
        cf.storeLocal(caught);
        cf.loadLocal(cc2.getContextIndex());
        cf.loadLocal(caught);
        cf.loadLocal(eref.index);
        cf.add((byte)-64, "pnuts.lang.Runtime$TypeMap");
        cf.add((byte)-72, "pnuts.lang.Runtime", "checkException", "(Lpnuts/lang/Context;Ljava/lang/Throwable;Lpnuts/lang/Runtime$TypeMap;)", "V");
        cf.add((byte)1);
        cf.add((byte)-80);
        cf.addExceptionHandler(catchStart, catchEnd, catchTarget, "java.lang.Throwable");
        arg = new StringBuffer("(Ljava/lang/String;[Ljava/lang/String;ILpnuts/lang/SimpleNode;Lpnuts/lang/Package;Lpnuts/lang/Context;");
        n_names = 0;
        if (cc.env.imports != null) {
            n_names = cc.env.imports.size();
        }
        names = new String[n_names];
        j = 0;
        if (n_names > 0) {
            e = cc.env.imports.elements();
            while (e.hasMoreElements()) {
                sym = (String)e.nextElement();
                names[j++] = sym;
                arg.append("[Ljava/lang/Object;");
            }
        }
        cf.closeMethod();
        cc._closeFrame();
        arg.append(")V");
        cf.openMethod("<init>", arg.toString(), (short)0);
        cf.add((byte)42);
        cf.add((byte)43);
        cf.add((byte)44);
        cf.add((byte)29);
        cf.add((byte)25, 4);
        cf.add((byte)25, 5);
        cf.add((byte)25, 6);
        cf.add((byte)-73, "pnuts.lang.Function", "<init>", "(Ljava/lang/String;[Ljava/lang/String;ILpnuts/lang/SimpleNode;Lpnuts/lang/Package;Lpnuts/lang/Context;)", "V");
        for (i = 0; i < n_names; ++i) {
            cf.addField(names[i], "[Ljava/lang/Object;", (short)0);
            cf.add((byte)42);
            cf.add((byte)25, 7 + i);
            cf.add((byte)-75, cf.getClassName(), names[i], "[Ljava/lang/Object;");
        }
        cf.add((byte)-79);
        cf.closeMethod();
        cf = cc.cf;
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Context", "getCurrentPackage", "()", "Lpnuts/lang/Package;");
        pkg = cf.getLocal();
        cf.storeLocal(pkg);
        cf.add((byte)-69, cls);
        cf.add((byte)89);
        fnameIndex = 0;
        if (fname != null) {
            fnameIndex = cf.addConstant(fname);
            cf.add((byte)18, fnameIndex);
        } else {
            cf.add((byte)1);
        }
        cf.pushInteger(locals.length);
        cf.add((byte)-67, "java.lang.String");
        for (i = 0; i < locals.length; ++i) {
            cf.add((byte)89);
            cf.pushInteger(i);
            cf.add((byte)18, cf.addConstant(locals[i]));
            cf.add((byte)83);
        }
        cf.pushInteger(nargs);
        cf.add((byte)1);
        cf.loadLocal(pkg);
        cf.loadLocal(ctx);
        arg2 = "(Ljava/lang/String;[Ljava/lang/String;ILpnuts/lang/SimpleNode;Lpnuts/lang/Package;Lpnuts/lang/Context;";
        exports = (Vector)cc.env.exports.get(cc2.env);
        if (exports != null) {
            size = exports.size();
            for (i = 0; i < size; ++i) {
                arg2 = arg2 + "[Ljava/lang/Object;";
                ref = (Reference)exports.elementAt(i);
                if (ref.index < 0) {
                    cf.add((byte)42);
                    cf.add((byte)-76, cf.getClassName(), ref.symbol, "[Ljava/lang/Object;");
                    continue;
                }
                if (ref.offset < 0) {
                    cf.add((byte)4);
                    cf.add((byte)-67, "java.lang.Object");
                    cf.add((byte)89);
                    cf.add((byte)3);
                    cf.loadLocal(ref.index);
                    cf.add((byte)83);
                    continue;
                }
                cf.loadLocal(ref.index);
                cf.add((byte)-64, "[Ljava/lang/Object;");
            }
        }
        cf.add((byte)-73, cls, "<init>", arg2 + ")", "V");
        func = cf.getLocal();
        cf.storeLocal(func);
        pfunc = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(pfunc);
        ref = null;
        ref2 = null;
        if (fname == null) ** GOTO lbl250
        ref = cc.env.getReference(fname);
        ref2 = cc.getReference(fname);
        if (ref != null) {
            ref.get(cc);
            cf.storeLocal(pfunc);
            cf.loadLocal(pfunc);
            cf.add((byte)-63, "pnuts.lang.PnutsFunction");
            instance = cf.getLabel();
            cf.add((byte)-102, instance);
            cf.add((byte)1);
            cf.storeLocal(pfunc);
            instance.fix();
            cf.loadLocal(func);
            cf.loadLocal(pfunc);
            cf.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf.add((byte)3);
            cf.add((byte)-74, cls, "register", "(Lpnuts/lang/PnutsFunction;Z)", "Lpnuts/lang/PnutsFunction;");
            cf.storeLocal(pfunc);
        } else if (ref2 != null) {
            ref2.get(cc);
            cf.storeLocal(pfunc);
            cf.loadLocal(pfunc);
            cf.add((byte)-63, "pnuts.lang.PnutsFunction");
            instance = cf.getLabel();
            cf.add((byte)-102, instance);
            cf.add((byte)1);
            cf.storeLocal(pfunc);
            instance.fix();
            cf.loadLocal(func);
            cf.loadLocal(pfunc);
            cf.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf.add((byte)4);
            cf.add((byte)-74, cls, "register", "(Lpnuts/lang/PnutsFunction;Z)", "Lpnuts/lang/PnutsFunction;");
            cf.storeLocal(pfunc);
        } else {
            if (cc.env.parent != null) {
                cf.loadLocal(func);
                cf.add((byte)18, fnameIndex);
                cf.loadLocal(pkg);
                cf.add((byte)-72, "pnuts.lang.Runtime", "defineUnboundFunction", "(Lpnuts/lang/Function;Ljava/lang/String;Lpnuts/lang/Package;)", "Lpnuts/lang/PnutsFunction;");
                cf.storeLocal(pfunc);
                cc.declare(fname);
                ref = cc.getReference(fname);
                ref.set(cf, pfunc);
                cf.loadLocal(pfunc);
                return null;
            }
            cf.loadLocal(func);
            cf.add((byte)18, fnameIndex);
            cf.loadLocal(pkg);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "defineTopLevelFunction", "(Lpnuts/lang/Function;Ljava/lang/String;Lpnuts/lang/Package;Lpnuts/lang/Context;)", "Lpnuts/lang/PnutsFunction;");
            return null;
lbl250:
            // 1 sources

            cf.loadLocal(func);
            cf.add((byte)1);
            cf.add((byte)3);
            cf.add((byte)-74, cls, "register", "(Lpnuts/lang/PnutsFunction;Z)", "Lpnuts/lang/PnutsFunction;");
            return null;
        }
        if (cc.env.parent != null) {
            if (ref == null) {
                cc.declare(fname);
                ref = cc.getReference(fname);
            }
            ref.set(cf, pfunc);
            cf.loadLocal(pfunc);
        } else {
            cf.loadLocal(pkg);
            cf.add((byte)18, fnameIndex);
            cf.loadLocal(pfunc);
            cf.loadLocal(ctx);
            cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
            cf.loadLocal(pfunc);
        }
        cf.freeLocal(func);
        cf.freeLocal(pfunc);
        cf.freeLocal(pkg);
        return null;
    }

    public Object applicationNode(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        cf.loadLocal(ctx);
        this.accept(node, 0, context);
        this.accept(node, 1, context);
        SimpleNode argNode = node.jjtGetChild(1);
        int nargs = argNode.jjtGetNumChildren();
        boolean types_created = false;
        for (int i = 0; i < nargs; ++i) {
            SimpleNode n = argNode.jjtGetChild(i);
            if (n.id != 62) continue;
            if (!types_created) {
                cf.pushInteger(nargs);
                cf.add((byte)-67, "java.lang.Class");
                types_created = true;
            }
            cf.add((byte)89);
            cf.pushInteger(i);
            this.accept(n, 0, context);
            cf.add((byte)83);
        }
        if (!types_created) {
            cf.add((byte)1);
        }
        if (this._includeLineNo) {
            cf.pushInteger(node.beginLine);
            cf.add((byte)-72, "pnuts.lang.Runtime", "call", "(Lpnuts/lang/Context;Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Class;I)", "Ljava/lang/Object;");
        } else {
            cf.add((byte)-72, "pnuts.lang.Runtime", "call", "(Lpnuts/lang/Context;Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Class;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object blockNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            int m = n - 1;
            for (int i = 0; i < m; ++i) {
                this.accept(node, i, context);
                cf.add((byte)87);
            }
            this.accept(node, m, context);
        } else {
            cf.add((byte)1);
        }
        return null;
    }

    public Object trueNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        cc.cf.add((byte)-78, "java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
        return null;
    }

    public Object falseNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        cc.cf.add((byte)-78, "java.lang.Boolean", "FALSE", "Ljava/lang/Boolean;");
        return null;
    }

    public Object nullNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        cc.cf.add((byte)1);
        return null;
    }

    public Object idNode(SimpleNode node, Context context) {
        Reference ref;
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        String symbol = node.str;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        if ((ref = cc.getReference(symbol)) != null) {
            ref.get(cc);
        } else {
            cf.loadLocal(ctx);
            cf.add((byte)18, cf.addConstant(symbol));
            cf.add((byte)-74, "pnuts.lang.Context", "getId", "(Ljava/lang/String;)", "Ljava/lang/Object;");
        }
        return null;
    }

    public Object global(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        cf.add((byte)18, cf.addConstant(""));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int gbl = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(gbl);
        Label else_ = cf.getLabel();
        cf.add((byte)-58, else_);
        cf.loadLocal(gbl);
        short symbol = cf.addConstant(node.str);
        cf.add((byte)18, symbol);
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "lookup", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/NamedValue;");
        int val = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(val);
        cf.add((byte)-58, else_);
        cf.loadLocal(val);
        cf.add((byte)-71, "pnuts.lang.Value", "get", "()", "Ljava/lang/Object;");
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        else_.fix();
        this.errorSymbol(cf, "not.defined", symbol, cc);
        next.fix();
        cf.freeLocal(gbl);
        return null;
    }

    public Object listElements(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int n = node.jjtGetNumChildren();
        if (n == 0) {
            cf.add((byte)-78, cc.constClassName, "NO_PARAM", "[Ljava/lang/Object;");
        } else {
            cf.pushInteger(n);
            cf.add((byte)-67, "java.lang.Object");
            for (int i = 0; i < n; ++i) {
                cf.add((byte)89);
                cf.pushInteger(i);
                this.accept(node, i, context);
                cf.add((byte)83);
            }
        }
        return null;
    }

    public Object castExpression(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        cf.loadLocal(ctx);
        this.accept(node, 0, context);
        cf.add((byte)-64, "java.lang.Class");
        this.accept(node, 1, context);
        cf.add((byte)4);
        cf.add((byte)-72, "pnuts.lang.Runtime", "cast", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/Object;Z)", "Ljava/lang/Object;");
        return null;
    }

    public Object memberNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        Label else_end = cf.getLabel();
        if ("length".equals(node.str)) {
            cf.loadLocal(tgt);
            cf.add((byte)-72, "pnuts.lang.Runtime", "isArray", "(Ljava/lang/Object;)", "Z");
            Label else_ = cf.getLabel();
            cf.add((byte)-103, else_);
            cf.add((byte)-69, "java.lang.Integer");
            cf.add((byte)89);
            cf.loadLocal(tgt);
            cf.add((byte)-72, "java.lang.reflect.Array", "getLength", "(Ljava/lang/Object;)", "I");
            cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
            cf.add((byte)-89, else_end);
            else_.fix();
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.add((byte)18, cf.addConstant(node.str));
        cf.add((byte)-72, "pnuts.lang.Runtime", "getField", "(Lpnuts/lang/Context;Ljava/lang/Object;Ljava/lang/String;)", "Ljava/lang/Object;");
        else_end.fix();
        cf.freeLocal(tgt);
        return null;
    }

    public Object methodNode(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        SimpleNode argNode = node.jjtGetChild(1);
        int nargs = argNode.jjtGetNumChildren();
        boolean types_created = false;
        for (int i = 0; i < nargs; ++i) {
            SimpleNode n = argNode.jjtGetChild(i);
            if (n.id != 62) continue;
            if (!types_created) {
                cf.pushInteger(nargs);
                cf.add((byte)-67, "java.lang.Class");
                types_created = true;
            }
            cf.add((byte)89);
            cf.pushInteger(i);
            this.accept(n, 0, context);
            cf.add((byte)83);
        }
        int types = cf.getLocal();
        if (types_created) {
            cf.storeLocal(types);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.add((byte)-74, "java.lang.Object", "getClass", "()", "Ljava/lang/Class;");
        cf.add((byte)18, cf.addConstant(node.str));
        this.accept(node, 1, context);
        if (types_created) {
            cf.loadLocal(types);
        } else {
            cf.add((byte)1);
        }
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)-72, "pnuts.lang.Runtime", "callMethod", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;Ljava/lang/Object;)", "Ljava/lang/Object;");
        return null;
    }

    public Object arrayType(SimpleNode node, Context context) {
        SimpleNode n;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int count = 0;
        for (n = node; n != null && n.id == 15; n = n.jjtGetChild(0)) {
            ++count;
        }
        if (n.id == 17) {
            Label clserr = cf.getLabel();
            Label numerr = cf.getLabel();
            Object[] idx = Compiler.parseIndex(n);
            ((SimpleNode)idx[0]).accept(this, context);
            cf.add((byte)89);
            cf.add((byte)-63, "java.lang.Class");
            cf.add((byte)-103, clserr);
            cf.add((byte)-64, "java.lang.Class");
            cf.pushInteger(count);
            cf.add((byte)-72, "pnuts.lang.Runtime", "arrayType", "(Ljava/lang/Class;I)", "Ljava/lang/Class;");
            Object[] dim = (Object[])idx[1];
            cf.pushInteger(dim.length);
            cf.add((byte)-68, 10);
            int dlen = dim.length;
            for (int i = 0; i < dlen; ++i) {
                cf.add((byte)89);
                cf.pushInteger(i);
                ((SimpleNode)dim[i]).accept(this, context);
                cf.add((byte)-64, "java.lang.Number");
                cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
                cf.add((byte)79);
            }
            cf.add((byte)-72, "java.lang.reflect.Array", "newInstance", "(Ljava/lang/Class;[I)", "Ljava/lang/Object;");
            Label next = cf.getLabel();
            cf.add((byte)-89, next);
            numerr.fix();
            this.error(cf, "number.expected", cc);
            cf.add((byte)-89, next);
            clserr.fix();
            this.error(cf, "classOrArray.expected", cc);
            next.fix();
            return null;
        }
        n.accept(this, context);
        int type = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(type);
        cf.add((byte)-63, "java.lang.Class");
        Label err = cf.getLabel();
        cf.add((byte)-103, err);
        cf.loadLocal(type);
        cf.freeLocal(type);
        cf.add((byte)-64, "java.lang.Class");
        cf.pushInteger(count);
        cf.add((byte)-72, "pnuts.lang.Runtime", "arrayType", "(Ljava/lang/Class;I)", "Ljava/lang/Class;");
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        err.fix();
        this.error(cf, "classOrArray.expected", new int[]{type}, cc);
        next.fix();
        return null;
    }

    static Object[] parseIndex(SimpleNode node) {
        SimpleNode c0 = node.jjtGetChild(0);
        SimpleNode c1 = node.jjtGetChild(1);
        if (c0.id != 17) {
            return new Object[]{c0, new Object[]{c1}};
        }
        Object[] r = Compiler.parseIndex(c0);
        Object[] d = (Object[])r[1];
        Object[] a = new Object[d.length + 1];
        System.arraycopy(d, 0, a, 0, d.length);
        a[d.length] = c1;
        return new Object[]{r[0], a};
    }

    public Object indexNode(SimpleNode node, Context context) {
        int i;
        FrameInfo info = (FrameInfo)node.info;
        if (info == null) {
            info = new FrameInfo();
            node.info = info;
        }
        if (!info.preprocessed) {
            info.preprocessed = true;
            SimpleNode idxNode = node.jjtGetChild(1);
            if (ConstraintsTransformer.isPredicate(idxNode)) {
                SimpleNode n = ConstraintsTransformer.buildFunc(idxNode);
                node.jjtAddChild(n, 1);
                n.jjtSetParent(node);
            }
        }
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        Object[] idx = Compiler.parseIndex(node);
        SimpleNode c = (SimpleNode)idx[0];
        c.accept(this, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        Object[] dim = (Object[])idx[1];
        Label else_end = cf.getLabel();
        int ctx = cc.getContextIndex();
        if (c.id == 8 || c.id == 5) {
            cf.loadLocal(tgt);
            cf.add((byte)-63, "java.lang.Class");
            Label else_ = cf.getLabel();
            cf.add((byte)-103, else_);
            cf.loadLocal(tgt);
            cf.add((byte)-64, "java.lang.Class");
            cf.pushInteger(dim.length);
            cf.add((byte)-68, 10);
            for (i = 0; i < dim.length; ++i) {
                cf.add((byte)89);
                cf.pushInteger(i);
                ((SimpleNode)dim[i]).accept(this, context);
                cf.add((byte)-64, "java.lang.Number");
                cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
                cf.add((byte)79);
            }
            cf.add((byte)-72, "java.lang.reflect.Array", "newInstance", "(Ljava/lang/Class;[I)", "Ljava/lang/Object;");
            cf.add((byte)-89, else_end);
            else_.fix();
        }
        Label err = cf.getLabel();
        for (i = 0; i < dim.length; ++i) {
            ((SimpleNode)dim[i]).accept(this, context);
            int _idx = cf.getLocal();
            cf.storeLocal(_idx);
            cf.loadLocal(tgt);
            cf.loadLocal(_idx);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "getElement", "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            cf.storeLocal(tgt);
        }
        cf.loadLocal(tgt);
        else_end.fix();
        cf.freeLocal(tgt);
        return null;
    }

    public Object instanceofExpression(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.accept(node, 1, context);
        int param = cf.getLocal();
        cf.storeLocal(param);
        Label next = cf.getLabel();
        Label err = cf.getLabel();
        Label l_false = cf.getLabel();
        cf.loadLocal(param);
        cf.add((byte)-63, "java.lang.Class");
        cf.add((byte)-103, err);
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt);
        cf.add((byte)-58, l_false);
        cf.loadLocal(param);
        cf.freeLocal(param);
        cf.add((byte)-64, "java.lang.Class");
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)-74, "java.lang.Class", "isInstance", "(Ljava/lang/Object;)", "Z");
        cf.add((byte)-103, l_false);
        cf.add((byte)-78, "java.lang.Boolean", "TRUE", "Ljava/lang/Boolean;");
        cf.add((byte)-89, next);
        err.fix();
        this.error(cf, "class.expected", new int[]{param}, cc);
        l_false.fix();
        cf.add((byte)-78, "java.lang.Boolean", "FALSE", "Ljava/lang/Boolean;");
        next.fix();
        return null;
    }

    public Object assignment(SimpleNode node, Context context) {
        return this.assign(node, context, 25);
    }

    public Object assignmentTA(SimpleNode node, Context context) {
        return this.assign(node, context, 26);
    }

    public Object assignmentMA(SimpleNode node, Context context) {
        return this.assign(node, context, 27);
    }

    public Object assignmentDA(SimpleNode node, Context context) {
        return this.assign(node, context, 28);
    }

    public Object assignmentPA(SimpleNode node, Context context) {
        return this.assign(node, context, 29);
    }

    public Object assignmentSA(SimpleNode node, Context context) {
        return this.assign(node, context, 30);
    }

    public Object assignmentLA(SimpleNode node, Context context) {
        return this.assign(node, context, 31);
    }

    public Object assignmentRA(SimpleNode node, Context context) {
        return this.assign(node, context, 32);
    }

    public Object assignmentRAA(SimpleNode node, Context context) {
        return this.assign(node, context, 33);
    }

    public Object assignmentAA(SimpleNode node, Context context) {
        return this.assign(node, context, 34);
    }

    public Object assignmentEA(SimpleNode node, Context context) {
        return this.assign(node, context, 35);
    }

    public Object assignmentOA(SimpleNode node, Context context) {
        return this.assign(node, context, 36);
    }

    public Object preIncrNode(SimpleNode node, Context context) {
        SimpleNode node0 = node.jjtGetChild(0);
        node0.accept(this, context);
        this._assign(node0, context, 32797, false, true);
        return null;
    }

    public Object preDecrNode(SimpleNode node, Context context) {
        SimpleNode node0 = node.jjtGetChild(0);
        node0.accept(this, context);
        this._assign(node0, context, 32798, false, true);
        return null;
    }

    public Object postIncrNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        int ret = cf.getLocal();
        cf.storeLocal(ret);
        cf.loadLocal(ret);
        this._assign(node.jjtGetChild(0), cc, 32797, false, false);
        cf.loadLocal(ret);
        cf.freeLocal(ret);
        return null;
    }

    public Object postDecrNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        this.accept(node, 0, context);
        int ret = cf.getLocal();
        cf.storeLocal(ret);
        cf.loadLocal(ret);
        this._assign(node.jjtGetChild(0), context, 32798, false, false);
        cf.loadLocal(ret);
        cf.freeLocal(ret);
        return null;
    }

    public Object staticMethodNode(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        this.accept(node, 1, context);
        int args = cf.getLocal();
        cf.storeLocal(args);
        SimpleNode c1 = node.jjtGetChild(0);
        String pkgName = Compiler.getPackageName(c1);
        SimpleNode argNode = node.jjtGetChild(1);
        int nargs = argNode.jjtGetNumChildren();
        cf.add((byte)18, cf.addConstant(pkgName));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int pkg = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(pkg);
        Label l_null = cf.getLabel();
        cf.add((byte)-58, l_null);
        cf.loadLocal(pkg);
        cf.add((byte)18, cf.addConstant(node.str));
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "get", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        int got = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(got);
        cf.add((byte)-63, "pnuts.lang.PnutsFunction");
        Label l_else = cf.getLabel();
        cf.add((byte)-103, l_else);
        cf.loadLocal(ctx);
        cf.loadLocal(got);
        cf.add((byte)-64, "pnuts.lang.PnutsFunction");
        cf.loadLocal(args);
        cf.add((byte)-72, "pnuts.lang.Runtime", "callFunction", "(Lpnuts/lang/Context;Lpnuts/lang/PnutsFunction;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        l_else.fix();
        cf.loadLocal(got);
        cf.add((byte)-63, "java.lang.Class");
        cf.add((byte)-103, l_null);
        boolean types_created = false;
        for (int i = 0; i < nargs; ++i) {
            SimpleNode n = argNode.jjtGetChild(i);
            if (n.id != 62) continue;
            if (!types_created) {
                cf.pushInteger(nargs);
                cf.add((byte)-67, "java.lang.Class");
                types_created = true;
            }
            cf.add((byte)89);
            cf.pushInteger(i);
            this.accept(n, 0, context);
            cf.add((byte)83);
        }
        int types = cf.getLocal();
        if (types_created) {
            cf.storeLocal(types);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(got);
        cf.add((byte)-64, "java.lang.Class");
        cf.loadLocal(args);
        if (types_created) {
            cf.loadLocal(types);
        } else {
            cf.add((byte)1);
        }
        cf.add((byte)-72, "pnuts.lang.Runtime", "newInstance", "(Lpnuts/lang/Context;Ljava/lang/Class;[Ljava/lang/Object;[Ljava/lang/Class;)", "Ljava/lang/Object;");
        cf.add((byte)-89, next);
        l_null.fix();
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt);
        cf.add((byte)-63, "java.lang.Class");
        Label ok = cf.getLabel();
        cf.add((byte)-102, ok);
        cf.add((byte)-69, "pnuts.lang.PnutsException");
        cf.add((byte)89);
        cf.add((byte)18, cf.addConstant("illegal.staticCall"));
        cf.add((byte)6);
        cf.add((byte)-67, "java.lang.Object");
        cf.add((byte)89);
        cf.add((byte)3);
        cf.add((byte)18, cf.addConstant(pkgName));
        cf.add((byte)83);
        cf.add((byte)89);
        cf.add((byte)4);
        cf.add((byte)18, cf.addConstant(node.str));
        cf.add((byte)83);
        cf.add((byte)89);
        cf.add((byte)5);
        cf.add((byte)-69, "java.lang.Integer");
        cf.add((byte)89);
        cf.pushInteger(nargs);
        cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
        cf.add((byte)83);
        cf.loadLocal(ctx);
        cf.add((byte)-73, "pnuts.lang.PnutsException", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        cf.add((byte)-65);
        ok.fix();
        types_created = false;
        for (int i = 0; i < nargs; ++i) {
            SimpleNode n = argNode.jjtGetChild(i);
            if (n.id != 62) continue;
            if (!types_created) {
                cf.pushInteger(nargs);
                cf.add((byte)-67, "java.lang.Class");
                types_created = true;
            }
            cf.add((byte)89);
            cf.pushInteger(i);
            this.accept(n, 0, context);
            cf.add((byte)83);
        }
        types = cf.getLocal();
        if (types_created) {
            cf.storeLocal(types);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.add((byte)-64, "java.lang.Class");
        cf.add((byte)18, cf.addConstant(node.str));
        cf.loadLocal(args);
        if (types_created) {
            cf.loadLocal(types);
        } else {
            cf.add((byte)1);
        }
        cf.freeLocal(types);
        cf.add((byte)1);
        cf.add((byte)-72, "pnuts.lang.Runtime", "callMethod", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;Ljava/lang/Object;)", "Ljava/lang/Object;");
        next.fix();
        return null;
    }

    public Object staticMemberNode(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        SimpleNode c1 = node.jjtGetChild(0);
        Label next = cf.getLabel();
        String pkgName = Compiler.getPackageName(c1);
        cf.add((byte)18, cf.addConstant(pkgName));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int pkg = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(pkg);
        Label l_null = cf.getLabel();
        cf.add((byte)-58, l_null);
        cf.loadLocal(pkg);
        cf.freeLocal(pkg);
        cf.add((byte)18, cf.addConstant(node.str));
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "lookup", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/NamedValue;");
        int val = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(val);
        Label undef = cf.getLabel();
        cf.add((byte)-58, undef);
        cf.loadLocal(val);
        cf.freeLocal(val);
        cf.add((byte)-71, "pnuts.lang.Value", "get", "()", "Ljava/lang/Object;");
        cf.add((byte)-89, next);
        undef.fix();
        this.errorSymbol(cf, "not.defined", cf.addConstant(node.str), cc);
        l_null.fix();
        c1.accept(this, context);
        int tgt = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt);
        cf.add((byte)-63, "java.lang.Class");
        Label err = cf.getLabel();
        cf.add((byte)-103, err);
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)-64, "java.lang.Class");
        cf.add((byte)18, cf.addConstant(node.str));
        cf.add((byte)-72, "pnuts.lang.Runtime", "getStaticField", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;)", "Ljava/lang/Object;");
        cf.add((byte)-89, next);
        err.fix();
        this.error(cf, "packageOrClass.expected", new int[]{tgt}, cc);
        next.fix();
        return null;
    }

    public Object rangeNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        this.accept(node, 1, context);
        int idx1 = cf.getLocal();
        cf.storeLocal(idx1);
        int idx2 = cf.getLocal();
        if (node.jjtGetNumChildren() >= 3) {
            this.accept(node, 2, context);
        } else {
            cf.add((byte)1);
        }
        cf.storeLocal(idx2);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.loadLocal(idx1);
        cf.freeLocal(idx1);
        cf.loadLocal(idx2);
        cf.freeLocal(idx2);
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Runtime", "getRange", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        return null;
    }

    public Object forStatement(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        SimpleNode initNode = null;
        SimpleNode condNode = null;
        SimpleNode updateNode = null;
        SimpleNode blockNode = null;
        int j = 0;
        SimpleNode n = node.jjtGetChild(j);
        if (n.id == 74) {
            int nc = n.jjtGetNumChildren();
            blockNode = node.jjtGetChild(1);
            if (nc == 1) {
                this.doForeach(n.str, n.jjtGetChild(0), blockNode, cc, cf);
            } else if (nc == 2) {
                this.doForeachRange(n.str, n.jjtGetChild(0), n.jjtGetChild(1), blockNode, cc, cf);
            }
            return null;
        }
        if (n.id == 75) {
            initNode = n;
            ++j;
        }
        n = node.jjtGetChild(j);
        if (n.id != 76 && n.id != 68) {
            condNode = n;
            ++j;
        }
        n = node.jjtGetChild(j);
        if (n.id == 76) {
            updateNode = n;
            ++j;
        }
        blockNode = node.jjtGetChild(j);
        int last = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(last);
        if (initNode != null) {
            int i;
            int num = initNode.jjtGetNumChildren();
            String[] env = new String[num];
            for (i = 0; i < env.length; ++i) {
                SimpleNode sn = initNode.jjtGetChild(i);
                env[i] = sn.str;
            }
            cc.openScope(env);
            for (i = 0; i < env.length; ++i) {
                Reference ref = cc.getReference(env[i]);
                SimpleNode sn = initNode.jjtGetChild(i);
                this.accept(sn, 0, context);
                if (ref.offset < 0) {
                    cf.storeLocal(ref.index);
                    continue;
                }
                int tgt = cf.getLocal();
                cf.storeLocal(tgt);
                cf.add((byte)1);
                cf.storeLocal(ref.index);
                ref.set(cf, tgt);
            }
        } else {
            cc.openScope(new String[0]);
        }
        Label start = cf.getLabel(true);
        Label cont = cf.getLabel();
        Label next = cf.getLabel();
        Label broke = cf.getLabel();
        cc.pushContinueLabel(cont);
        cc.pushBreakLabel(broke);
        if (condNode != null) {
            condNode.accept(this, context);
            if (condNode.info == INLINED_BOOLEAN) {
                cf.add((byte)-103, next);
            } else {
                this.booleanCheck(condNode.id, cf, context);
                cf.add((byte)-64, "java.lang.Boolean");
                cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
                cf.add((byte)-103, next);
            }
        }
        blockNode.accept(this, context);
        cont.fix();
        cf.storeLocal(last);
        if (updateNode != null) {
            int num = updateNode.jjtGetNumChildren();
            for (int i = 0; i < num; ++i) {
                this.accept(updateNode, i, context);
                cf.add((byte)87);
            }
        }
        cf.add((byte)-89, start);
        next.fix();
        cf.loadLocal(last);
        cf.freeLocal(last);
        cc.closeScope();
        broke.fix();
        cc.popContinueLabel();
        cc.popBreakLabel();
        return null;
    }

    public Object breakNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        if (node.jjtGetNumChildren() > 0) {
            this.accept(node, 0, context);
        } else {
            cf.add((byte)1);
        }
        Label brk = cc.getBreakLabel();
        if (brk != null) {
            cf.add((byte)-89, brk);
        }
        return null;
    }

    public Object continueNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        Label cnt = cc.getContinueLabel();
        cf.add((byte)1);
        if (cnt != null) {
            cf.add((byte)-89, cnt);
        }
        return null;
    }

    public Object returnNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        if (node.jjtGetNumChildren() > 0) {
            this.accept(node, 0, context);
        } else {
            cf.add((byte)1);
        }
        if (cc.env.parent != null) {
            cf.add((byte)-89, cc.returnLabel);
        } else {
            cf.add((byte)-72, "pnuts.lang.Runtime", "jump", "(Ljava/lang/Object;)", "V");
            cf.add((byte)1);
        }
        return null;
    }

    public Object catchNode(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (node.jjtGetNumChildren() == 0) {
            cf.add((byte)1);
            return null;
        }
        this.accept(node, 0, context);
        cf.add((byte)-64, "[Ljava/lang/Object;");
        int args = cf.getLocal();
        cf.storeLocal(args);
        Reference eref = cc.getReference("!exception");
        if (cc.env.parent != null) {
            int tmap = cf.getLocal();
            cf.add((byte)-69, "pnuts.lang.Runtime$TypeMap");
            cf.add((byte)89);
            cf.loadLocal(args);
            cf.add((byte)3);
            cf.add((byte)50);
            cf.add((byte)-64, "java.lang.Class");
            cf.loadLocal(args);
            cf.add((byte)4);
            cf.add((byte)50);
            cf.loadLocal(eref.index);
            cf.add((byte)-64, "pnuts.lang.Runtime$TypeMap");
            cf.add((byte)-73, "pnuts.lang.Runtime$TypeMap", "<init>", "(Ljava/lang/Class;Ljava/lang/Object;Lpnuts/lang/Runtime$TypeMap;)", "V");
            cf.storeLocal(eref.index);
            cf.add((byte)1);
        } else {
            cf.loadLocal(args);
            cf.add((byte)3);
            cf.add((byte)50);
            cf.add((byte)-64, "java.lang.Class");
            cf.loadLocal(args);
            cf.add((byte)4);
            cf.add((byte)50);
            cf.add((byte)-64, "pnuts.lang.PnutsFunction");
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "catchException", "(Ljava/lang/Class;Lpnuts/lang/PnutsFunction;Lpnuts/lang/Context;)", "V");
            cf.add((byte)1);
        }
        return null;
    }

    public Object whileStatement(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        String symbol = node.str;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        cf.add((byte)1);
        int last = cf.getLocal();
        cf.storeLocal(last);
        Label start = cf.getLabel(true);
        Label next = cf.getLabel();
        Label broke = cf.getLabel();
        Label cont = cf.getLabel();
        cc.pushContinueLabel(cont);
        cc.pushBreakLabel(broke);
        SimpleNode condNode = node.jjtGetChild(0);
        condNode.accept(this, context);
        if (condNode.info == INLINED_BOOLEAN) {
            cf.add((byte)-103, next);
        } else {
            this.booleanCheck(node.jjtGetChild((int)0).id, cf, context);
            cf.add((byte)-64, "java.lang.Boolean");
            cf.add((byte)-74, "java.lang.Boolean", "booleanValue", "()", "Z");
            cf.add((byte)-103, next);
        }
        this.accept(node, 1, context);
        cont.fix();
        cf.storeLocal(last);
        cf.add((byte)-89, start);
        next.fix();
        cc.popContinueLabel();
        cc.popBreakLabel();
        cf.loadLocal(last);
        cf.freeLocal(last);
        broke.fix();
        return null;
    }

    private void doForeach(String var, SimpleNode collectionNode, SimpleNode blockNode, CompileContext cc, ClassFile cf) {
        cc.openScope(new String[]{var});
        Reference count = cc.getReference(var);
        cf.add((byte)4);
        cf.add((byte)-67, "java.lang.Object");
        cf.storeLocal(count.index);
        Label next = cf.getLabel();
        Label broke = cf.getLabel();
        cc.pushBreakLabel(broke);
        int last = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(last);
        collectionNode.accept(this, cc);
        int tgt = cf.getLocal();
        cf.add((byte)89);
        cf.storeLocal(tgt);
        Label nonnull = cf.getLabel();
        cf.add((byte)-57, nonnull);
        cf.add((byte)-89, next);
        nonnull.fix();
        cf.loadLocal(tgt);
        cf.loadLocal(cc.getContextIndex());
        cf.add((byte)-72, "pnuts.lang.Runtime", "toEnumeration", "(Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/util/Enumeration;");
        int tmp1 = cf.getLocal();
        cf.storeLocal(tmp1);
        cf.loadLocal(tmp1);
        Label err = cf.getLabel();
        cf.add((byte)-58, err);
        Label loop2 = cf.getLabel();
        cf.add((byte)-89, loop2);
        Label body = cf.getLabel(true);
        cf.loadLocal(tmp1);
        cf.add((byte)-64, "java.util.Enumeration");
        cf.add((byte)-71, "java.util.Enumeration", "nextElement", "()", "Ljava/lang/Object;");
        int tmp2 = cf.getLocal();
        cf.storeLocal(tmp2);
        count.set(cf, tmp2);
        Label cont = cf.getLabel();
        cc.pushContinueLabel(cont);
        blockNode.accept(this, cc);
        cont.fix();
        cf.storeLocal(last);
        loop2.fix();
        cf.loadLocal(tmp1);
        cf.add((byte)-64, "java.util.Enumeration");
        cf.add((byte)-71, "java.util.Enumeration", "hasMoreElements", "()", "Z");
        cf.add((byte)-103, next);
        cf.add((byte)-89, body);
        err.fix();
        this.error(cf, "illegal.type.foreach", new int[]{tgt}, cc);
        next.fix();
        cf.loadLocal(last);
        cf.freeLocal(last);
        cf.freeLocal(tmp1);
        cf.freeLocal(tmp2);
        cf.freeLocal(tgt);
        cc.popContinueLabel();
        cc.popBreakLabel();
        cc.closeScope();
        broke.fix();
    }

    private void doForeachRange(String var, SimpleNode startNode, SimpleNode endNode, SimpleNode blockNode, CompileContext cc, ClassFile cf) {
        cc.openScope(new String[]{var});
        Reference count = cc.getReference(var);
        cf.add((byte)4);
        cf.add((byte)-67, "java.lang.Object");
        cf.storeLocal(count.index);
        Label next = cf.getLabel();
        Label broke = cf.getLabel();
        cc.pushBreakLabel(broke);
        int last = cf.getLocal();
        int tmp = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(last);
        int start = cf.getLocal();
        startNode.accept(this, cc);
        cf.add((byte)-64, "java.lang.Number");
        cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
        cf.istoreLocal(start);
        int end = cf.getLocal();
        endNode.accept(this, cc);
        cf.add((byte)-64, "java.lang.Number");
        cf.add((byte)-74, "java.lang.Number", "intValue", "()", "I");
        cf.istoreLocal(end);
        cf.iloadLocal(start);
        cf.iloadLocal(end);
        Label loop2 = cf.getLabel();
        cf.add((byte)-93, loop2);
        Label loop1 = cf.getLabel(true);
        cf.iloadLocal(start);
        cf.iloadLocal(end);
        cf.add((byte)-93, next);
        cf.add((byte)-69, "java.lang.Integer");
        cf.add((byte)89);
        cf.iloadLocal(start);
        cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
        cf.storeLocal(tmp);
        count.set(cf, tmp);
        Label cont = cf.getLabel();
        cc.pushContinueLabel(cont);
        blockNode.accept(this, cc);
        cont.fix();
        cf.storeLocal(last);
        cf.add((byte)-124, start, 1);
        cf.add((byte)-89, loop1);
        loop2.fix();
        cf.iloadLocal(start);
        cf.iloadLocal(end);
        cf.add((byte)-95, next);
        cf.add((byte)-69, "java.lang.Integer");
        cf.add((byte)89);
        cf.iloadLocal(start);
        cf.add((byte)-73, "java.lang.Integer", "<init>", "(I)", "V");
        cf.storeLocal(tmp);
        count.set(cf, tmp);
        Label cont2 = cf.getLabel();
        cc.pushContinueLabel(cont2);
        blockNode.accept(this, cc);
        cont2.fix();
        cf.storeLocal(last);
        cf.add((byte)-124, start, -1);
        cf.add((byte)-89, loop2);
        next.fix();
        cf.loadLocal(last);
        cf.freeLocal(last);
        cf.freeLocal(tmp);
        cf.freeLocal(start);
        cf.freeLocal(end);
        cc.popContinueLabel();
        cc.popBreakLabel();
        cc.closeScope();
        broke.fix();
    }

    public Object foreachStatement(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        this.doForeach(node.str, node.jjtGetChild(0), node.jjtGetChild(1), cc, cf);
        return null;
    }

    public Object switchStatement(SimpleNode node, Context context) {
        int line;
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        if (this._includeLineNo && cc.line != (line = node.beginLine)) {
            cf.loadLocal(ctx);
            cf.pushInteger(node.beginLine);
            if (node.beginLine == node.endLine) {
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;I)", "V");
            } else {
                cf.pushInteger(node.endLine);
                cf.add((byte)-72, "pnuts.lang.Runtime", "setLine", "(Lpnuts/lang/Context;II)", "V");
            }
            cc.line = line;
        }
        int n = node.jjtGetNumChildren();
        this.accept(node, 0, context);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        cc.openScope(new String[0]);
        int match = cf.getLocal();
        cf.add((byte)3);
        cf.istoreLocal(match);
        int last = cf.getLocal();
        cf.add((byte)1);
        cf.storeLocal(last);
        Label start = cf.getLabel(true);
        Label next = cf.getLabel();
        cc.pushBreakLabel(next);
        for (int i = 1; i < n; ++i) {
            SimpleNode _node = node.jjtGetChild(i);
            if (_node.jjtGetNumChildren() == 1) {
                cf.iloadLocal(match);
                Label hit = cf.getLabel();
                cf.add((byte)-102, hit);
                ++i;
                this.accept(_node, 0, context);
                cf.loadLocal(tgt);
                cf.add((byte)-72, "pnuts.lang.Runtime", "eq", "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                Label cont = cf.getLabel();
                cf.add((byte)-103, cont);
                cf.add((byte)4);
                cf.istoreLocal(match);
                hit.fix();
                this.accept(node, i, context);
                cf.storeLocal(last);
                cont.fix();
                continue;
            }
            cf.add((byte)4);
            cf.istoreLocal(match);
            this.accept(node, ++i, context);
            cf.storeLocal(last);
        }
        cf.freeLocal(tgt);
        cf.freeLocal(match);
        cf.loadLocal(last);
        next.fix();
        cc.closeScope();
        cc.popBreakLabel();
        return null;
    }

    public Object switchBlock(SimpleNode node, Context context) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int n = node.jjtGetNumChildren();
        if (n > 0) {
            int m = n - 1;
            for (int i = 0; i < m; ++i) {
                this.accept(node, i, context);
                cf.add((byte)87);
            }
            this.accept(node, m, context);
        } else {
            cf.add((byte)1);
        }
        return null;
    }

    static String getPackageName(SimpleNode node) {
        if (node.jjtGetNumChildren() > 0) {
            SimpleNode c1 = node.jjtGetChild(0);
            return Compiler.getPackageName(c1) + "::" + node.str;
        }
        return node.str;
    }

    static String gensym(Context context) {
        return ((CompileContext)context).sym.gen();
    }

    protected Object accept(SimpleNode node, int idx, Context context) {
        return node.jjtGetChild(idx).accept(this, context);
    }

    private Object assign(SimpleNode node, Context context, int id) {
        this.accept(node, 1, context);
        this._assign(node.jjtGetChild(0), context, id, false, true);
        return null;
    }

    private Object _assign(SimpleNode lhs, Context context, int id, boolean mutable, boolean nopop) {
        CompileContext cc = (CompileContext)context;
        ClassFile cf = cc.cf;
        int ctx = cc.getContextIndex();
        int rhs = cf.getLocal();
        if ((id & 0x8000) == 0) {
            cf.storeLocal(rhs);
        }
        if (lhs.id == 5) {
            this.assignId(cf, id, ctx, rhs, lhs, cc, mutable, nopop);
        } else if (lhs.id == 4) {
            this.assignGlobal(cf, id, ctx, rhs, lhs, cc, nopop);
        } else if (lhs.id == 17) {
            this.assignIndex(cf, id, ctx, rhs, lhs, cc, nopop);
        } else if (lhs.id == 13) {
            this.assignStaticMember(cf, id, ctx, rhs, lhs, cc, nopop);
        } else if (lhs.id == 12) {
            this.assignMember(cf, id, ctx, rhs, lhs, cc, nopop);
        } else if (lhs.id == 16 && id == 25) {
            this.assignRange(cf, id, ctx, rhs, lhs, cc);
        } else {
            throw new PnutsException("illegal.assign", new Object[0], context);
        }
        cf.freeLocal(rhs);
        return null;
    }

    boolean inControl(SimpleNode node) {
        while (node != null) {
            if (node.id == 82) {
                return false;
            }
            if (node.id == 79 || node.id == 78 || node.id == 73 || node.id == 72 || node.id == 69) {
                return true;
            }
            node = node.jjtGetParent();
        }
        return false;
    }

    void assignId(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean mutable, boolean nopop) {
        if (cc.env.parent != null && !mutable) {
            Reference ref = cc.getReference(lhs.str);
            boolean idx = false;
            if (ref == null) {
                cc.declare(lhs.str);
                ref = cc.getReference(lhs.str);
            }
            if (id != 25) {
                if ((id & 0x8000) == 0) {
                    ref.get(cc);
                    cf.loadLocal(rhs);
                }
                this.compute(cf, id, ctx);
                cf.storeLocal(rhs);
            }
            ref.set(cf, rhs);
            if (!this.inControl(lhs)) {
                cc.setReference(lhs.str);
            }
            if (nopop) {
                cf.loadLocal(rhs);
            }
        } else {
            Reference ref = cc.getReference(lhs.str);
            if (ref != null) {
                if (id != 25) {
                    if ((id & 0x8000) == 0) {
                        ref.get(cc);
                        cf.loadLocal(rhs);
                    }
                    this.compute(cf, id, ctx);
                    cf.storeLocal(rhs);
                }
                ref.set(cf, rhs);
                if (nopop) {
                    cf.loadLocal(rhs);
                }
            } else {
                int ret = -1;
                if (id != 25) {
                    if ((id & 0x8000) == 0) {
                        cf.loadLocal(ctx);
                        cf.add((byte)18, cf.addConstant(lhs.str));
                        cf.add((byte)-74, "pnuts.lang.Context", "getId", "(Ljava/lang/String;)", "Ljava/lang/Object;");
                        ret = cf.getLocal();
                        cf.storeLocal(ret);
                        cf.loadLocal(ret);
                        cf.loadLocal(rhs);
                    }
                    this.compute(cf, id, ctx);
                    cf.storeLocal(rhs);
                }
                cf.loadLocal(ctx);
                cf.add((byte)-74, "pnuts.lang.Context", "getCurrentPackage", "()", "Lpnuts/lang/Package;");
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.loadLocal(rhs);
                cf.loadLocal(ctx);
                cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
                if (nopop) {
                    cf.loadLocal(rhs);
                }
            }
        }
    }

    void assignMember(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean nopop) {
        this.accept(lhs, 0, cc);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        if (id != 25) {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(ctx);
                cf.loadLocal(tgt);
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.add((byte)-72, "pnuts.lang.Runtime", "getField", "(Lpnuts/lang/Context;Ljava/lang/Object;Ljava/lang/String;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)18, cf.addConstant(lhs.str));
        cf.loadLocal(rhs);
        cf.add((byte)-72, "pnuts.lang.Runtime", "putField", "(Lpnuts/lang/Context;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)", "V");
        if (nopop) {
            cf.loadLocal(rhs);
        }
    }

    void assignIndex(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean nopop) {
        SimpleNode idxNode = lhs.jjtGetChild(1);
        if (ConstraintsTransformer.isPredicate(idxNode)) {
            SimpleNode n = ConstraintsTransformer.buildFunc(idxNode);
            lhs.jjtAddChild(n, 1);
            n.jjtSetParent(lhs);
        }
        this.accept(lhs, 0, cc);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        this.accept(lhs, 1, cc);
        int idx = cf.getLocal();
        cf.storeLocal(idx);
        Label next = cf.getLabel();
        cf.loadLocal(tgt);
        cf.add((byte)-63, "java.lang.String");
        Label l2 = cf.getLabel();
        cf.add((byte)-103, l2);
        if (id != 25) {
            this.error(cf, "illegal.assign", cc);
        } else {
            cf.loadLocal(tgt);
            cf.loadLocal(idx);
            cf.add((byte)89);
            cf.loadLocal(rhs);
            cf.add((byte)-63, "java.lang.Character");
            Label ok = cf.getLabel();
            cf.add((byte)-102, ok);
            this.error(cf, "illegal.assign", cc);
            ok.fix();
            cf.loadLocal(rhs);
            cf.loadLocal(cc.getContextIndex());
            cf.add((byte)-72, "pnuts.lang.Runtime", "setRange", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
            SimpleNode ch = lhs.jjtGetChild(0);
            if (ch.id == 5 || ch.id == 4 || ch.id == 17 || ch.id == 12 || ch.id == 13) {
                this._assign(ch, cc, id, true, true);
            }
            cf.add((byte)-89, next);
        }
        l2.fix();
        if (id == 25) {
            cf.loadLocal(tgt);
            cf.loadLocal(idx);
            cf.loadLocal(rhs);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "setElement", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
            if (nopop) {
                cf.loadLocal(rhs);
            }
        } else {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(tgt);
                cf.loadLocal(idx);
                cf.loadLocal(ctx);
                cf.add((byte)-72, "pnuts.lang.Runtime", "getElement", "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
            cf.loadLocal(tgt);
            cf.loadLocal(idx);
            cf.loadLocal(rhs);
            cf.loadLocal(ctx);
            cf.add((byte)-72, "pnuts.lang.Runtime", "setElement", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
            if (nopop) {
                cf.loadLocal(rhs);
            }
        }
        cf.freeLocal(tgt);
        cf.freeLocal(idx);
        next.fix();
    }

    void assignRange(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc) {
        this.accept(lhs, 0, cc);
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        this.accept(lhs, 1, cc);
        int idx1 = cf.getLocal();
        cf.storeLocal(idx1);
        int idx2 = cf.getLocal();
        if (lhs.jjtGetNumChildren() >= 3) {
            this.accept(lhs, 2, cc);
        } else {
            cf.add((byte)1);
        }
        cf.storeLocal(idx2);
        cf.loadLocal(tgt);
        cf.loadLocal(idx1);
        cf.freeLocal(idx1);
        cf.loadLocal(idx2);
        cf.freeLocal(idx2);
        cf.loadLocal(rhs);
        cf.loadLocal(cc.getContextIndex());
        cf.add((byte)-72, "pnuts.lang.Runtime", "setRange", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
        SimpleNode ch = lhs.jjtGetChild(0);
        if (ch.id == 5 || ch.id == 4 || ch.id == 17 || ch.id == 12 || ch.id == 13) {
            int assigned = cf.getLocal();
            cf.storeLocal(assigned);
            cf.loadLocal(tgt);
            cf.freeLocal(tgt);
            cf.add((byte)-63, "java.lang.String");
            Label no = cf.getLabel();
            cf.add((byte)-103, no);
            cf.loadLocal(assigned);
            this._assign(ch, cc, id, true, true);
            cf.add((byte)87);
            no.fix();
            cf.loadLocal(assigned);
            cf.freeLocal(assigned);
        }
    }

    void assignStaticMember(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean nopop) {
        SimpleNode c1 = lhs.jjtGetChild(0);
        String pkgName = Compiler.getPackageName(c1);
        cf.add((byte)18, cf.addConstant(pkgName));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int tgt = cf.getLocal();
        cf.storeLocal(tgt);
        cf.loadLocal(tgt);
        Label l_null = cf.getLabel();
        cf.add((byte)-58, l_null);
        if (id != 25) {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(tgt);
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.loadLocal(ctx);
                cf.add((byte)-74, "pnuts.lang.Package", "get", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
        }
        cf.loadLocal(tgt);
        cf.add((byte)18, cf.addConstant(lhs.str));
        cf.loadLocal(rhs);
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        if (nopop) {
            cf.loadLocal(rhs);
        }
        Label next = cf.getLabel();
        cf.add((byte)-89, next);
        l_null.fix();
        c1.accept(this, cc);
        cf.add((byte)89);
        cf.storeLocal(tgt);
        cf.add((byte)-63, "java.lang.Class");
        Label err = cf.getLabel();
        cf.add((byte)-103, err);
        if (id != 25) {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(ctx);
                cf.loadLocal(tgt);
                cf.add((byte)-64, "java.lang.Class");
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.add((byte)-72, "pnuts.lang.Runtime", "getStaticField", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
        }
        cf.loadLocal(ctx);
        cf.loadLocal(tgt);
        cf.freeLocal(tgt);
        cf.add((byte)-64, "java.lang.Class");
        cf.add((byte)18, cf.addConstant(lhs.str));
        cf.loadLocal(rhs);
        cf.add((byte)-72, "pnuts.lang.Runtime", "putStaticField", "(Lpnuts/lang/Context;Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Object;)", "V");
        if (nopop) {
            cf.loadLocal(rhs);
        }
        cf.add((byte)-89, next);
        err.fix();
        this.error(cf, "package.notFound", cc);
        next.fix();
    }

    void assignGlobal(ClassFile cf, int id, int ctx, int rhs, SimpleNode lhs, CompileContext cc, boolean nopop) {
        cf.add((byte)18, cf.addConstant(""));
        cf.loadLocal(ctx);
        cf.add((byte)-72, "pnuts.lang.Package", "find", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Lpnuts/lang/Package;");
        int gbl = cf.getLocal();
        cf.storeLocal(gbl);
        if (id != 25) {
            if ((id & 0x8000) == 0) {
                cf.loadLocal(gbl);
                cf.add((byte)18, cf.addConstant(lhs.str));
                cf.loadLocal(ctx);
                cf.add((byte)-74, "pnuts.lang.Package", "get", "(Ljava/lang/String;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                cf.loadLocal(rhs);
                cf.freeLocal(gbl);
            }
            this.compute(cf, id, ctx);
            cf.storeLocal(rhs);
        }
        cf.loadLocal(gbl);
        cf.add((byte)18, cf.addConstant(lhs.str));
        cf.loadLocal(rhs);
        cf.loadLocal(ctx);
        cf.add((byte)-74, "pnuts.lang.Package", "set", "(Ljava/lang/String;Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        if (nopop) {
            cf.loadLocal(rhs);
        }
    }

    void error(ClassFile cf, String keyword, CompileContext cc) {
        this.error(cf, keyword, null, cc);
    }

    void errorSymbol(ClassFile cf, String keyword, int stringConstant, CompileContext cc) {
        cf.add((byte)-69, "pnuts.lang.PnutsException");
        cf.add((byte)89);
        cf.add((byte)18, cf.addConstant(keyword));
        cf.pushInteger(1);
        cf.add((byte)-67, "java.lang.Object");
        cf.add((byte)89);
        cf.pushInteger(0);
        cf.add((byte)18, stringConstant);
        cf.add((byte)83);
        int ctx = cc.getContextIndex();
        cf.loadLocal(ctx);
        cf.add((byte)-73, "pnuts.lang.PnutsException", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        cf.add((byte)-65);
    }

    void error(ClassFile cf, String keyword, int[] locals, CompileContext cc) {
        cf.add((byte)-69, "pnuts.lang.PnutsException");
        cf.add((byte)89);
        cf.add((byte)18, cf.addConstant(keyword));
        if (locals == null) {
            cf.add((byte)-78, cc.constClassName, "NO_PARAM", "[Ljava/lang/Object;");
        } else {
            cf.pushInteger(locals.length);
            cf.add((byte)-67, "java.lang.Object");
            for (int i = 0; i < locals.length; ++i) {
                cf.add((byte)89);
                cf.pushInteger(i);
                cf.loadLocal(locals[i]);
                cf.add((byte)83);
            }
        }
        int ctx = cc.getContextIndex();
        cf.loadLocal(ctx);
        cf.add((byte)-73, "pnuts.lang.PnutsException", "<init>", "(Ljava/lang/String;[Ljava/lang/Object;Lpnuts/lang/Context;)", "V");
        cf.add((byte)-65);
    }

    void compute(ClassFile cf, int id, int ctx) {
        String method;
        cf.loadLocal(ctx);
        switch (id) {
            case 26: {
                method = "multiply";
                break;
            }
            case 27: {
                method = "mod";
                break;
            }
            case 28: {
                method = "divide";
                break;
            }
            case 29: {
                method = "add";
                break;
            }
            case 32797: {
                cf.add((byte)-72, "pnuts.lang.Runtime", "add1", "(Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                return;
            }
            case 30: {
                method = "subtract";
                break;
            }
            case 32798: {
                cf.add((byte)-72, "pnuts.lang.Runtime", "subtract1", "(Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
                return;
            }
            case 31: {
                method = "shiftLeft";
                break;
            }
            case 32: {
                method = "shiftRight";
                break;
            }
            case 33: {
                method = "shiftArithmetic";
                break;
            }
            case 34: {
                method = "and";
                break;
            }
            case 35: {
                method = "xor";
                break;
            }
            case 36: {
                method = "or";
                break;
            }
            default: {
                throw new RuntimeException("never happen");
            }
        }
        cf.add((byte)-72, "pnuts.lang.Runtime", method, "(Ljava/lang/Object;Ljava/lang/Object;Lpnuts/lang/Context;)", "Ljava/lang/Object;");
    }

    static CodeLoader createCodeLoader(ClassLoader loader, boolean privileged) {
        if (hasJava2Security && privileged) {
            return privilegedCodeLoaderFactory.create(loader);
        }
        return codeLoaderFactory.create(loader);
    }

    public static CodeLoader createCodeLoader(ClassLoader loader) {
        return Compiler.createCodeLoader(loader, false);
    }

    public Object compile(Pnuts pnuts, ClassFileHandler handler) {
        CompileContext cc = new CompileContext();
        return this.compile(pnuts, handler, cc);
    }

    Object compile(Pnuts pnuts, ClassFileHandler handler, CompileContext cc) {
        this.automatic = false;
        pnuts.accept(this, cc);
        Object compileResult = handler.handle(cc.getClassFile());
        Enumeration e = cc.getClassFiles();
        while (e.hasMoreElements()) {
            ClassFile cf = (ClassFile)e.nextElement();
            handler.handle(cf);
        }
        return compileResult;
    }

    public Pnuts compile(Pnuts pnuts, final Context context) {
        Throwable caught = null;
        try {
            final CodeLoader loader = Compiler.createCodeLoader(context.getClassLoader(), true);
            final CompileContext cc = new CompileContext();
            ClassFileHandler loadHandler = new ClassFileHandler(){

                public Object handle(ClassFile cf) {
                    try {
                        return cc.load(cf, loader);
                    }
                    catch (IOException e) {
                        throw new PnutsException(e, context);
                    }
                }
            };
            Class cls = (Class)this.compile(pnuts, loadHandler, cc);
            cc.resolve(loader);
            Runtime rt = (Runtime)cls.newInstance();
            class CompiledPnuts
            extends Pnuts
            implements Compiled {
                private final /* synthetic */ Pnuts val$pnuts;
                private final /* synthetic */ Runtime val$rt;

                CompiledPnuts(Pnuts pnuts, Runtime runtime) {
                    this.val$pnuts = pnuts;
                    this.val$rt = runtime;
                    this.scriptSource = this.val$pnuts.getScriptSource();
                }

                public Object accept(Visitor visitor, Context context) {
                    if (visitor instanceof Compiler) {
                        Compiler c = (Compiler)visitor;
                        if (c.automatic) {
                            return this.accept(context);
                        }
                        return this;
                    }
                    throw new RuntimeException("unsupported operation for compiled code");
                }

                public Object accept(Context context) {
                    return this.val$rt.run(context);
                }
            }
            return new CompiledPnuts(pnuts, rt);
        }
        catch (Throwable t) {
            caught = t;
            Runtime.checkException(context, caught);
            throw new PnutsException(caught, context);
        }
    }

    public Pnuts compile(String expression) {
        Context context = new Context();
        try {
            return this.compile(Pnuts.parse(expression), context);
        }
        catch (ParseException e) {
            Runtime.checkException(context, e);
            throw new PnutsException(e, context);
        }
    }

    public Pnuts compile(String expression, Context context) {
        try {
            return this.compile(Pnuts.parse(expression), context);
        }
        catch (ParseException e) {
            Runtime.checkException(context, e);
            throw new PnutsException(e, context);
        }
    }

    public Object compile(PnutsFunction pf, ClassFileHandler handler) {
        CompileContext cc = new CompileContext();
        Object ret = null;
        StringBuffer buf = new StringBuffer();
        Enumeration e = Runtime.getFunctions(pf);
        while (e.hasMoreElements()) {
            Function f = (Function)e.nextElement();
            int nargs = f.getNumberOfParameter();
            String[] im = f.getImportEnv();
            buf.append("import(null);");
            for (int i = 0; i < im.length; ++i) {
                buf.append("import(\"" + im[i] + "\");");
            }
            buf.append(pf.unparse(nargs));
            buf.append('\n');
        }
        try {
            String expr = buf.toString();
            return this.compile(Pnuts.parse(expr), handler, cc);
        }
        catch (ParseException pe) {
            throw new PnutsException(pe, (Context)cc);
        }
    }

    public PnutsFunction compile(PnutsFunction pf) {
        return this.compile(pf, new Context());
    }

    public PnutsFunction compile(PnutsFunction pf, Context context) {
        StringBuffer buf = new StringBuffer();
        Enumeration e = Runtime.getFunctions(pf);
        while (e.hasMoreElements()) {
            Function f = (Function)e.nextElement();
            int nargs = f.getNumberOfParameter();
            String[] im = f.getImportEnv();
            buf.append("import(null);");
            for (int i = 0; i < im.length; ++i) {
                buf.append("import(\"" + im[i] + "\");");
            }
            buf.append(pf.unparse(nargs));
            buf.append('\n');
        }
        Context c = (Context)context.clone();
        Runtime.setPackage(pf.getPackage(), c);
        return (PnutsFunction)this.compile(buf.toString(), context).run(c);
    }

    public static boolean isCompiled(Object obj) {
        if (obj instanceof Compiled) {
            return true;
        }
        if (obj instanceof PnutsFunction) {
            Enumeration e = Runtime.getFunctions((PnutsFunction)obj);
            while (e.hasMoreElements()) {
                Function f = (Function)e.nextElement();
                if (f instanceof Compiled) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        optimize = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Compiler.getBoolean("pnuts.compiler.optimize")) {
                    optimize = true;
                }
                return null;
            }
        });
        hasBootClassLoader = false;
        try {
            Class cls = class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Compiler.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader;
            cls.getDeclaredConstructor(cls);
            hasBootClassLoader = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        hasJava2Security = false;
        try {
            (class$java$lang$Class == null ? (class$java$lang$Class = Compiler.class$("java.lang.Class")) : class$java$lang$Class).getMethod("getProtectionDomain", new Class[0]);
            hasJava2Security = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        codeLoaderFactory = hasBootClassLoader && hasJava2Security ? new Java2CodeLoaderFactory() : new CodeLoaderFactory();
        if (hasJava2Security) {
            privilegedCodeLoaderFactory = new PrivilegedCodeLoaderFactory();
        }
        proxyConf = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Compiler.getBoolean("pnuts.compiler.useDynamicProxy")) {
                    proxyConf = true;
                }
                return null;
            }
        });
    }

    static class PrivilegedCodeLoaderFactory
    extends CodeLoaderFactory {
        PrivilegedCodeLoaderFactory() {
        }

        public CodeLoader create(final ClassLoader parent) {
            return (CodeLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ClassLoader cl = (class$pnuts$lang$Pnuts == null ? (class$pnuts$lang$Pnuts = Compiler.class$("pnuts.lang.Pnuts")) : class$pnuts$lang$Pnuts).getClassLoader();
                    if (cl != null) {
                        if (parent != null && cl != parent) {
                            return new CodeLoader(new MultiClassLoader(parent, cl));
                        }
                        return new CodeLoader(cl);
                    }
                    return new CodeLoader(parent);
                }
            });
        }
    }

    static class Java2CodeLoaderFactory
    extends CodeLoaderFactory {
        Java2CodeLoaderFactory() {
        }

        public CodeLoader create(ClassLoader parent) {
            ClassLoader cl = (class$pnuts$lang$Pnuts == null ? (class$pnuts$lang$Pnuts = Compiler.class$("pnuts.lang.Pnuts")) : class$pnuts$lang$Pnuts).getClassLoader();
            if (cl != null) {
                if (parent != null && cl != parent) {
                    return new CodeLoader(new MultiClassLoader(parent, cl));
                }
                return new CodeLoader(cl);
            }
            return new CodeLoader(parent);
        }
    }

    static class CodeLoaderFactory {
        CodeLoaderFactory() {
        }

        public CodeLoader create(ClassLoader parent) {
            return new CodeLoader0(parent);
        }
    }
}

