/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import pnuts.compiler.ByteBuffer;
import pnuts.compiler.ClassFileException;
import pnuts.compiler.ConstantSet;
import pnuts.compiler.Slot;

class ConstantPool {
    private static final int initialSize = 256;
    private byte[] constant_pool = new byte[256];
    private int top = 0;
    private int index = 1;
    private ConstantSet utfSet = new ConstantSet(32);
    private ConstantSet classSet = new ConstantSet(32);
    private ConstantSet fieldRefSet = new ConstantSet(32);
    private ConstantSet methodRefSet = new ConstantSet(32);

    ConstantPool() {
    }

    public short addConstant(int k) {
        this.ensure(5);
        this.constant_pool[this.top++] = 3;
        this.constant_pool[this.top++] = (byte)(k >> 24);
        this.constant_pool[this.top++] = (byte)(k >> 16);
        this.constant_pool[this.top++] = (byte)(k >> 8);
        this.constant_pool[this.top++] = (byte)k;
        return (short)this.index++;
    }

    public short addConstant(long k) {
        this.ensure(9);
        this.constant_pool[this.top++] = 5;
        this.constant_pool[this.top++] = (byte)(k >> 56);
        this.constant_pool[this.top++] = (byte)(k >> 48);
        this.constant_pool[this.top++] = (byte)(k >> 40);
        this.constant_pool[this.top++] = (byte)(k >> 32);
        this.constant_pool[this.top++] = (byte)(k >> 24);
        this.constant_pool[this.top++] = (byte)(k >> 16);
        this.constant_pool[this.top++] = (byte)(k >> 8);
        this.constant_pool[this.top++] = (byte)k;
        short _index = (short)this.index;
        this.index += 2;
        return _index;
    }

    short addConstant(float k) {
        this.ensure(5);
        this.constant_pool[this.top++] = 4;
        int bits = Float.floatToIntBits(k);
        this.constant_pool[this.top++] = (byte)(bits >> 24);
        this.constant_pool[this.top++] = (byte)(bits >> 16);
        this.constant_pool[this.top++] = (byte)(bits >> 8);
        this.constant_pool[this.top++] = (byte)bits;
        return (short)this.index++;
    }

    public short addConstant(double k) {
        this.ensure(9);
        this.constant_pool[this.top++] = 6;
        long bits = Double.doubleToLongBits(k);
        this.constant_pool[this.top++] = (byte)(bits >> 56);
        this.constant_pool[this.top++] = (byte)(bits >> 48);
        this.constant_pool[this.top++] = (byte)(bits >> 40);
        this.constant_pool[this.top++] = (byte)(bits >> 32);
        this.constant_pool[this.top++] = (byte)(bits >> 24);
        this.constant_pool[this.top++] = (byte)(bits >> 16);
        this.constant_pool[this.top++] = (byte)(bits >> 8);
        this.constant_pool[this.top++] = (byte)bits;
        short _index = (short)this.index;
        this.index += 2;
        return _index;
    }

    public short addConstant(String k) {
        Slot slot = this.utfSet.getSlot(k);
        short[] _index = (short[])slot.value;
        if (_index == null) {
            _index = new short[]{(short)this.index++, -1};
            slot.value = _index;
            try {
                this.addUTF(k);
            }
            catch (UTFDataFormatException e) {
                throw new ClassFileException();
            }
        }
        if (_index[1] == -1) {
            _index[1] = (short)this.index++;
            this.ensure(3);
            this.constant_pool[this.top++] = 8;
            this.constant_pool[this.top++] = (byte)(_index[0] >> 8);
            this.constant_pool[this.top++] = (byte)_index[0];
        }
        return _index[1];
    }

    public void addUTF(String str) throws UTFDataFormatException {
        char c;
        int i;
        char[] chars = str.toCharArray();
        int strlen = chars.length;
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensure(utflen + 3);
        this.constant_pool[this.top++] = 1;
        this.constant_pool[this.top++] = (byte)(utflen >>> 8 & 0xFF);
        this.constant_pool[this.top++] = (byte)(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen; ++i) {
            c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                this.constant_pool[this.top++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.constant_pool[this.top++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.constant_pool[this.top++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.constant_pool[this.top++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.constant_pool[this.top++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.constant_pool[this.top++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public short addUTF8(String str) {
        Slot slot = this.utfSet.getSlot(str);
        short[] _index = (short[])slot.value;
        if (_index == null) {
            _index = new short[]{(short)this.index++, -1};
            slot.value = _index;
            try {
                this.addUTF(str);
            }
            catch (UTFDataFormatException e) {
                throw new ClassFileException();
            }
        }
        return _index[0];
    }

    public short addNameAndType(short nameIndex, short typeIndex) {
        this.ensure(5);
        this.constant_pool[this.top++] = 12;
        this.constant_pool[this.top++] = (byte)(nameIndex >> 8);
        this.constant_pool[this.top++] = (byte)nameIndex;
        this.constant_pool[this.top++] = (byte)(typeIndex >> 8);
        this.constant_pool[this.top++] = (byte)typeIndex;
        return (short)this.index++;
    }

    short addClass(short classIndex) {
        Slot slot = this.classSet.getSlot(new Short(classIndex));
        Short _index = (Short)slot.value;
        if (_index == null) {
            this.ensure(3);
            this.constant_pool[this.top++] = 7;
            this.constant_pool[this.top++] = (byte)(classIndex >> 8);
            this.constant_pool[this.top++] = (byte)classIndex;
            _index = new Short((short)this.index++);
            slot.value = _index;
        }
        return _index;
    }

    public short addClass(String className) {
        return this.addClass(this.addUTF8(className.replace('.', '/')));
    }

    public short addFieldRef(String className, String fieldName, String fieldType) {
        Slot slot = this.fieldRefSet.getSlot(className + " " + fieldName + " " + fieldType);
        Short _index = (Short)slot.value;
        if (_index == null) {
            short nameIndex = this.addUTF8(fieldName);
            short typeIndex = this.addUTF8(fieldType);
            short nameAndTypeIndex = this.addNameAndType(nameIndex, typeIndex);
            short classIndex = this.addClass(className);
            this.ensure(5);
            this.constant_pool[this.top++] = 9;
            this.constant_pool[this.top++] = (byte)(classIndex >> 8);
            this.constant_pool[this.top++] = (byte)classIndex;
            this.constant_pool[this.top++] = (byte)(nameAndTypeIndex >> 8);
            this.constant_pool[this.top++] = (byte)nameAndTypeIndex;
            _index = new Short((short)this.index++);
            slot.value = _index;
        }
        return _index;
    }

    public short addMethodRef(String className, String methodName, String fieldType) {
        Slot slot = this.methodRefSet.getSlot(className + " " + methodName + " " + fieldType);
        Short _index = (Short)slot.value;
        if (_index == null) {
            short nameIndex = this.addUTF8(methodName);
            short typeIndex = this.addUTF8(fieldType);
            short nameAndTypeIndex = this.addNameAndType(nameIndex, typeIndex);
            short classIndex = this.addClass(className);
            this.ensure(5);
            this.constant_pool[this.top++] = 10;
            this.constant_pool[this.top++] = (byte)(classIndex >> 8);
            this.constant_pool[this.top++] = (byte)classIndex;
            this.constant_pool[this.top++] = (byte)(nameAndTypeIndex >> 8);
            this.constant_pool[this.top++] = (byte)nameAndTypeIndex;
            _index = new Short((short)this.index++);
            slot.value = _index;
        }
        return _index;
    }

    short addInterfaceMethodRef(String className, String methodName, String methodType) {
        short nameIndex = this.addUTF8(methodName);
        short typeIndex = this.addUTF8(methodType);
        short nameAndTypeIndex = this.addNameAndType(nameIndex, typeIndex);
        short classIndex = this.addClass(className);
        this.ensure(5);
        this.constant_pool[this.top++] = 11;
        this.constant_pool[this.top++] = (byte)(classIndex >> 8);
        this.constant_pool[this.top++] = (byte)classIndex;
        this.constant_pool[this.top++] = (byte)(nameAndTypeIndex >> 8);
        this.constant_pool[this.top++] = (byte)nameAndTypeIndex;
        return (short)this.index++;
    }

    public void write(ByteBuffer buf) {
        buf.add((short)this.index);
        buf.add(this.constant_pool, 0, this.top);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort((short)this.index);
        out.write(this.constant_pool, 0, this.top);
    }

    final void ensure(int room) {
        if (this.top + room >= this.constant_pool.length) {
            byte[] tmp = this.constant_pool;
            this.constant_pool = new byte[this.constant_pool.length + this.top + room + 1];
            System.arraycopy(tmp, 0, this.constant_pool, 0, this.top);
        }
    }
}

