/*
 * Decompiled with CFR 0.152.
 */
package pnuts.compiler;

import java.util.Hashtable;
import java.util.Vector;
import pnuts.compiler.LocalInfo;
import pnuts.compiler.Reference;
import pnuts.compiler.SymbolSet;

class Frame {
    Frame parent;
    SymbolSet symbolSet;
    SymbolSet bottom;
    String fname;
    String[] locals;
    Vector imports = new Vector();
    Hashtable exports = new Hashtable();
    boolean leaf = true;
    Object attr;

    Frame() {
        this.openLocal();
    }

    Frame(String[] locals, String fname, Frame parent, boolean leaf) {
        this.parent = parent;
        if (fname != null) {
            this.fname = fname.intern();
        }
        for (int i = 0; i < locals.length; ++i) {
            locals[i] = locals[i].intern();
        }
        this.locals = locals;
        this.symbolSet = this.bottom = new SymbolSet(null);
        this.leaf = leaf;
        this.openLocal();
    }

    void openLocal() {
        this.symbolSet = new SymbolSet(this.symbolSet);
    }

    void closeLocal() {
        this.symbolSet = this.symbolSet.parent;
    }

    boolean setReference(String sym) {
        LocalInfo info = this.symbolSet.assoc(sym);
        if (info != null) {
            info.initialized = true;
            return true;
        }
        return false;
    }

    Reference getReference(String sym) {
        LocalInfo info = this.symbolSet.assoc(sym);
        if (info != null) {
            return new Reference(sym, info.map, info.index, info.initialized);
        }
        if (this.locals != null) {
            for (int i = 0; i < this.locals.length; ++i) {
                if (this.locals[i] != sym) continue;
                return new Reference(sym, 1, i, true);
            }
        }
        return null;
    }

    public void declare(String symbol, int key, int idx) {
        this.bottom.add(symbol, key, idx);
    }

    public void declare(String symbol, int key) {
        this.bottom.add(symbol, key);
    }

    public void _declare(String symbol, int key, int idx) {
        this.symbolSet.add(symbol, key, idx);
    }

    public void _declare(String symbol, int key) {
        this.symbolSet.add(symbol, key);
    }
}

