/*
 * Decompiled with CFR 0.152.
 */
package pnuts.ext;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import pnuts.ext.ConfigurationAdapter;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;
import pnuts.lang.Property;
import pnuts.lang.Runtime;

public class PublicMemberAccessor
extends ConfigurationAdapter {
    public PublicMemberAccessor() {
    }

    public PublicMemberAccessor(Configuration conf) {
        super(conf);
    }

    public Object getField(Context context, Object target, String name) {
        if (target instanceof Context) {
            return ((Context)target).get(name);
        }
        if (target instanceof Property) {
            return ((Property)target).get(name, context);
        }
        if (target instanceof Map) {
            return ((Map)target).get(name);
        }
        return this.getObjectField(context, target, name);
    }

    public void putField(Context context, Object target, String name, Object expr) {
        if (target instanceof Context) {
            ((Context)target).set(name, expr);
        } else if (target instanceof Property) {
            ((Property)target).set(name, expr, context);
        } else if (target instanceof Map) {
            ((Map)target).put(name, expr);
        } else {
            this.putObjectField(context, target, name, expr);
        }
    }

    protected Object getObjectField(Context context, Object target, String name) {
        try {
            return this.getField(target.getClass(), name).get(target);
        }
        catch (NoSuchFieldException e1) {
            throw new PnutsException("field.notFound", new Object[]{name, target.getClass()}, context);
        }
        catch (PnutsException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    protected void putObjectField(Context context, Object target, String name, Object value) {
        try {
            Field field = this.getField(target.getClass(), name);
            Class<?> type = field.getType();
            if (type.isArray() && value != null && Runtime.isArray(value) && !type.isInstance(value)) {
                value = Runtime.transform(Runtime.getBottomType(type), value);
            }
            field.set(target, value);
        }
        catch (NoSuchFieldException e1) {
            throw new PnutsException("field.notFound", new Object[]{name, target.getClass()}, context);
        }
        catch (PnutsException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PnutsException(e, context);
        }
    }

    public Object getStaticField(Context context, Class clazz, String name) {
        try {
            return this.getField(clazz, name).get(null);
        }
        catch (PnutsException p) {
            throw p;
        }
        catch (NoSuchFieldException f) {
            throw new PnutsException("field.notFound", new Object[]{name, clazz}, context);
        }
        catch (Throwable t) {
            throw new PnutsException(t, context);
        }
    }

    public void putStaticField(Context context, Class clazz, String name, Object value) {
        try {
            Field field = this.getField(clazz, name);
            Class<?> type = field.getType();
            if (type.isArray() && value != null && Runtime.isArray(value) && !type.isInstance(value)) {
                value = Runtime.transform(Runtime.getBottomType(type), value);
            }
            field.set(null, value);
        }
        catch (PnutsException e0) {
            throw e0;
        }
        catch (NoSuchFieldException f) {
            throw new PnutsException("field.notFound", new Object[]{name, clazz}, context);
        }
        catch (Throwable e) {
            throw new PnutsException(e, context);
        }
    }

    public Method[] getMethods(final Class cls) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cls.getMethods();
            }
        });
    }

    public Constructor[] getConstructors(final Class cls) {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cls.getConstructors();
            }
        });
    }

    protected Field getField(final Class cls, final String name) throws NoSuchFieldException {
        try {
            return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return cls.getField(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchFieldException)e.getException();
        }
    }
}

