/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import pnuts.lang.Context;
import pnuts.lang.Escape;
import pnuts.lang.ImportEnv;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

final class Builtin
extends PnutsFunction {
    protected Builtin(String name) {
        super(name);
    }

    protected Object exec(Object[] args, Context context) {
        block75: {
            if (this.name == PnutsFunction._getContext) {
                if (args.length == 0) {
                    return context;
                }
            } else if (this.name == PnutsFunction._package) {
                if (args.length == 1) {
                    Package pkg = args[0] instanceof Package ? (Package)args[0] : (args[0] != null ? Package.getPackage((String)args[0], context) : Package.getInstance(null, context.currentPackage.root, context));
                    context.setCurrentPackage(pkg);
                    return null;
                }
                if (args.length == 0) {
                    return context.currentPackage;
                }
            } else if (this.name == PnutsFunction._import) {
                if (args.length == 1) {
                    if (args[0] == null) {
                        context.importEnv = new ImportEnv();
                        return null;
                    }
                    String s = (String)args[0];
                    if (!s.endsWith("*")) {
                        context.addClassToImport(s);
                    } else {
                        int idx = s.lastIndexOf(46);
                        if (idx > 0) {
                            context.addPackageToImport(s.substring(0, idx));
                        } else {
                            context.addPackageToImport("");
                        }
                    }
                    return null;
                }
                if (args.length == 0) {
                    return context.importEnv.list();
                }
            } else if (this.name == PnutsFunction._throw) {
                if (args.length == 1) {
                    Object arg = args[0];
                    if (arg instanceof PnutsException) {
                        throw (PnutsException)arg;
                    }
                    if (arg instanceof Throwable) {
                        throw new PnutsException((Throwable)arg, context);
                    }
                    throw new PnutsException(arg.toString(), context);
                }
            } else if (this.name == PnutsFunction._defined) {
                if (args.length == 1) {
                    return new Boolean(context.defined((String)args[0]));
                }
            } else if (this.name == PnutsFunction._quit) {
                if (args.length == 0) {
                    throw new Escape();
                }
                if (args.length == 1) {
                    throw new Escape(args[0]);
                }
            } else if (this.name == PnutsFunction._eval) {
                Context c = null;
                if (args.length == 1) {
                    c = (Context)context.clone(false, true);
                    c.eval = true;
                    return Pnuts.eval((String)args[0], c);
                }
                if (args.length == 2) {
                    if (args[1] instanceof Context) {
                        c = (Context)((Context)args[1]).clone(false, true);
                    } else if (args[1] instanceof Package) {
                        c = (Context)context.clone(false, true);
                        c.currentPackage = (Package)args[1];
                    } else {
                        c = (Context)context.clone(false, true);
                        c.currentPackage = Package.getPackage((String)args[1], context);
                    }
                    c.eval = true;
                    return c.pnutsImpl.eval((String)args[0], c);
                }
            } else {
                if (this.name == PnutsFunction._loadFile) {
                    try {
                        Context c = null;
                        Object arg0 = args[0];
                        if (args.length > 0) {
                            c = args.length > 1 ? (Context)((Context)args[1]).clone(false, true) : (Context)context.clone();
                            if (arg0 instanceof File) {
                                return Pnuts.loadFile(((File)arg0).getPath(), c);
                            }
                            return Pnuts.loadFile((String)arg0, c);
                        }
                        break block75;
                    }
                    catch (FileNotFoundException e) {
                        throw new PnutsException(e, context);
                    }
                }
                if (this.name == PnutsFunction._load) {
                    try {
                        Context c = null;
                        if (args.length > 0) {
                            if (args.length > 1) {
                                c = (Context)args[1];
                                c = (Context)c.clone(false, true);
                            } else {
                                c = (Context)context.clone();
                            }
                            if (args[0] instanceof InputStream) {
                                return Pnuts.load((InputStream)args[0], c);
                            }
                            if (args[0] instanceof Reader) {
                                return Pnuts.load((Reader)args[0], c);
                            }
                            if (args[0] instanceof URL) {
                                return Pnuts.load((URL)args[0], c);
                            }
                            return Pnuts.load((String)args[0], c);
                        }
                        break block75;
                    }
                    catch (FileNotFoundException e) {
                        throw new PnutsException(e, context);
                    }
                }
                if (this.name == PnutsFunction._autoload) {
                    if (args.length == 2) {
                        context.currentPackage.autoload((String)args[0], (String)args[1], context);
                        return null;
                    }
                } else if (this.name == PnutsFunction._require) {
                    if (args.length == 1) {
                        try {
                            Context c = (Context)context.clone();
                            Pnuts.require((String)args[0], c);
                            return null;
                        }
                        catch (FileNotFoundException e) {
                            throw new PnutsException(e, context);
                        }
                    }
                } else if (this.name == PnutsFunction._class) {
                    if (args.length == 1) {
                        try {
                            return Pnuts.loadClass((String)args[0], context);
                        }
                        catch (ClassNotFoundException e) {
                            return null;
                        }
                    }
                } else if (this.name == PnutsFunction._use) {
                    if (args.length == 0) {
                        return context.usedPackages();
                    }
                    if (args.length == 1) {
                        Object arg0 = args[0];
                        if (arg0 == null) {
                            context.clearPackages();
                            return null;
                        }
                        if (arg0 instanceof Package) {
                            boolean ret = context.usePackage((Package)arg0, false);
                            return ret ? Boolean.TRUE : Boolean.FALSE;
                        }
                        if (arg0 instanceof String) {
                            boolean ret = context.usePackage((String)arg0, false);
                            return ret ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                } else if (this.name == PnutsFunction._unuse && args.length == 1) {
                    Object arg0 = args[0];
                    Package pkg = null;
                    if (arg0 instanceof String) {
                        pkg = Package.getPackage((String)arg0, context);
                    } else if (arg0 instanceof Package) {
                        pkg = (Package)arg0;
                    }
                    if (pkg != null) {
                        boolean ret = context.unusePackage(pkg);
                        return ret ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
        }
        throw new PnutsException("function.notDefined", new Object[]{this.name, new Integer(args.length)}, context);
    }

    public String toString() {
        return "<builtin " + this.name + ">";
    }

    public String unparse(int narg) {
        return null;
    }

    public String[] getImportEnv(int narg) {
        return null;
    }

    public Package getPackage() {
        return Package.globalPackage;
    }

    public boolean isBuiltin() {
        return true;
    }
}

