/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.pnuts.util.LRUCache;
import pnuts.lang.Context;
import pnuts.lang.Import;
import pnuts.lang.Pnuts;

class ImportEnv
implements Serializable,
Cloneable {
    static final long serialVersionUID = 6645665264703724885L;
    private Hashtable imports = new Hashtable(16);
    private Hashtable importedClasses = new Hashtable(16);
    private Vector pkgOrder = new Vector();
    private Vector classOrder = new Vector();
    private transient LRUCache cache = new LRUCache(32);
    private transient LRUCache failCache = new LRUCache(32);

    ImportEnv() {
    }

    private Import getImport(String name) {
        Import imp = (Import)this.imports.get(name);
        if (imp != null) {
            return imp;
        }
        return new Import(name);
    }

    synchronized void addClass(String className) {
        int idx = className.lastIndexOf(46);
        String name = className.substring(idx + 1);
        Vector<String> vec = (Vector<String>)this.importedClasses.get(name);
        if (vec == null) {
            vec = new Vector<String>(4);
            this.importedClasses.put(name, vec);
        }
        if (this.classOrder.contains(className)) {
            this.classOrder.removeElement(className);
        }
        this.classOrder.addElement(className);
        if (vec.contains(className)) {
            vec.removeElement(className);
        }
        vec.addElement(className);
        this.cache = new LRUCache(32);
        this.failCache = new LRUCache(32);
    }

    synchronized void addPackage(String pkgname) {
        Import imp = (Import)this.imports.get(pkgname);
        if (imp != null) {
            this.pkgOrder.removeElement(imp);
        } else {
            imp = this.getImport(pkgname);
        }
        this.pkgOrder.addElement(imp);
        this.imports.put(pkgname, imp);
        this.cache = new LRUCache(32);
        this.failCache = new LRUCache(32);
    }

    synchronized Class get(String sym, Context context) {
        Object v = this.cache.get(sym);
        if (v != null) {
            return (Class)v;
        }
        Vector vec = (Vector)this.importedClasses.get(sym);
        if (vec != null) {
            int size = vec.size();
            for (int i = size - 1; i >= 0; --i) {
                try {
                    return Pnuts.loadClass((String)vec.elementAt(i), context);
                }
                catch (ClassNotFoundException cnf) {
                    continue;
                }
            }
        }
        int symlen = sym.length();
        StringBuffer buf = new StringBuffer(sym);
        boolean lowercase = !Character.isUpperCase(sym.charAt(0));
        int size = this.pkgOrder.size();
        for (int i = size - 1; i >= 0; --i) {
            Import imp = (Import)this.pkgOrder.elementAt(i);
            buf.setLength(symlen);
            String name = imp.getName();
            if (lowercase && name.startsWith("java.")) continue;
            buf.append(name);
            String key = buf.toString();
            if (this.failCache.get(key) != null) continue;
            Class value = imp.get(sym, context);
            if (value != null) {
                this.cache.put(sym, value);
                return value;
            }
            this.failCache.put(key, key);
        }
        return null;
    }

    String[] list() {
        String[] ret = new String[this.pkgOrder.size() + this.classOrder.size()];
        int i = ret.length - 1;
        Enumeration e = this.pkgOrder.elements();
        while (e.hasMoreElements()) {
            String name = ((Import)e.nextElement()).getName();
            if ("".equals(name)) {
                ret[i--] = "*";
                continue;
            }
            ret[i--] = name + ".*";
        }
        e = this.classOrder.elements();
        while (e.hasMoreElements()) {
            ret[i--] = (String)e.nextElement();
        }
        return ret;
    }

    void reset() {
        this.cache = new LRUCache(32);
        this.failCache = new LRUCache(32);
        Enumeration e = this.pkgOrder.elements();
        while (e.hasMoreElements()) {
            ((Import)e.nextElement()).reset();
        }
    }

    public Object clone() {
        try {
            ImportEnv c = (ImportEnv)super.clone();
            c.imports = (Hashtable)this.imports.clone();
            c.importedClasses = (Hashtable)this.importedClasses.clone();
            c.pkgOrder = (Vector)this.pkgOrder.clone();
            c.classOrder = (Vector)this.classOrder.clone();
            c.cache = new LRUCache(32);
            c.failCache = new LRUCache(32);
            return c;
        }
        catch (Throwable t) {
            throw new InternalError();
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.cache = new LRUCache(32);
        this.failCache = new LRUCache(32);
    }
}

