/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import pnuts.lang.Context;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;
import pnuts.lang.SymbolTable;
import pnuts.lang.Value;

class ModuleList
implements Cloneable,
Serializable {
    transient ArrayList usedPackages = new ArrayList();
    transient Package basePackage;
    private transient SymbolTable cache = new SymbolTable();
    private int modCount = 0;

    ModuleList(Package basePackage) {
        this.basePackage = basePackage;
    }

    synchronized void add(Package pkg) {
        this.usedPackages.remove(pkg);
        this.usedPackages.add(pkg);
        ++this.modCount;
        this.cache = new SymbolTable();
    }

    synchronized boolean remove(Package pkg) {
        if (this.usedPackages.remove(pkg)) {
            ++this.modCount;
            this.cache = new SymbolTable();
            return true;
        }
        return false;
    }

    boolean contains(Package pkg) {
        return this.usedPackages.contains(pkg);
    }

    synchronized void clear() {
        this.usedPackages.clear();
        this.cache = new SymbolTable();
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value resolve(String symbol, Context context) {
        NamedValue v = this.cache.lookup0(symbol);
        if (v != null) {
            return v;
        }
        block3: while (true) {
            int size = this.usedPackages.size();
            int m = this.modCount;
            for (int i = 0; i < size; ++i) {
                Package pkg = (Package)this.usedPackages.get(size - i - 1);
                v = pkg.lookupExportedSymbol(symbol, context);
                if (v != null) {
                    SymbolTable symbolTable = this.cache;
                    synchronized (symbolTable) {
                        this.cache.set(symbol, v.get());
                    }
                    return v;
                }
                if (this.modCount != m) continue block3;
            }
            break;
        }
        return null;
    }

    public Object clone() {
        try {
            ModuleList mlist = (ModuleList)super.clone();
            mlist.usedPackages = (ArrayList)this.usedPackages.clone();
            mlist.cache = new SymbolTable();
            mlist.modCount = 0;
            return mlist;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int size = this.usedPackages.size();
        s.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Package p = (Package)this.usedPackages.get(i);
            s.writeUTF(p.getName());
        }
    }

    String[] getPackageNames() {
        int size = this.usedPackages.size();
        String[] names = new String[size];
        int i = 0;
        Iterator it = ((AbstractList)this.usedPackages).iterator();
        while (it.hasNext()) {
            Package p = (Package)it.next();
            names[i++] = p.getName();
        }
        return names;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.usedPackages = new ArrayList();
        this.cache = new SymbolTable();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.usedPackages.add(Package.getPackage(s.readUTF(), null));
        }
    }
}

