/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import org.pnuts.lang.ConstraintsTransformer;
import pnuts.lang.BinaryOperator;
import pnuts.lang.Binding;
import pnuts.lang.Context;
import pnuts.lang.Function;
import pnuts.lang.Jump;
import pnuts.lang.NamedValue;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.lang.StackFrame;
import pnuts.lang.SymbolTable;
import pnuts.lang.Visitor;

public class PnutsInterpreter
extends Runtime
implements Visitor {
    private static final Integer one = new Integer(1);
    private static final Object[] NO_PARAM = PnutsException.NO_PARAM;
    static PnutsInterpreter instance = new PnutsInterpreter();
    static final int CODE = 0;
    static final int VALUE = 1;
    static final int BROKEN = 0;
    static final int CONT = 1;
    static final int PASSED = 2;

    static PnutsInterpreter getInstance() {
        return instance;
    }

    public Object start(SimpleNode node, Context context) {
        if (node.jjtGetNumChildren() > 0) {
            if (context.stackFrame == null) {
                context.stackFrame = new StackFrame();
            }
            try {
                return this.accept(node, 0, context);
            }
            catch (Throwable t) {
                Runtime.checkException(context, t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startSet(SimpleNode node, Context context) {
        if (context.stackFrame == null) {
            context.stackFrame = new StackFrame();
        }
        int n = node.jjtGetNumChildren();
        Object ret = null;
        try {
            for (int i = 0; i < n; ++i) {
                ret = this.accept(node, i, context);
            }
        }
        catch (Throwable t) {
            Runtime.checkException(context, t);
        }
        finally {
            PrintWriter pw = context.getWriter();
            if (pw != null) {
                pw.flush();
            }
        }
        return ret;
    }

    public Object expressionList(SimpleNode node, Context context) {
        Object ret = null;
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            ret = this.accept(node, i, context);
        }
        return ret;
    }

    public Object global(SimpleNode node, Context context) {
        NamedValue val;
        String symbol = node.str;
        Package pkg = Package.find("", context);
        if (pkg != null && (val = pkg.lookup(symbol, context)) != null) {
            return val.get();
        }
        return context.undefined(symbol);
    }

    public Object idNode(SimpleNode node, Context context) {
        return context.getValue(node.str);
    }

    public Object arrayType(SimpleNode node, Context context) {
        SimpleNode n = node;
        int count = 0;
        while (n != null & n.id == 15) {
            ++count;
            n = n.jjtGetChild(0);
        }
        if (n.id == 17) {
            Object[] idx = PnutsInterpreter.parseIndex(n);
            Object tgt = ((SimpleNode)idx[0]).accept(this, context);
            if (!(tgt instanceof Class)) {
                throw new PnutsException("classOrArray.expected", new Object[]{Pnuts.format(tgt)}, context);
            }
            Class type = Runtime.arrayType((Class)tgt, count);
            Object[] dim = (Object[])idx[1];
            int[] idim = new int[dim.length];
            for (int i = 0; i < dim.length; ++i) {
                Object o = ((SimpleNode)dim[i]).accept(this, context);
                if (!(o instanceof Number)) {
                    throw new PnutsException("number.expected", new Object[]{Pnuts.format(o)}, context);
                }
                idim[i] = ((Number)o).intValue();
            }
            return Array.newInstance(type, idim);
        }
        Object tgt = n.accept(this, context);
        if (tgt instanceof Class) {
            return Runtime.arrayType((Class)tgt, count);
        }
        throw new PnutsException("classOrArray.expected", new Object[]{Pnuts.format(tgt)}, context);
    }

    public Object listElements(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        Object[] ret = new Object[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.accept(node, i, context);
        }
        return ret;
    }

    public Object castExpression(SimpleNode node, Context context) {
        Class type = (Class)this.accept(node, 0, context);
        Object obj = this.accept(node, 1, context);
        return Runtime.cast(context, type, obj, true);
    }

    public Object classNode(SimpleNode node, Context context) {
        String name = node.str;
        int n = node.jjtGetNumChildren();
        if (name == null) {
            return PnutsFunction.CLASS;
        }
        for (int i = 0; i < n; ++i) {
            SimpleNode ch = node.children[i];
            if (ch.id != 9) continue;
            name = name + ".";
            name = name + ch.str;
        }
        try {
            return Pnuts.loadClass(name, context);
        }
        catch (ClassNotFoundException e) {
            throw new PnutsException(e, context);
        }
    }

    public Object rangeNode(SimpleNode node, Context context) {
        Object target = this.accept(node, 0, context);
        Object idx1 = this.accept(node, 1, context);
        Object idx2 = null;
        if (node.jjtGetNumChildren() >= 3) {
            idx2 = this.accept(node, 2, context);
        }
        return Runtime.getRange(target, idx1, idx2, context);
    }

    static Object[] parseIndex(SimpleNode node) {
        SimpleNode c0 = node.jjtGetChild(0);
        SimpleNode c1 = node.jjtGetChild(1);
        if (c0.id != 17) {
            return new Object[]{c0, new Object[]{c1}};
        }
        Object[] r = PnutsInterpreter.parseIndex(c0);
        Object[] d = (Object[])r[1];
        Object[] a = new Object[d.length + 1];
        System.arraycopy(d, 0, a, 0, d.length);
        a[d.length] = c1;
        return new Object[]{r[0], a};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object indexNode(SimpleNode node, Context context) {
        SimpleNode simpleNode = node;
        synchronized (simpleNode) {
            Boolean info = (Boolean)node.info;
            if (info == null) {
                node.info = Boolean.TRUE;
                if (ConstraintsTransformer.isPredicate(node.jjtGetChild(1))) {
                    SimpleNode n = ConstraintsTransformer.buildFunc(node.jjtGetChild(1));
                    node.jjtAddChild(n, 1);
                    n.jjtSetParent(node);
                }
            }
        }
        Object[] idx = PnutsInterpreter.parseIndex(node);
        SimpleNode c = (SimpleNode)idx[0];
        Object[] dim = (Object[])idx[1];
        Object target = c.accept(this, context);
        if (target instanceof Class) {
            int[] sizes = new int[dim.length];
            for (int i = 0; i < dim.length; ++i) {
                sizes[i] = ((Number)((SimpleNode)dim[i]).accept(this, context)).intValue();
            }
            return Array.newInstance((Class)target, sizes);
        }
        for (int i = 0; i < dim.length; ++i) {
            target = Runtime.getElement(target, ((SimpleNode)dim[i]).accept(this, context), context);
        }
        return target;
    }

    public Object methodNode(SimpleNode node, Context context) {
        Object target = this.accept(node, 0, context);
        Object[] arg = (Object[])this.accept(node, 1, context);
        SimpleNode argNode = node.children[1];
        Class[] types = null;
        for (int i = 0; i < arg.length; ++i) {
            SimpleNode n = argNode.children[i];
            if (n.id != 62) continue;
            if (types == null) {
                types = new Class[arg.length];
            }
            types[i] = (Class)this.accept(n, 0, context);
        }
        if (target == null) {
            PnutsException pe = new PnutsException(new NullPointerException(), context);
            pe.line = node.beginLine;
            throw pe;
        }
        return Runtime.callMethod(context, target.getClass(), node.str, arg, types, target);
    }

    public Object staticMethodNode(SimpleNode node, Context context) {
        SimpleNode c1 = node.children[0];
        String pkgName = PnutsInterpreter.getPackageName(c1);
        SimpleNode argNode = node.children[1];
        Class[] types = null;
        Object[] arg = null;
        Package pkg = Package.find(pkgName, context);
        if (pkg != null) {
            Object fun = pkg.get(node.str, context);
            if (fun instanceof PnutsFunction) {
                arg = (Object[])this.accept(node, 1, context);
                PnutsFunction ft = (PnutsFunction)fun;
                return ft.exec(arg, context);
            }
            if (fun instanceof Class) {
                arg = (Object[])this.accept(node, 1, context);
                for (int i = 0; i < arg.length; ++i) {
                    SimpleNode n = argNode.children[i];
                    if (n.id != 62) continue;
                    if (types == null) {
                        types = new Class[arg.length];
                    }
                    types[i] = (Class)this.accept(n, 0, context);
                }
                return Runtime.callConstructor(context, (Class)fun, arg, types);
            }
            throw new PnutsException("illegal.staticCall", new Object[]{pkgName, node.str, new Integer(argNode.jjtGetNumChildren())}, context);
        }
        Object target = this.accept(node, 0, context);
        arg = (Object[])this.accept(node, 1, context);
        if (target instanceof Class) {
            for (int i = 0; i < arg.length; ++i) {
                SimpleNode n = argNode.children[i];
                if (n.id != 62) continue;
                if (types == null) {
                    types = new Class[arg.length];
                }
                types[i] = (Class)this.accept(n, 0, context);
            }
            return Runtime.callMethod(context, (Class)target, node.str, arg, types, null);
        }
        throw new PnutsException("illegal.staticCall", new Object[]{pkgName, node.str, new Integer(arg.length)}, context);
    }

    public Object memberNode(SimpleNode node, Context context) {
        Object target = this.accept(node, 0, context);
        if (target == null) {
            throw new PnutsException(new NullPointerException(), context);
        }
        if (Runtime.isArray(target) && node.str.equals("length")) {
            return new Integer(Runtime.getArrayLength(target));
        }
        return Runtime.getField(context, target, node.str);
    }

    static String getPackageName(SimpleNode node) {
        if (node.jjtGetNumChildren() > 0) {
            SimpleNode c1 = node.children[0];
            return PnutsInterpreter.getPackageName(c1) + "::" + node.str;
        }
        return node.str;
    }

    public Object staticMemberNode(SimpleNode node, Context context) {
        SimpleNode c1 = node.children[0];
        String pkgName = PnutsInterpreter.getPackageName(c1);
        Package pkg = Package.find(pkgName, context);
        if (pkg != null) {
            NamedValue v = pkg.lookup(node.str, context);
            if (v != null) {
                return v.get();
            }
            return context.undefined(node.str);
        }
        Object target = c1.accept(this, context);
        if (target instanceof Class) {
            return Runtime.getStaticField(context, (Class)target, node.str);
        }
        throw new PnutsException("packageOrClass.expected", new Object[]{Pnuts.format(target)}, context);
    }

    public Object applicationNode(SimpleNode node, Context context) {
        Object target = this.accept(node, 0, context);
        Object[] arg = (Object[])this.accept(node, 1, context);
        SimpleNode argNode = node.children[1];
        Class[] types = null;
        for (int i = 0; i < arg.length; ++i) {
            SimpleNode n = argNode.children[i];
            if (n.id != 62) continue;
            if (types == null) {
                types = new Class[arg.length];
            }
            types[i] = (Class)this.accept(n, 0, context);
        }
        return Runtime.call(context, target, arg, types, node.beginLine);
    }

    public Object integerNode(SimpleNode node, Context context) {
        if (node.value != null) {
            return node.value;
        }
        String str = node.str;
        Object[] a = (Object[])node.info;
        int[] off = (int[])a[1];
        Number n = (Number)a[0];
        if (off != null) {
            int offset = off[0];
            return Runtime.quantity(n, str.substring(0, offset), str.substring(offset), context);
        }
        node.value = n;
        return n;
    }

    public Object floatingNode(SimpleNode node, Context context) {
        if (node.value != null) {
            return node.value;
        }
        String str = node.str;
        Object[] p = (Object[])node.info;
        Number n = (Number)p[0];
        if (p[1] != null) {
            int offset = ((int[])p[1])[0];
            return Runtime.quantity(n, str.substring(0, offset), str.substring(offset), context);
        }
        node.value = n;
        return n;
    }

    public Object characterNode(SimpleNode node, Context context) {
        return node.info;
    }

    public Object stringNode(SimpleNode node, Context context) {
        return node.str;
    }

    public Object trueNode(SimpleNode node, Context context) {
        return Boolean.TRUE;
    }

    public Object falseNode(SimpleNode node, Context context) {
        return Boolean.FALSE;
    }

    public Object nullNode(SimpleNode node, Context context) {
        return null;
    }

    private Object doAssign(SimpleNode node, Object expr, Context context, BinaryOperator op) {
        if (node.id == 5) {
            if (op != null) {
                expr = op.operateOn(context.getValue(node.str), expr);
            }
            context.setValue(node.str, expr);
            return expr;
        }
        if (node.id == 4) {
            Package pkg = Package.getPackage("", context);
            if (op != null) {
                expr = op.operateOn(pkg.get(node.str, context), expr);
            }
            pkg.set(node.str, expr, context);
            return expr;
        }
        if (node.id == 17) {
            Object o = this.accept(node, 0, context);
            Object idx = this.accept(node, 1, context);
            if (o instanceof String) {
                if (op != null || !(expr instanceof Character)) {
                    throw new PnutsException("illegal.assign", NO_PARAM, context);
                }
                expr = Runtime.setRange(o, idx, idx, expr, context);
                context.setValue(node.jjtGetChild((int)0).str, expr);
                return expr;
            }
            if (op != null) {
                expr = op.operateOn(Runtime.getElement(o, idx, context), expr);
            }
            Runtime.setElement(o, idx, expr, context);
            return expr;
        }
        if (node.id == 13) {
            SimpleNode c1 = node.children[0];
            String pkgName = PnutsInterpreter.getPackageName(c1);
            Package pkg = Package.find(pkgName, context);
            if (pkg != null) {
                if (op != null) {
                    Object f = pkg.get(node.str, context);
                    expr = op.operateOn(f, expr);
                }
                pkg.set(node.str, expr, context);
                return expr;
            }
            Object target = c1.accept(this, context);
            if (target instanceof Class) {
                Class clazz = (Class)target;
                if (op != null) {
                    expr = op.operateOn(Runtime.getStaticField(context, clazz, node.str), expr);
                }
                Runtime.putStaticField(context, clazz, node.str, expr);
                return expr;
            }
            throw new PnutsException("package.notFound", NO_PARAM, context);
        }
        if (node.id == 12) {
            Object target = this.accept(node, 0, context);
            if (op != null) {
                expr = op.operateOn(Runtime.getField(context, target, node.str), expr);
            }
            Runtime.putField(context, target, node.str, expr);
            return expr;
        }
        if (node.id == 16) {
            if (op != null) {
                throw new PnutsException("illegal.assign", NO_PARAM, context);
            }
            Object target = this.accept(node, 0, context);
            Object idx1 = this.accept(node, 1, context);
            Object idx2 = null;
            if (node.jjtGetNumChildren() >= 3) {
                idx2 = this.accept(node, 2, context);
            }
            Object value = Runtime.setRange(target, idx1, idx2, expr, context);
            if (target instanceof String) {
                SimpleNode cld = node.children[0];
                if (cld.id == 5 || cld.id == 4 || cld.id == 17 || cld.id == 13 || cld.id == 12) {
                    return this.doAssign(cld, value, context, op);
                }
                return value;
            }
            return value;
        }
        throw new PnutsException("illegal.assign", NO_PARAM, context);
    }

    private Object assign(SimpleNode node, Context context, BinaryOperator op) {
        Object expr = this.accept(node, 1, context);
        try {
            return this.doAssign(node.children[0], expr, context, op);
        }
        catch (PnutsException p) {
            throw p;
        }
        catch (Throwable t) {
            throw new PnutsException(t, context);
        }
    }

    public Object assignment(SimpleNode node, Context context) {
        return this.assign(node, context, null);
    }

    public Object assignmentTA(SimpleNode node, Context context) {
        return this.assign(node, context, context._multiply);
    }

    public Object assignmentMA(SimpleNode node, Context context) {
        return this.assign(node, context, context._mod);
    }

    public Object assignmentDA(SimpleNode node, Context context) {
        return this.assign(node, context, context._divide);
    }

    public Object assignmentPA(SimpleNode node, Context context) {
        return this.assign(node, context, context._add);
    }

    public Object assignmentSA(SimpleNode node, Context context) {
        return this.assign(node, context, context._subtract);
    }

    public Object assignmentLA(SimpleNode node, Context context) {
        return this.assign(node, context, context._shiftLeft);
    }

    public Object assignmentRA(SimpleNode node, Context context) {
        return this.assign(node, context, context._shiftRight);
    }

    public Object assignmentRAA(SimpleNode node, Context context) {
        return this.assign(node, context, context._shiftArithmetic);
    }

    public Object assignmentAA(SimpleNode node, Context context) {
        return this.assign(node, context, context._and);
    }

    public Object assignmentEA(SimpleNode node, Context context) {
        return this.assign(node, context, context._xor);
    }

    public Object assignmentOA(SimpleNode node, Context context) {
        return this.assign(node, context, context._or);
    }

    public Object logOrNode(SimpleNode node, Context context) {
        Object o1 = this.accept(node, 0, context);
        if (!(o1 instanceof Boolean)) {
            throw new PnutsException("boolean.expected", new Object[]{Pnuts.format(o1)}, context);
        }
        if (((Boolean)o1).booleanValue()) {
            return Boolean.TRUE;
        }
        Object o2 = this.accept(node, 1, context);
        if (!(o2 instanceof Boolean)) {
            throw new PnutsException("boolean.expected", new Object[]{Pnuts.format(o2)}, context);
        }
        return o2;
    }

    public Object logAndNode(SimpleNode node, Context context) {
        Object o1 = this.accept(node, 0, context);
        if (!(o1 instanceof Boolean)) {
            throw new PnutsException("boolean.expected", new Object[]{Pnuts.format(o1)}, context);
        }
        if (((Boolean)o1).booleanValue()) {
            Object o2 = this.accept(node, 1, context);
            if (!(o2 instanceof Boolean)) {
                throw new PnutsException("boolean.expected", new Object[]{Pnuts.format(o2)}, context);
            }
            return o2;
        }
        return Boolean.FALSE;
    }

    public Object orNode(SimpleNode node, Context context) {
        return context._or.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object xorNode(SimpleNode node, Context context) {
        return context._xor.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object andNode(SimpleNode node, Context context) {
        return context._and.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object equalNode(SimpleNode node, Context context) {
        return Runtime.eq(this.accept(node, 0, context), this.accept(node, 1, context), context) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object notEqNode(SimpleNode node, Context context) {
        return Runtime.eq(this.accept(node, 0, context), this.accept(node, 1, context), context) ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object instanceofExpression(SimpleNode node, Context context) {
        Object o1 = this.accept(node, 0, context);
        Object o2 = this.accept(node, 1, context);
        if (o2 instanceof Class) {
            Class c = (Class)o2;
            return c.isInstance(o1) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (o2 == null) {
            return Boolean.FALSE;
        }
        throw new PnutsException("class.expected", new Object[]{Pnuts.format(o2)}, context);
    }

    public Object ltNode(SimpleNode node, Context context) {
        if (context._lt.operateOn(this.accept(node, 0, context), this.accept(node, 1, context))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object gtNode(SimpleNode node, Context context) {
        if (context._gt.operateOn(this.accept(node, 0, context), this.accept(node, 1, context))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object leNode(SimpleNode node, Context context) {
        if (context._le.operateOn(this.accept(node, 0, context), this.accept(node, 1, context))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object geNode(SimpleNode node, Context context) {
        if (context._ge.operateOn(this.accept(node, 0, context), this.accept(node, 1, context))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object shiftLeftNode(SimpleNode node, Context context) {
        return context._shiftLeft.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object shiftRightNode(SimpleNode node, Context context) {
        return context._shiftRight.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object shiftArithmeticNode(SimpleNode node, Context context) {
        return context._shiftArithmetic.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object addNode(SimpleNode node, Context context) {
        return context._add.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object subtractNode(SimpleNode node, Context context) {
        return context._subtract.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object multNode(SimpleNode node, Context context) {
        return context._multiply.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object divideNode(SimpleNode node, Context context) {
        return context._divide.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object modNode(SimpleNode node, Context context) {
        return context._mod.operateOn(this.accept(node, 0, context), this.accept(node, 1, context));
    }

    public Object negativeNode(SimpleNode node, Context context) {
        return context._negate.operateOn(this.accept(node, 0, context));
    }

    public Object preIncrNode(SimpleNode node, Context context) {
        return this.doAssign(node.children[0], one, context, context._add);
    }

    public Object preDecrNode(SimpleNode node, Context context) {
        return this.doAssign(node.children[0], one, context, context._subtract);
    }

    public Object postIncrNode(SimpleNode node, Context context) {
        SimpleNode n = node.children[0];
        Object ret = n.accept(this, context);
        Object dummy = this.doAssign(n, one, context, context._add);
        return ret;
    }

    public Object postDecrNode(SimpleNode node, Context context) {
        SimpleNode n = node.children[0];
        Object ret = n.accept(this, context);
        Object dummy = this.doAssign(n, one, context, context._subtract);
        return ret;
    }

    public Object notNode(SimpleNode node, Context context) {
        return context._not.operateOn(this.accept(node, 0, context));
    }

    public Object logNotNode(SimpleNode node, Context context) {
        Object o = this.accept(node, 0, context);
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Boolean.FALSE : Boolean.TRUE;
        }
        throw new PnutsException("boolean.expected", new Object[]{Pnuts.format(o)}, context);
    }

    public Object continueNode(SimpleNode node, Context context) {
        SimpleNode parent = node.parent;
        while (parent != null) {
            if (parent.id == 78) {
                PnutsInterpreter.setContinued(parent.children[1]);
                break;
            }
            if (parent.id == 73) break;
            if (parent.id == 72) {
                PnutsInterpreter.setContinued(parent.children[1]);
                break;
            }
            if (parent.id == 68) {
                PnutsInterpreter.setContinued(parent);
            }
            parent = parent.parent;
        }
        return null;
    }

    public Object breakNode(SimpleNode node, Context context) {
        Object o = null;
        if (node.jjtGetNumChildren() > 0) {
            o = this.accept(node, 0, context);
        }
        SimpleNode parent = node.parent;
        while (parent != null) {
            if (parent.id == 73 || parent.id == 72 || parent.id == 78 || parent.id == 79) {
                PnutsInterpreter.setBroken(parent, o);
                break;
            }
            if (parent.id == 68 || parent.id == 80) {
                PnutsInterpreter.setBroken(parent, o);
            }
            parent = parent.parent;
        }
        return o;
    }

    public Object returnNode(SimpleNode node, Context context) {
        Object o = null;
        if (node.jjtGetNumChildren() > 0) {
            o = this.accept(node, 0, context);
        }
        throw new Jump(o);
    }

    public Object catchNode(SimpleNode node, Context context) {
        if (node.jjtGetNumChildren() == 0) {
            return null;
        }
        Object[] args = (Object[])this.accept(node, 0, context);
        if (args.length != 2) {
            throw new PnutsException("wrong.numberOfParameters", new Object[]{"catch"}, context);
        }
        context.catchException((Class)args[0], (PnutsFunction)args[1]);
        return null;
    }

    public Object blockNode(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        Object last = null;
        Object[] attr = PnutsInterpreter.getControlFlowState(node);
        attr[1] = Boolean.FALSE;
        attr[0] = Boolean.FALSE;
        for (int i = 0; i < n; ++i) {
            try {
                last = this.accept(node, i, context);
            }
            catch (PnutsException e) {
                Throwable t = e.getThrowable();
                if (t instanceof ThreadDeath) {
                    PnutsInterpreter.setBroken(node, last);
                }
                throw e;
            }
            if (attr[0] == Boolean.TRUE) {
                last = attr[2];
                break;
            }
            if (attr[1] == Boolean.TRUE) break;
        }
        return last;
    }

    public Object ifStatement(SimpleNode node, Context context) {
        Object con = this.accept(node, 0, context);
        if (PnutsInterpreter.condition(con, context)) {
            return this.accept(node, 1, context);
        }
        int n = node.jjtGetNumChildren();
        for (int i = 2; i < n; ++i) {
            SimpleNode _node = node.children[i];
            if (_node.id == 70) {
                if (!PnutsInterpreter.condition(this.accept(_node, 0, context), context)) continue;
                return this.accept(_node, 1, context);
            }
            if (_node.id != 71) continue;
            return this.accept(_node, 0, context);
        }
        return null;
    }

    static boolean condition(Object cond, Context context) {
        if (cond instanceof Boolean) {
            return (Boolean)cond;
        }
        throw new PnutsException("boolean.expected", new Object[]{Pnuts.format(cond)}, context);
    }

    public Object whileStatement(SimpleNode node, Context context) {
        Object cond;
        Object[] attr = PnutsInterpreter.getControlFlowState(node);
        while ((cond = this.accept(node, 0, context)) instanceof Boolean) {
            Object last = null;
            boolean b = (Boolean)cond;
            if (b) {
                last = this.accept(node, 1, context);
                if (attr[0] != Boolean.TRUE) continue;
                attr[0] = Boolean.FALSE;
                return attr[2];
            }
            attr[0] = Boolean.FALSE;
            return last;
        }
        throw new PnutsException("boolean.expected", new Object[]{Pnuts.format(cond)}, context);
    }

    public Object forStatement(SimpleNode node, Context context) {
        SimpleNode initNode = null;
        SimpleNode condNode = null;
        SimpleNode updateNode = null;
        SimpleNode blockNode = null;
        Object[] attr = PnutsInterpreter.getControlFlowState(node);
        int j = 0;
        SimpleNode n = node.children[j];
        if (n.id == 74) {
            int nc = n.jjtGetNumChildren();
            Object n0 = n.children[0].accept(this, context);
            blockNode = node.children[1];
            if (nc == 1) {
                return this.doForeach(n.str, n0, node.children[1], attr, context);
            }
            if (nc == 2) {
                Object n1 = n.children[1].accept(this, context);
                int start = ((Number)n0).intValue();
                int end = ((Number)n1).intValue();
                return this.doForeach(n.str, start, end, blockNode, attr, context);
            }
            throw new IllegalArgumentException();
        }
        if (n.id == 75) {
            initNode = n;
            ++j;
        }
        n = node.children[j];
        if (n.id != 76 && n.id != 68) {
            condNode = n;
            ++j;
        }
        n = node.children[j];
        if (n.id == 76) {
            updateNode = n;
            ++j;
        }
        blockNode = node.children[j];
        Object last = null;
        if (initNode != null) {
            SimpleNode sn;
            int i;
            int num = initNode.jjtGetNumChildren();
            String[] env = new String[num];
            for (i = 0; i < env.length; ++i) {
                sn = initNode.children[i];
                env[i] = sn.str;
            }
            context.openLocal(env);
            for (i = 0; i < env.length; ++i) {
                sn = initNode.children[i];
                context.bind(env[i], this.accept(sn, 0, context));
            }
        } else {
            context.openLocal(new String[0]);
        }
        Object c = null;
        c = condNode != null ? condNode.accept(this, context) : Boolean.TRUE;
        try {
            while (((Boolean)c).booleanValue()) {
                last = blockNode.accept(this, context);
                if (attr[0] == Boolean.TRUE) {
                    attr[0] = Boolean.FALSE;
                    last = attr[2];
                    break;
                }
                if (updateNode != null) {
                    this.expressionList(updateNode, context);
                }
                if (condNode == null) continue;
                c = condNode.accept(this, context);
            }
        }
        catch (ClassCastException e) {
            throw new PnutsException("boolean.expected", new Object[]{Pnuts.format(c)}, context);
        }
        context.closeLocal();
        return last;
    }

    private Object doForeach(String var, int start, int end, SimpleNode blockNode, Object[] attr, Context context) {
        Object last = null;
        context.openLocal(new String[]{var});
        if (start < end) {
            for (int i = start; i <= end; ++i) {
                context.bind(var, new Integer(i));
                last = blockNode.accept(this, context);
                if (attr[0] != Boolean.TRUE) continue;
                attr[0] = Boolean.FALSE;
                last = attr[2];
                break;
            }
        } else {
            for (int i = start; i >= end; --i) {
                context.bind(var, new Integer(i));
                last = blockNode.accept(this, context);
                if (attr[0] != Boolean.TRUE) continue;
                attr[0] = Boolean.FALSE;
                last = attr[2];
                break;
            }
        }
        context.closeLocal();
        return last;
    }

    private Object doForeach(String var, Object array, SimpleNode blockNode, Object[] attr, Context context) {
        if (array == null) {
            return null;
        }
        Enumeration e = Runtime.toEnumeration(array, context);
        if (e == null) {
            throw new PnutsException("illegal.type.foreach", new Object[]{Pnuts.format(array)}, context);
        }
        Object last = null;
        context.openLocal(new String[]{var});
        while (e.hasMoreElements()) {
            context.bind(var, e.nextElement());
            last = blockNode.accept(this, context);
            if (!((Boolean)attr[0]).booleanValue()) continue;
            attr[0] = Boolean.FALSE;
            last = attr[2];
            break;
        }
        context.closeLocal();
        return last;
    }

    public Object foreachStatement(SimpleNode node, Context context) {
        SimpleNode n1 = node.children[0];
        SimpleNode n2 = node.children[1];
        Object[] attr = PnutsInterpreter.getControlFlowState(node);
        String var = node.str;
        return this.doForeach(var, n1.accept(this, context), n2, attr, context);
    }

    public Object switchStatement(SimpleNode node, Context context) {
        Object[] attr = PnutsInterpreter.getControlFlowState(node);
        int n = node.jjtGetNumChildren();
        Object target = this.accept(node, 0, context);
        Object last = null;
        boolean matched = false;
        for (int i = 1; i < n; ++i) {
            if (attr[0] == Boolean.TRUE) {
                last = attr[2];
                break;
            }
            SimpleNode _node = node.children[i];
            if (_node.jjtGetNumChildren() == 1) {
                Object o = this.accept(_node, 0, context);
                ++i;
                if (!matched && !Runtime.eq(target, o, context)) continue;
                last = this.accept(node, i, context);
                matched = true;
                continue;
            }
            attr[0] = Boolean.FALSE;
            matched = true;
            last = this.accept(node, ++i, context);
        }
        attr[0] = Boolean.FALSE;
        return last;
    }

    public Object switchBlock(SimpleNode node, Context context) {
        Object[] attr = PnutsInterpreter.getControlFlowState(node);
        int n = node.jjtGetNumChildren();
        Object last = null;
        for (int i = 0; i < n; ++i) {
            try {
                last = this.accept(node, i, context);
            }
            catch (PnutsException e) {
                Throwable t = e.getThrowable();
                if (t instanceof ThreadDeath) {
                    PnutsInterpreter.setBroken(node, last);
                }
                throw e;
            }
            if (attr[0] != Boolean.TRUE) continue;
            attr[0] = Boolean.FALSE;
            last = attr[2];
            break;
        }
        return last;
    }

    public Object functionStatement(SimpleNode node, Context context) {
        int n = node.jjtGetNumChildren();
        SimpleNode block = null;
        int nargs = 0;
        String[] locals = null;
        for (int i = 0; i < n; ++i) {
            SimpleNode _node = node.children[i];
            if (_node.id == 83) {
                nargs = _node.jjtGetNumChildren();
                locals = new String[nargs];
                SimpleNode n0 = null;
                if (nargs == 1) {
                    n0 = _node.children[0];
                    if (n0.id == 17) {
                        nargs = -1;
                        locals[0] = n0.children[0].str;
                        continue;
                    }
                }
                for (int j = 0; j < nargs; ++j) {
                    locals[j] = _node.children[j].str;
                }
                continue;
            }
            if (_node.id != 68) continue;
            block = _node;
        }
        String symbol = node.str;
        StackFrame stackFrame = context.stackFrame;
        Package pkg = context.getCurrentPackage();
        Function f = new Function(symbol, locals, nargs, block, pkg, context);
        String name = f.getName();
        PnutsFunction ht = null;
        if (symbol != null) {
            if (stackFrame.parent != null) {
                Object o = null;
                Binding b = (Binding)stackFrame.lookup(symbol);
                boolean found = false;
                if (b != null) {
                    o = b.value;
                    ht = o instanceof PnutsFunction ? f.register((PnutsFunction)o) : Runtime.defineUnboundFunction(f, symbol, pkg);
                    found = true;
                } else {
                    Function ff = context.frame;
                    while (ff != null) {
                        Binding bb;
                        SymbolTable ls = ff.lexicalScope;
                        if (ls != null && (bb = ls.lookup0(symbol)) != null) {
                            o = ((Binding)bb.value).value;
                            ht = o instanceof PnutsFunction ? f.register((PnutsFunction)o, true) : Runtime.defineUnboundFunction(f, symbol, pkg);
                            found = true;
                            break;
                        }
                        ff = ff.outer;
                    }
                }
                if (!found) {
                    ht = Runtime.defineUnboundFunction(f, symbol, pkg);
                }
                if (b != null) {
                    b.set(ht);
                } else {
                    stackFrame.assign(symbol, ht);
                }
            } else {
                ht = Runtime.defineTopLevelFunction(f, symbol, pkg, context);
            }
        } else {
            ht = f.register(null);
        }
        return ht;
    }

    protected static void setBroken(SimpleNode node, Object value) {
        Object[] attr = PnutsInterpreter.getControlFlowState(node);
        attr[0] = Boolean.TRUE;
        attr[2] = value;
    }

    protected static void setContinued(SimpleNode node) {
        Object[] attr = PnutsInterpreter.getControlFlowState(node);
        attr[1] = Boolean.TRUE;
    }

    protected Object accept(SimpleNode node, int idx, Context context) {
        return node.children[idx].accept(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] getControlFlowState(SimpleNode node) {
        ThreadLocal tl;
        SimpleNode simpleNode = node;
        synchronized (simpleNode) {
            tl = (ThreadLocal)node.info;
            if (tl == null) {
                tl = new ControlFlowState();
                node.info = tl;
            }
        }
        return (Object[])tl.get();
    }

    static class ControlFlowState
    extends ThreadLocal
    implements Serializable {
        ControlFlowState() {
        }

        protected Object initialValue() {
            return new Object[]{Boolean.FALSE, Boolean.FALSE, null};
        }
    }
}

