/*
 * Decompiled with CFR 0.152.
 */
package pnuts.security;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.security.auth.Subject;
import pnuts.lang.Implementation;
import pnuts.lang.PnutsImpl;
import pnuts.security.SecurePnutsImpl;

public class JAASPnutsImpl
extends SecurePnutsImpl {
    private Subject subject;

    public JAASPnutsImpl(PnutsImpl impl) {
        this(impl, null);
    }

    public JAASPnutsImpl(Implementation impl) {
        this(impl, null);
    }

    public JAASPnutsImpl(PnutsImpl impl, CodeSource codeSource) {
        this(impl, codeSource, null);
    }

    public JAASPnutsImpl(Implementation impl, CodeSource codeSource) {
        this(impl, codeSource, null);
    }

    public JAASPnutsImpl(PnutsImpl impl, CodeSource codeSource, Subject subject) {
        super(impl, codeSource);
        this.subject = subject;
    }

    public JAASPnutsImpl(Implementation impl, CodeSource codeSource, Subject subject) {
        super(impl, codeSource);
        this.subject = subject;
    }

    protected PermissionCollection getPermissions(final CodeSource codesource) {
        if (this.subject != null) {
            PermissionCollection perms = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Policy policy = Policy.getPolicy();
                    if (policy != null) {
                        Set<Principal> s = JAASPnutsImpl.this.subject.getPrincipals();
                        Principal[] principals = new Principal[s.size()];
                        s.toArray(principals);
                        return policy.getPermissions(new ProtectionDomain(codesource, null, null, principals));
                    }
                    return null;
                }
            });
            if (perms == null) {
                perms = new Permissions();
            }
            return perms;
        }
        return super.getPermissions(codesource);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getBaseImpl() + ", " + this.getCodeSource() + "]";
    }
}

