/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class Console {
    private final int defaultColumns = 80;
    private final int defaultRows = 24;
    protected JTextArea textarea;
    protected JFrame frame = new JFrame();
    private ConsoleBuffer out;
    private PipedReader in;
    private Vector history;
    private int historyIndex = -1;
    private int mark = 0;
    private PipedWriter pipe;
    private EventHandler handler;

    public Console() {
        this.textarea = new JTextArea();
        this.history = new Vector();
        this.out = new ConsoleBuffer();
        this.pipe = new PipedWriter();
        this.in = new PipedReader();
        try {
            this.pipe.connect(this.in);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        this.handler = new EventHandler();
        this.textarea.getDocument().addDocumentListener(this.handler);
        this.textarea.addKeyListener(this.handler);
        this.textarea.setLineWrap(true);
        this.textarea.setFont(new Font("Monospaced", 0, 12));
        JScrollPane scroller = new JScrollPane(this.textarea);
        this.frame.setContentPane(scroller);
        this.textarea.setRows(24);
        this.textarea.setColumns(80);
        this.frame.pack();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JTextArea getTextArea() {
        return this.textarea;
    }

    public Reader getReader() {
        return this.in;
    }

    public Writer getWriter() {
        return this.out;
    }

    synchronized void write(String str) {
        this.textarea.insert(str, this.mark);
        this.mark += str.length();
        int pos = this.textarea.getDocument().getLength();
        this.textarea.select(pos, pos);
    }

    synchronized void enter() {
        Document doc = this.textarea.getDocument();
        int len = doc.getLength();
        Segment segment = new Segment();
        try {
            doc.getText(this.mark, len - this.mark, segment);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        if (segment.count > 0) {
            this.history.addElement(segment.toString());
        }
        this.historyIndex = this.history.size();
        try {
            this.enter(segment.array, segment.offset, segment.count);
            this.textarea.append("\n");
            this.mark = doc.getLength();
            this.out.flush();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    public void enter(String str) throws IOException {
        char[] carray = str.toCharArray();
        this.enter(carray, 0, carray.length);
    }

    public void enter(char[] cbuf, int offset, int size) throws IOException {
        this.pipe.write(cbuf, offset, size);
        this.pipe.write("\n");
        this.pipe.flush();
    }

    class ConsoleBuffer
    extends Writer {
        private StringBuffer buf = new StringBuffer();

        ConsoleBuffer() {
        }

        public synchronized void write(int ch) {
            this.buf.append((char)ch);
            if (ch == 10) {
                this.flushBuffer();
            }
        }

        public synchronized void write(char[] data, int off, int len) {
            for (int i = off; i < len; ++i) {
                this.buf.append(data[i]);
                if (data[i] != '\n') continue;
                this.flushBuffer();
            }
        }

        public synchronized void flush() throws IOException {
            if (this.buf.length() > 0) {
                this.flushBuffer();
            }
        }

        public void close() throws IOException {
            this.flush();
        }

        public int size() {
            return this.buf.length();
        }

        private void flushBuffer() {
            final String str = this.buf.toString();
            this.buf.setLength(0);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Console.this.write(str);
                }
            });
        }
    }

    class EventHandler
    implements KeyListener,
    DocumentListener {
        EventHandler() {
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            boolean control = e.isControlDown();
            int pos = Console.this.textarea.getCaretPosition();
            if (code == 8 || code == 37) {
                if (Console.this.mark == pos) {
                    e.consume();
                }
            } else if (control && code == 65) {
                Console.this.textarea.setCaretPosition(Console.this.mark);
                e.consume();
            } else if (control && code == 69) {
                Console.this.textarea.setCaretPosition(Console.this.textarea.getDocument().getLength());
                e.consume();
            } else if (control && code == 66) {
                if (Console.this.mark < pos) {
                    Console.this.textarea.setCaretPosition(pos - 1);
                }
                e.consume();
            } else if (control && code == 68) {
                Document doc = Console.this.textarea.getDocument();
                if (pos < doc.getLength()) {
                    try {
                        doc.remove(pos, 1);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                }
                e.consume();
            } else if (control && code == 70) {
                if (Console.this.textarea.getDocument().getLength() > pos) {
                    Console.this.textarea.setCaretPosition(pos + 1);
                }
                e.consume();
            } else if (control && code == 75) {
                Document doc = Console.this.textarea.getDocument();
                try {
                    doc.remove(pos, doc.getLength() - pos);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                e.consume();
            } else if (control && code == 85) {
                Document doc = Console.this.textarea.getDocument();
                try {
                    doc.remove(Console.this.mark, doc.getLength() - Console.this.mark);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                e.consume();
            } else if (code == 36 || control && code == 65) {
                if (pos == Console.this.mark) {
                    e.consume();
                } else if (pos > Console.this.mark && !control) {
                    if (e.isShiftDown()) {
                        Console.this.textarea.moveCaretPosition(Console.this.mark);
                    } else {
                        Console.this.textarea.setCaretPosition(Console.this.mark);
                    }
                    e.consume();
                }
            } else if (code == 10) {
                Console.this.enter();
                e.consume();
            } else if (code == 38 || control && code == 80) {
                Console.this.historyIndex--;
                if (Console.this.historyIndex >= 0) {
                    if (Console.this.historyIndex >= Console.this.history.size()) {
                        Console.this.historyIndex = Console.this.history.size() - 1;
                    }
                    if (Console.this.historyIndex >= 0) {
                        String str = (String)Console.this.history.elementAt(Console.this.historyIndex);
                        int len = Console.this.textarea.getDocument().getLength();
                        Console.this.textarea.replaceRange(str, Console.this.mark, len);
                        int caretPos = Console.this.mark + str.length();
                        Console.this.textarea.select(caretPos, caretPos);
                    } else {
                        Console.this.historyIndex++;
                    }
                } else {
                    Console.this.historyIndex++;
                }
                e.consume();
            } else if (code == 40 || control && code == 78) {
                int caretPos = Console.this.mark;
                if (Console.this.history.size() > 0) {
                    Console.this.historyIndex++;
                    if (Console.this.historyIndex < 0) {
                        Console.this.historyIndex = 0;
                    }
                    int len = Console.this.textarea.getDocument().getLength();
                    if (Console.this.historyIndex < Console.this.history.size()) {
                        String str = (String)Console.this.history.elementAt(Console.this.historyIndex);
                        Console.this.textarea.replaceRange(str, Console.this.mark, len);
                        caretPos = Console.this.mark + str.length();
                    } else {
                        Console.this.historyIndex = Console.this.history.size();
                        Console.this.textarea.replaceRange("", Console.this.mark, len);
                    }
                }
                Console.this.textarea.select(caretPos, caretPos);
                e.consume();
            }
        }

        public void keyTyped(KeyEvent e) {
            char keyChar = e.getKeyChar();
            if (keyChar == '\b') {
                if (Console.this.mark == Console.this.textarea.getCaretPosition()) {
                    e.consume();
                }
            } else if (Console.this.textarea.getCaretPosition() < Console.this.mark) {
                Console.this.textarea.setCaretPosition(Console.this.mark);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertUpdate(DocumentEvent e) {
            Console console2 = Console.this;
            synchronized (console2) {
                int len = e.getLength();
                int off = e.getOffset();
                if (Console.this.mark > off) {
                    Console.this.mark += len;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent e) {
            Console console2 = Console.this;
            synchronized (console2) {
                int len = e.getLength();
                int off = e.getOffset();
                if (Console.this.mark > off) {
                    if (Console.this.mark >= off + len) {
                        Console.this.mark -= len;
                    } else {
                        Console.this.mark = off;
                    }
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

