/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import org.pnuts.multithread.ThreadPool;
import pnuts.lang.Context;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.security.SecurePnutsImpl;
import pnuts.tools.Main;
import pnuts.tools.MultiplexedInputStream;

public class PersonalServer {
    public static final int DEFAULT_PORT = 0;
    static final int ACTION_INTERRUPT = 2;
    static final int ACTION_INTERACT = 1;
    static final int ACTION_BATCH = 0;
    static final int STDIO_MASK = 16;
    private static final boolean DEBUG = false;
    private static Context context;
    private static boolean verbose;
    private static MultiplexedInputStream mux;
    private int port;
    private String home;
    private long cookie;
    private boolean shutdown = false;
    private ThreadPool pool = new ThreadPool(Integer.MAX_VALUE, 1, 10000L);
    private Hashtable threads = new Hashtable();

    public PersonalServer() throws IOException {
        this(0, null);
    }

    public PersonalServer(int port, String home) throws IOException {
        this.port = port;
        if (home == null) {
            home = System.getProperty("user.home");
        }
        this.home = home;
    }

    void refuse(Socket sock) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        Socket s;
        ServerSocket ss = new ServerSocket(this.port);
        int localport = ss.getLocalPort();
        this.initialize(localport);
        if (verbose) {
            System.out.println("port = " + localport);
        }
        while ((s = ss.accept()) != null) {
            this.pool.addTask(new Task(s));
        }
        throw new RuntimeException("connection refused");
    }

    static boolean checkConnect(File cookieFile) {
        try {
            FileInputStream in = new FileInputStream(cookieFile);
            int b1 = in.read();
            int b2 = in.read();
            int port = b1 << 8 | b2;
            new Socket("127.0.0.1", port);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    void initialize(int port) throws IOException {
        File pref = new File(this.home, ".pnuts");
        if (!pref.exists() && !pref.mkdir()) {
            return;
        }
        File cookieFile = new File(pref, "cookie");
        if (!cookieFile.createNewFile() && PersonalServer.checkConnect(cookieFile)) {
            System.exit(-1);
        }
        cookieFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(cookieFile);
        out.write(port >>> 8 & 0xFF);
        out.write(port >>> 0 & 0xFF);
        long r = new Random(new Random().nextLong()).nextLong();
        out.write((int)(r >>> 56) & 0xFF);
        out.write((int)(r >>> 48) & 0xFF);
        out.write((int)(r >>> 40) & 0xFF);
        out.write((int)(r >>> 32) & 0xFF);
        out.write((int)(r >>> 24) & 0xFF);
        out.write((int)(r >>> 16) & 0xFF);
        out.write((int)(r >>> 8) & 0xFF);
        out.write((int)(r >>> 0) & 0xFF);
        this.cookie = r;
        out.close();
    }

    static void writeInt(OutputStream out, int r) throws IOException {
        out.write(r >>> 24 & 0xFF);
        out.write(r >>> 16 & 0xFF);
        out.write(r >>> 8 & 0xFF);
        out.write(r >>> 0 & 0xFF);
    }

    static int readInt(InputStream in) throws IOException {
        int c1 = in.read();
        int c2 = in.read();
        int c3 = in.read();
        int c4 = in.read();
        return (c1 << 24) + (c2 << 16) + (c3 << 8) + (c4 << 0);
    }

    static long readLong(InputStream in) throws IOException {
        int c1 = in.read();
        int c2 = in.read();
        int c3 = in.read();
        int c4 = in.read();
        int c5 = in.read();
        int c6 = in.read();
        int c7 = in.read();
        int c8 = in.read();
        return ((long)((c1 << 24) + (c2 << 16) + (c3 << 8) + (c4 << 0)) << 32) + ((long)((c5 << 24) + (c6 << 16) + (c7 << 8) + (c8 << 0)) & 0xFFFFFFFFL);
    }

    static void start(String[] args) {
        try {
            String module_property;
            int port = 0;
            String home = null;
            boolean useInterpreter = false;
            boolean optimize = false;
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-port".equals(arg)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-home".equals(arg)) {
                    home = args[++i];
                    continue;
                }
                if ("-pure".equals(arg)) {
                    useInterpreter = true;
                    continue;
                }
                if (!"-O".equals(arg)) continue;
                optimize = true;
            }
            if (!useInterpreter) {
                System.setProperty("pnuts.lang.defaultPnutsImpl", "pnuts.compiler.CompilerPnutsImpl");
                System.setProperty("pnuts.compiler.useDynamicProxy", "true");
                if (optimize) {
                    System.setProperty("pnuts.compiler.optimize", "true");
                }
            }
            PersonalServer s = new PersonalServer(port, home);
            context = new Context();
            if (Pnuts.isJava2() && System.getSecurityManager() != null) {
                context.setImplementation(new SecurePnutsImpl(context.getImplementation()));
            }
            if ((module_property = System.getProperty("pnuts.tools.modules")) != null) {
                StringTokenizer stoken = new StringTokenizer(module_property, ",");
                while (stoken.hasMoreTokens()) {
                    context.usePackage(stoken.nextToken());
                }
            }
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if ("-m".equals(arg)) {
                    context.usePackage(args[++i]);
                    continue;
                }
                if ("-r".equals(arg)) {
                    Pnuts.load(args[++i], (Context)context.clone());
                    continue;
                }
                if ("-f".equals(arg)) {
                    Pnuts.loadFile(args[++i], (Context)context.clone());
                    continue;
                }
                if ("-u".equals(arg)) {
                    Pnuts.load(new URL(args[++i]), (Context)context.clone());
                    continue;
                }
                if (!"-v".equals(arg)) continue;
                verbose = true;
            }
            s.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void stop() {
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(new String[]{"psh", "-e", "System::exit(0)"});
            proc.waitFor();
        }
        catch (IOException e1) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Throwable {
        if (args.length < 1 || args[0].equals("start")) {
            PersonalServer.start(args);
        } else if (args[0].equals("stop")) {
            PersonalServer.stop();
        } else {
            Main.printHelp("pserv");
            System.exit(0);
        }
    }

    static {
        mux = new MultiplexedInputStream();
        System.setIn(mux);
    }

    class Task
    implements Runnable {
        Socket sock;

        Task(Socket sock) {
            this.sock = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Socket s = this.sock;
            Socket io_sock = null;
            PrintWriter pw = null;
            OutputStream out = null;
            Context c = null;
            try {
                InetAddress localAddr = s.getLocalAddress();
                InetAddress addr = s.getInetAddress();
                if (!localAddr.equals(addr)) {
                    PersonalServer.this.refuse(s);
                    return;
                }
                InputStream in = s.getInputStream();
                long cc = PersonalServer.readLong(in);
                if (cc != PersonalServer.this.cookie) {
                    PersonalServer.this.refuse(s);
                    return;
                }
                int action = in.read();
                if ((action & 0xFFFFFFEF) == 2) {
                    int thread = PersonalServer.readInt(in);
                    Thread t = (Thread)PersonalServer.this.threads.get(new Integer(thread));
                    if (t == null) return;
                    t.interrupt();
                    return;
                }
                out = s.getOutputStream();
                Thread currentThread = Thread.currentThread();
                int threadID = currentThread.hashCode();
                PersonalServer.this.threads.put(new Integer(threadID), currentThread);
                PersonalServer.writeInt(out, threadID);
                out.flush();
                c = new Context(context);
                c.setCurrentPackage((Package)Package.getGlobalPackage().clone());
                OutputStream stdout = out;
                if ((action & 0x10) != 0) {
                    ServerSocket inout = new ServerSocket(0);
                    int localport = inout.getLocalPort();
                    PersonalServer.writeInt(out, localport);
                    out.flush();
                    io_sock = inout.accept();
                    stdout = io_sock.getOutputStream();
                    mux.register(io_sock.getInputStream());
                }
                c.setOutputStream(stdout);
                c.setErrorWriter(new PrintWriter(stdout));
                pw = c.getErrorWriter();
                c.setTerminalWriter(null);
                c.set("pnuts.tools.hotstart".intern(), Boolean.TRUE);
                if ((action & 1) != 0) {
                    Pnuts.load(in, c);
                    c.setTerminalWriter(new PrintWriter(stdout));
                }
                Pnuts.load(in, (action & 1) != 0, c);
                pw = c.getWriter();
                if (pw == null) return;
                pw.flush();
                return;
            }
            catch (Exception e) {
                if (pw == null) {
                    pw = new PrintWriter(System.err);
                }
                if (c != null && c.isVerbose()) {
                    e.printStackTrace(pw);
                } else {
                    pw.println(e);
                }
                pw.flush();
                return;
            }
            finally {
                try {
                    if (out != null) {
                        out.write(255);
                    }
                }
                catch (IOException e2) {}
                try {
                    s.close();
                }
                catch (IOException e3) {}
                try {
                    if (io_sock != null) {
                        io_sock.close();
                    }
                }
                catch (IOException e4) {}
            }
        }
    }
}

