/*
 * Decompiled with CFR 0.152.
 */
package org.activeio;

import java.io.EOFException;
import java.io.IOException;
import org.activeio.Packet;

public final class PacketData {
    private final Packet packet;
    private final boolean bigEndian;

    public PacketData(Packet packet) {
        this(packet, true);
    }

    public PacketData(Packet packet, boolean bigEndian) {
        this.packet = packet;
        this.bigEndian = bigEndian;
    }

    private void spaceNeeded(int space) throws IOException {
        if (this.packet.remaining() < space) {
            throw new EOFException("Not enough space left in the packet.");
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.spaceNeeded(len);
        this.packet.read(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        int rc = Math.min(n, this.packet.remaining());
        this.packet.position(this.packet.position() + rc);
        return rc;
    }

    public boolean readBoolean() throws IOException {
        this.spaceNeeded(1);
        return this.packet.read() != 0;
    }

    public byte readByte() throws IOException {
        this.spaceNeeded(1);
        return (byte)this.packet.read();
    }

    public int readUnsignedByte() throws IOException {
        this.spaceNeeded(1);
        return this.packet.read();
    }

    public short readShort() throws IOException {
        this.spaceNeeded(2);
        if (this.bigEndian) {
            return (short)((this.packet.read() << 8) + (this.packet.read() << 0));
        }
        return (short)((this.packet.read() << 0) + (this.packet.read() << 8));
    }

    public int readUnsignedShort() throws IOException {
        this.spaceNeeded(2);
        if (this.bigEndian) {
            return (this.packet.read() << 8) + (this.packet.read() << 0);
        }
        return (this.packet.read() << 0) + (this.packet.read() << 8);
    }

    public char readChar() throws IOException {
        this.spaceNeeded(2);
        if (this.bigEndian) {
            return (char)((this.packet.read() << 8) + (this.packet.read() << 0));
        }
        return (char)((this.packet.read() << 0) + (this.packet.read() << 8));
    }

    public int readInt() throws IOException {
        this.spaceNeeded(4);
        if (this.bigEndian) {
            return (this.packet.read() << 24) + (this.packet.read() << 16) + (this.packet.read() << 8) + (this.packet.read() << 0);
        }
        return (this.packet.read() << 0) + (this.packet.read() << 8) + (this.packet.read() << 16) + (this.packet.read() << 24);
    }

    public long readLong() throws IOException {
        this.spaceNeeded(8);
        if (this.bigEndian) {
            return ((long)this.packet.read() << 56) + ((long)this.packet.read() << 48) + ((long)this.packet.read() << 40) + ((long)this.packet.read() << 32) + ((long)this.packet.read() << 24) + (long)(this.packet.read() << 16) + (long)(this.packet.read() << 8) + (long)(this.packet.read() << 0);
        }
        return (long)((this.packet.read() << 0) + (this.packet.read() << 8) + (this.packet.read() << 16)) + ((long)this.packet.read() << 24) + ((long)this.packet.read() << 32) + ((long)this.packet.read() << 40) + ((long)this.packet.read() << 48) + ((long)this.packet.read() << 56);
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void write(int b) throws IOException {
        this.spaceNeeded(1);
        this.packet.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.spaceNeeded(len);
        this.packet.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.spaceNeeded(1);
        this.packet.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.spaceNeeded(1);
        this.packet.write(v);
    }

    public void writeShort(int v) throws IOException {
        this.spaceNeeded(2);
        if (this.bigEndian) {
            this.packet.write(v >>> 8 & 0xFF);
            this.packet.write(v >>> 0 & 0xFF);
        } else {
            this.packet.write(v >>> 0 & 0xFF);
            this.packet.write(v >>> 8 & 0xFF);
        }
    }

    public void writeChar(int v) throws IOException {
        this.spaceNeeded(2);
        if (this.bigEndian) {
            this.packet.write(v >>> 8 & 0xFF);
            this.packet.write(v >>> 0 & 0xFF);
        } else {
            this.packet.write(v >>> 0 & 0xFF);
            this.packet.write(v >>> 8 & 0xFF);
        }
    }

    public void writeInt(int v) throws IOException {
        this.spaceNeeded(4);
        if (this.bigEndian) {
            this.packet.write(v >>> 24 & 0xFF);
            this.packet.write(v >>> 16 & 0xFF);
            this.packet.write(v >>> 8 & 0xFF);
            this.packet.write(v >>> 0 & 0xFF);
        } else {
            this.packet.write(v >>> 0 & 0xFF);
            this.packet.write(v >>> 8 & 0xFF);
            this.packet.write(v >>> 16 & 0xFF);
            this.packet.write(v >>> 24 & 0xFF);
        }
    }

    public void writeLong(long v) throws IOException {
        this.spaceNeeded(8);
        if (this.bigEndian) {
            this.packet.write((int)(v >>> 56) & 0xFF);
            this.packet.write((int)(v >>> 48) & 0xFF);
            this.packet.write((int)(v >>> 40) & 0xFF);
            this.packet.write((int)(v >>> 32) & 0xFF);
            this.packet.write((int)(v >>> 24) & 0xFF);
            this.packet.write((int)(v >>> 16) & 0xFF);
            this.packet.write((int)(v >>> 8) & 0xFF);
            this.packet.write((int)(v >>> 0) & 0xFF);
        } else {
            this.packet.write((int)(v >>> 0) & 0xFF);
            this.packet.write((int)(v >>> 8) & 0xFF);
            this.packet.write((int)(v >>> 16) & 0xFF);
            this.packet.write((int)(v >>> 24) & 0xFF);
            this.packet.write((int)(v >>> 32) & 0xFF);
            this.packet.write((int)(v >>> 40) & 0xFF);
            this.packet.write((int)(v >>> 48) & 0xFF);
            this.packet.write((int)(v >>> 56) & 0xFF);
        }
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeRawDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    public void writeRawFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }
}

