/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import org.activeio.AcceptListener;
import org.activeio.AsynchChannelServer;
import org.activeio.Channel;
import org.activeio.ChannelServer;
import org.activeio.SynchChannelServer;
import org.activeio.adapter.SynchToAsynchChannelAdapter;
import org.activeio.adapter.SynchToAsynchChannelServerAdapter;

public final class AsynchToSynchChannelServerAdapter
implements SynchChannelServer,
AcceptListener {
    private final AsynchChannelServer asynchChannelServer;
    private final EDU.oswego.cs.dl.util.concurrent.Channel acceptBuffer;

    public static SynchChannelServer adapt(ChannelServer channel) {
        return AsynchToSynchChannelServerAdapter.adapt(channel, (EDU.oswego.cs.dl.util.concurrent.Channel)new LinkedQueue());
    }

    public static SynchChannelServer adapt(ChannelServer channel, EDU.oswego.cs.dl.util.concurrent.Channel upPacketChannel) {
        if (channel instanceof SynchChannelServer) {
            return (SynchChannelServer)channel;
        }
        if (channel.getClass() == SynchToAsynchChannelAdapter.class) {
            return ((SynchToAsynchChannelServerAdapter)channel).getSynchChannelServer();
        }
        return new AsynchToSynchChannelServerAdapter((AsynchChannelServer)channel, upPacketChannel);
    }

    public AsynchToSynchChannelServerAdapter(AsynchChannelServer asynchChannelServer) {
        this(asynchChannelServer, (EDU.oswego.cs.dl.util.concurrent.Channel)new LinkedQueue());
    }

    public AsynchToSynchChannelServerAdapter(AsynchChannelServer asynchChannelServer, EDU.oswego.cs.dl.util.concurrent.Channel acceptBuffer) {
        this.asynchChannelServer = asynchChannelServer;
        this.acceptBuffer = acceptBuffer;
        this.asynchChannelServer.setAcceptListener(this);
    }

    public Channel accept(long timeout) throws IOException {
        try {
            Object o = timeout == 0L ? this.acceptBuffer.poll(0L) : (timeout == -1L ? this.acceptBuffer.take() : this.acceptBuffer.poll(timeout));
            if (o == null) {
                return null;
            }
            if (o instanceof Channel) {
                return (Channel)o;
            }
            Throwable e = (Throwable)o;
            throw (IOException)new IOException("Asynch error occured: " + e).initCause(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
    }

    public void dispose() {
        this.asynchChannelServer.dispose();
    }

    public void start() throws IOException {
        this.asynchChannelServer.start();
    }

    public void stop(long timeout) throws IOException {
        this.asynchChannelServer.stop(timeout);
    }

    public URI getBindURI() {
        return this.asynchChannelServer.getBindURI();
    }

    public URI getConnectURI() {
        return this.asynchChannelServer.getConnectURI();
    }

    public void onAccept(Channel channel) {
        try {
            this.acceptBuffer.put((Object)channel);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onAcceptError(IOException error) {
        try {
            this.acceptBuffer.put((Object)error);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public AsynchChannelServer getAsynchChannelServer() {
        return this.asynchChannelServer;
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.asynchChannelServer.narrow(target);
    }

    public String toString() {
        return this.asynchChannelServer.toString();
    }
}

