/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.adapter;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import org.activeio.AcceptListener;
import org.activeio.AsynchChannelServer;
import org.activeio.Channel;
import org.activeio.ChannelFactory;
import org.activeio.ChannelServer;
import org.activeio.Disposable;
import org.activeio.SynchChannelServer;
import org.activeio.adapter.AsynchToSynchChannelServerAdapter;
import org.activeio.adapter.SynchToAsynchChannelAdapter;

public final class SynchToAsynchChannelServerAdapter
implements AsynchChannelServer,
Runnable {
    private final SynchChannelServer synchChannelServer;
    private final SynchronizedBoolean running = new SynchronizedBoolean(false);
    private final Executor executor;
    private AcceptListener acceptListener;
    private Latch doneLatch;

    public static AsynchChannelServer adapt(ChannelServer channel) {
        return SynchToAsynchChannelServerAdapter.adapt(channel, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public static AsynchChannelServer adapt(ChannelServer channel, Executor executor) {
        if (channel instanceof AsynchChannelServer) {
            return (AsynchChannelServer)channel;
        }
        if (channel.getClass() == SynchToAsynchChannelAdapter.class) {
            return ((AsynchToSynchChannelServerAdapter)channel).getAsynchChannelServer();
        }
        return new SynchToAsynchChannelServerAdapter((SynchChannelServer)channel, executor);
    }

    public SynchToAsynchChannelServerAdapter(SynchChannelServer synchServer) {
        this(synchServer, ChannelFactory.DEFAULT_EXECUTOR);
    }

    public SynchToAsynchChannelServerAdapter(SynchChannelServer synchServer, Executor executor) {
        this.synchChannelServer = synchServer;
        this.executor = executor;
    }

    public synchronized void start() throws IOException {
        if (this.running.commit(false, true)) {
            if (this.acceptListener == null) {
                throw new IllegalStateException("AcceptListener must be set before object can be started.");
            }
            this.synchChannelServer.start();
            try {
                this.doneLatch = new Latch();
                this.executor.execute((Runnable)this);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
    }

    public synchronized void stop(long timeout) throws IOException {
        if (this.running.commit(true, false)) {
            try {
                if (timeout == 0L) {
                    this.synchChannelServer.stop(0L);
                } else if (timeout == -1L) {
                    this.doneLatch.acquire();
                    this.synchChannelServer.stop(-1L);
                } else {
                    long start = System.currentTimeMillis();
                    timeout = this.doneLatch.attempt(timeout) ? (timeout -= System.currentTimeMillis() - start) : 0L;
                    if (timeout <= 0L) {
                        this.synchChannelServer.stop(0L);
                    } else {
                        this.synchChannelServer.stop(timeout);
                    }
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw (IOException)new IOException("stop failed: " + e.getMessage()).initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String oldName;
        block7: {
            oldName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.synchChannelServer.toString());
            try {
                while (this.running.get()) {
                    try {
                        Channel channel = this.synchChannelServer.accept(500L);
                        if (channel == null) continue;
                        this.acceptListener.onAccept(channel);
                    }
                    catch (IOException e) {
                        if (!this.running.get()) continue;
                        this.acceptListener.onAcceptError(e);
                    }
                    catch (Throwable e) {
                        if (!this.running.get()) continue;
                        this.acceptListener.onAcceptError((IOException)new IOException("Unexpected Error: " + e).initCause(e));
                    }
                }
                Object var4_5 = null;
                if (this.doneLatch == null) break block7;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (this.doneLatch != null) {
                    this.doneLatch.release();
                }
                Thread.currentThread().setName(oldName);
                throw throwable;
            }
            this.doneLatch.release();
        }
        Thread.currentThread().setName(oldName);
    }

    public void setAcceptListener(AcceptListener acceptListener) {
        if (this.running.get()) {
            throw new IllegalStateException("Cannot change the AcceptListener while the object is running.");
        }
        this.acceptListener = acceptListener;
    }

    public void dispose() {
        try {
            this.stop(0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.synchChannelServer instanceof Disposable) {
            this.synchChannelServer.dispose();
        }
    }

    public URI getBindURI() {
        return this.synchChannelServer.getBindURI();
    }

    public URI getConnectURI() {
        return this.synchChannelServer.getConnectURI();
    }

    public SynchChannelServer getSynchChannelServer() {
        return this.synchChannelServer;
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.synchChannelServer.narrow(target);
    }

    public String toString() {
        return this.synchChannelServer.toString();
    }
}

