/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import com.ibm.io.async.AsyncSocketChannel;
import com.ibm.io.async.IAbstractAsyncFuture;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.io.async.ICompletionListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelListener;
import org.activeio.Packet;
import org.activeio.net.SocketMetadata;
import org.activeio.packet.ByteBufferPacket;
import org.activeio.packet.EOSPacket;

public final class AIOAsynchChannel
implements AsynchChannel,
ICompletionListener,
SocketMetadata {
    protected static final int DEFAULT_BUFFER_SIZE = ByteBufferPacket.DEFAULT_DIRECT_BUFFER_SIZE;
    private final AsyncSocketChannel socketChannel;
    private final Socket socket;
    private AsynchChannelListener channelListener;
    private ByteBuffer inputByteBuffer;
    private final SynchronizedBoolean running = new SynchronizedBoolean(false);
    private Latch doneLatch;

    protected AIOAsynchChannel(AsyncSocketChannel socketChannel) throws IOException {
        this.socketChannel = socketChannel;
        this.socket = socketChannel.socket();
        this.socket.setSendBufferSize(DEFAULT_BUFFER_SIZE);
        this.socket.setReceiveBufferSize(DEFAULT_BUFFER_SIZE);
        this.socket.setSoTimeout(0);
    }

    private ByteBuffer allocateBuffer() {
        return ByteBuffer.allocateDirect(DEFAULT_BUFFER_SIZE);
    }

    public void setAsynchChannelListener(AsynchChannelListener channelListener) {
        this.channelListener = channelListener;
    }

    public AsynchChannelListener getAsynchChannelListener() {
        return this.channelListener;
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void dispose() {
        if (this.running.get() && this.channelListener != null) {
            this.channelListener.onPacketError(new SocketException("Socket closed."));
        }
        try {
            this.stop(0L);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        if (this.running.commit(false, true)) {
            this.doneLatch = new Latch();
            this.requestNextRead();
        }
    }

    public void stop(long timeout) throws IOException {
        if (this.running.commit(true, false)) {
            try {
                if (timeout == 0L) {
                    this.doneLatch.attempt(0L);
                } else if (timeout == -1L) {
                    this.doneLatch.acquire();
                } else {
                    this.doneLatch.attempt(timeout);
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    public void write(Packet packet) throws IOException {
        ByteBuffer data = ((ByteBufferPacket)packet).getByteBuffer();
        while (data.hasRemaining()) {
            IAsyncFuture future = this.socketChannel.write(data);
            try {
                future.getByteCount();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    public void flush() throws IOException {
    }

    public void futureCompleted(IAbstractAsyncFuture abstractFuture, Object attribute) {
        IAsyncFuture future = (IAsyncFuture)abstractFuture;
        try {
            if (this.inputByteBuffer.position() > 0) {
                ByteBuffer remaining = this.inputByteBuffer.slice();
                ByteBufferPacket data = new ByteBufferPacket(((ByteBuffer)this.inputByteBuffer.flip()).slice());
                this.channelListener.onPacket(data);
                this.inputByteBuffer = remaining;
                this.requestNextRead();
            } else {
                this.channelListener.onPacket(EOSPacket.EOS_PACKET);
            }
        }
        catch (IOException e) {
            this.channelListener.onPacketError(e);
        }
    }

    private void requestNextRead() throws InterruptedIOException {
        if (!this.running.get()) {
            this.doneLatch.release();
            return;
        }
        try {
            if (this.inputByteBuffer == null || !this.inputByteBuffer.hasRemaining()) {
                this.inputByteBuffer = this.allocateBuffer();
            }
            IAsyncFuture future = this.socketChannel.read(this.inputByteBuffer);
            future.addCompletionListener((ICompletionListener)this, null, false);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    public String toString() {
        return "AIO Connection: " + this.getLocalSocketAddress() + " -> " + this.getRemoteSocketAddress();
    }
}

