/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.activeio.net.SocketSynchChannelFactory;
import org.p2psockets.P2PServerSocket;
import org.p2psockets.P2PSocket;

public class JxtaSocketSynchChannelFactory
extends SocketSynchChannelFactory {
    public JxtaSocketSynchChannelFactory() {
        super(JxtaSocketFactory.getDefault(), JxtaServerSocketFactory.getDefault());
    }

    public static final class JxtaSocketFactory
    extends SocketFactory {
        private static JxtaSocketFactory defaultJxtaSocketFactory = new JxtaSocketFactory();

        public static SocketFactory getDefault() {
            return defaultJxtaSocketFactory;
        }

        private JxtaSocketFactory() {
        }

        public Socket createSocket(String remoteHost, int remotePort) throws IOException, UnknownHostException {
            return new P2PSocket(remoteHost, remotePort);
        }

        public Socket createSocket(String remoteHost, int remotePort, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return new P2PSocket(remoteHost, remotePort, localHost, localPort);
        }

        public Socket createSocket(InetAddress remoteHost, int remotePort) throws IOException {
            return new P2PSocket(remoteHost, remotePort);
        }

        public Socket createSocket(InetAddress remoteHost, int remotePort, InetAddress localHost, int localPort) throws IOException {
            return new P2PSocket(remoteHost, remotePort, localHost, localPort);
        }
    }

    public static final class JxtaServerSocketFactory
    extends ServerSocketFactory {
        private static JxtaServerSocketFactory defaultJxtaServerSocketFactory = new JxtaServerSocketFactory();

        public static ServerSocketFactory getDefault() {
            return defaultJxtaServerSocketFactory;
        }

        private JxtaServerSocketFactory() {
        }

        public ServerSocket createServerSocket(int localPort) throws IOException {
            return new P2PServerSocket(localPort);
        }

        public ServerSocket createServerSocket(int localPort, int backlog) throws IOException {
            return new P2PServerSocket(localPort, backlog);
        }

        public ServerSocket createServerSocket(int localPort, int backlog, InetAddress localHost) throws IOException {
            return new P2PServerSocket(localPort, backlog, localHost);
        }
    }
}

