/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelListener;
import org.activeio.Packet;
import org.activeio.net.NIOAsynchChannelSelectorManager;
import org.activeio.net.NIOBaseChannel;
import org.activeio.packet.ByteBufferPacket;
import org.activeio.packet.EOSPacket;

public final class NIOAsynchChannel
extends NIOBaseChannel
implements AsynchChannel {
    private AsynchChannelListener channelListener;
    private NIOAsynchChannelSelectorManager.SocketChannelAsynchChannelSelection selection;
    private ByteBuffer inputByteBuffer;
    private boolean running;

    public NIOAsynchChannel(SocketChannel socketChannel, boolean useDirect) throws IOException {
        super(socketChannel, useDirect);
        socketChannel.configureBlocking(false);
        this.selection = NIOAsynchChannelSelectorManager.register(socketChannel, new NIOAsynchChannelSelectorManager.SelectorManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSelect(NIOAsynchChannelSelectorManager.SocketChannelAsynchChannelSelection selection) {
                String origName = Thread.currentThread().getName();
                if (selection.isReadable()) {
                    try {
                        Thread.currentThread().setName(NIOAsynchChannel.this.toString());
                        NIOAsynchChannel.this.serviceRead();
                    }
                    catch (Throwable e) {
                        System.err.println("ActiveIO unexpected error: ");
                        e.printStackTrace(System.err);
                    }
                    finally {
                        Thread.currentThread().setName(origName);
                    }
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serviceRead() {
        try {
            do {
                int size2;
                int size;
                if (this.inputByteBuffer == null || !this.inputByteBuffer.hasRemaining()) {
                    this.inputByteBuffer = this.allocateBuffer();
                }
                if ((size = this.socketChannel.read(this.inputByteBuffer)) == -1) {
                    this.channelListener.onPacket(EOSPacket.EOS_PACKET);
                    this.selection.close();
                    return;
                }
                if (size == 0) return;
                if (size == 1 && this.inputByteBuffer.hasRemaining() && (size2 = this.socketChannel.read(this.inputByteBuffer)) > 0) {
                    size += size2;
                }
                ByteBuffer remaining = this.inputByteBuffer.slice();
                ByteBufferPacket data = new ByteBufferPacket(((ByteBuffer)this.inputByteBuffer.flip()).slice());
                this.channelListener.onPacket(data);
                this.inputByteBuffer = remaining;
            } while (!this.inputByteBuffer.hasRemaining());
            return;
        }
        catch (IOException e) {
            this.channelListener.onPacketError(e);
        }
    }

    public synchronized void write(Packet packet) throws IOException {
        ByteBuffer data;
        if (packet.getClass() == ByteBufferPacket.class) {
            data = ((ByteBufferPacket)packet).getByteBuffer();
        } else {
            Packet.ByteSequence sequence = packet.asByteSequence();
            data = ByteBuffer.wrap(sequence.getData(), sequence.getOffset(), sequence.getLength());
        }
        long delay = 1L;
        while (data.hasRemaining()) {
            int r1 = data.remaining();
            this.socketChannel.write(data);
            int r2 = data.remaining();
            if (r2 > 0 && r1 - r2 == 0) {
                try {
                    Thread.sleep(delay);
                    if ((delay *= 5L) <= 1000L) continue;
                    delay = 1000L;
                    continue;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
            delay = 1L;
        }
    }

    public void flush() throws IOException {
    }

    public void setAsynchChannelListener(AsynchChannelListener channelListener) {
        this.channelListener = channelListener;
    }

    public AsynchChannelListener getAsynchChannelListener() {
        return this.channelListener;
    }

    public void dispose() {
        if (this.running && this.channelListener != null) {
            this.channelListener.onPacketError(new SocketException("Socket closed."));
        }
        this.selection.close();
        super.dispose();
    }

    public void start() throws IOException {
        if (this.running) {
            return;
        }
        this.running = true;
        this.selection.setInterestOps(1);
    }

    public void stop(long timeout) throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.selection.setInterestOps(0);
    }
}

