/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import org.activeio.Channel;
import org.activeio.SynchChannelServer;
import org.activeio.net.SocketSynchChannel;

public class SocketSynchChannelServer
implements SynchChannelServer {
    private ServerSocket serverSocket;
    private int curentSoTimeout = 0;
    private final URI bindURI;
    private final URI connectURI;

    public SocketSynchChannelServer(ServerSocket serverSocket, URI bindURI, URI connectURI) {
        this.serverSocket = serverSocket;
        this.bindURI = bindURI;
        this.connectURI = connectURI;
    }

    public Channel accept(long timeout) throws IOException {
        try {
            if (timeout == -1L) {
                this.setSoTimeout(0);
            } else if (timeout == 0L) {
                this.setSoTimeout(1);
            } else {
                this.setSoTimeout((int)timeout);
            }
            Socket socket = this.serverSocket.accept();
            return this.createChannel(socket);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return null;
        }
    }

    protected Channel createChannel(Socket socket) throws IOException {
        return new SocketSynchChannel(socket);
    }

    private void setSoTimeout(int i) throws SocketException {
        if (this.curentSoTimeout != i) {
            this.serverSocket.setSoTimeout(i);
            this.curentSoTimeout = i;
        }
    }

    public void dispose() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    public URI getBindURI() {
        return this.bindURI;
    }

    public URI getConnectURI() {
        return this.connectURI;
    }

    public void start() throws IOException {
    }

    public void stop(long timeout) throws IOException {
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return "Socket Server: " + this.getConnectURI();
    }
}

