/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.net;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelListener;
import org.activeio.Packet;
import org.activeio.packet.EOSPacket;

public final class VMPipeAsynchChannelPipe {
    final PipeChannel leftChannel = new PipeChannel();
    final PipeChannel rightChannel = new PipeChannel();

    public VMPipeAsynchChannelPipe() {
        this.leftChannel.setSibiling(this.rightChannel);
        this.rightChannel.setSibiling(this.leftChannel);
    }

    public AsynchChannel getLeftAsynchChannel() {
        return this.leftChannel;
    }

    public AsynchChannel getRightAsynchChannel() {
        return this.rightChannel;
    }

    public static final class PipeChannel
    implements AsynchChannel {
        private PipeChannel sibiling;
        private AsynchChannelListener channelListener;
        private final Semaphore runMutext = new Semaphore(0L);
        private boolean disposed;
        private boolean running;

        public void setAsynchChannelListener(AsynchChannelListener channelListener) {
            this.channelListener = channelListener;
        }

        public AsynchChannelListener getAsynchChannelListener() {
            return this.channelListener;
        }

        public void write(Packet packet) throws IOException {
            if (this.disposed) {
                throw new IOException("Conneciton closed.");
            }
            this.sibiling.onPacket(packet, -1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPacket(Packet packet, long timeout) throws IOException {
            try {
                if (timeout == 0L) {
                    if (!this.runMutext.attempt(0L)) {
                        return;
                    }
                } else if (timeout == -1L) {
                    this.runMutext.acquire();
                } else if (!this.runMutext.attempt(timeout)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            try {
                if (this.disposed) {
                    throw new IOException("Peer connection closed.");
                }
                this.channelListener.onPacket(packet);
            }
            finally {
                this.runMutext.release();
            }
        }

        public void flush() throws IOException {
        }

        public void start() throws IOException {
            if (this.running) {
                return;
            }
            if (this.channelListener == null) {
                throw new IOException("channelListener has not been set.");
            }
            this.running = true;
            this.runMutext.release();
        }

        public void stop(long timeout) throws IOException {
            if (!this.running) {
                return;
            }
            try {
                if (timeout == 0L) {
                    if (!this.runMutext.attempt(0L)) {
                        return;
                    }
                } else if (timeout == -1L) {
                    this.runMutext.acquire();
                } else if (!this.runMutext.attempt(timeout)) {
                    return;
                }
                this.running = false;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        public void dispose() {
            if (this.disposed) {
                return;
            }
            if (this.running && this.channelListener != null) {
                this.channelListener.onPacketError(new IOException("Pipe closed."));
                this.running = false;
            }
            this.disposed = true;
            this.runMutext.release();
            try {
                this.sibiling.onPacket(EOSPacket.EOS_PACKET, 0L);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public PipeChannel getSibiling() {
            return this.sibiling;
        }

        public void setSibiling(PipeChannel sibiling) {
            this.sibiling = sibiling;
        }

        public Object narrow(Class target) {
            if (target.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        public String getId() {
            return "0x" + Integer.toHexString(System.identityHashCode(this));
        }

        public String toString() {
            return "Pipe Channel from " + this.getId() + " to " + this.sibiling.getId();
        }
    }
}

