/*
 * Decompiled with CFR 0.152.
 */
package org.activeio.packet;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.activeio.Packet;
import org.activeio.packet.EmptyPacket;

public final class AppendedPacket
implements Packet {
    private final Packet first;
    private final Packet last;
    private final int capacity;
    private final int firstCapacity;

    public static Packet join(Packet first, Packet last) {
        if (first.hasRemaining()) {
            if (last.hasRemaining()) {
                return new AppendedPacket(first.slice(), last.slice());
            }
            return first.slice();
        }
        if (last.hasRemaining()) {
            return last.slice();
        }
        return EmptyPacket.EMPTY_PACKET;
    }

    public AppendedPacket(Packet first, Packet second) {
        this.first = first;
        this.last = second;
        this.firstCapacity = first.capacity();
        this.capacity = first.capacity() + this.last.capacity();
        this.clear();
    }

    public void position(int position) {
        if (position <= this.firstCapacity) {
            this.last.position(0);
            this.first.position(position);
        } else {
            this.last.position(position - this.firstCapacity);
            this.first.position(this.firstCapacity);
        }
    }

    public void limit(int limit) {
        if (limit <= this.firstCapacity) {
            this.last.limit(0);
            this.first.limit(limit);
        } else {
            this.last.limit(limit - this.firstCapacity);
            this.first.limit(this.firstCapacity);
        }
    }

    public Packet slice() {
        return AppendedPacket.join(this.first, this.last);
    }

    public Packet duplicate() {
        return new AppendedPacket(this.first.duplicate(), this.last.duplicate());
    }

    public Object duplicate(ClassLoader cl) throws IOException {
        try {
            Class<?> pclazz = cl.loadClass(Packet.class.getName());
            Class<?> clazz = cl.loadClass(AppendedPacket.class.getName());
            Constructor<?> constructor = clazz.getConstructor(pclazz, pclazz);
            return constructor.newInstance(this.first.duplicate(cl), this.last.duplicate(cl));
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not duplicate packet in a different classloader: " + e).initCause(e);
        }
    }

    public void flip() {
        this.limit(this.position());
        this.position(0);
    }

    public int position() {
        return this.first.position() + this.last.position();
    }

    public int limit() {
        return this.first.limit() + this.last.limit();
    }

    public int remaining() {
        return this.first.remaining() + this.last.remaining();
    }

    public void rewind() {
        this.first.rewind();
        this.last.rewind();
    }

    public boolean hasRemaining() {
        return this.first.hasRemaining() || this.last.hasRemaining();
    }

    public void clear() {
        this.first.clear();
        this.last.clear();
    }

    public int capacity() {
        return this.capacity;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.first.writeTo(out);
        this.last.writeTo(out);
    }

    public void writeTo(DataOutput out) throws IOException {
        this.first.writeTo(out);
        this.last.writeTo(out);
    }

    public int read() {
        if (this.first.hasRemaining()) {
            return this.first.read();
        }
        if (this.last.hasRemaining()) {
            return this.last.read();
        }
        return -1;
    }

    public int read(byte[] data, int offset, int length) {
        int rc1 = this.first.read(data, offset, length);
        if (rc1 == -1) {
            int rc2 = this.last.read(data, offset, length);
            return rc2 == -1 ? -1 : rc2;
        }
        int rc2 = this.last.read(data, offset + rc1, length - rc1);
        return rc2 == -1 ? rc1 : rc1 + rc2;
    }

    public boolean write(int data) {
        if (this.first.hasRemaining()) {
            return this.first.write(data);
        }
        if (this.last.hasRemaining()) {
            return this.last.write(data);
        }
        return false;
    }

    public int write(byte[] data, int offset, int length) {
        int rc1 = this.first.write(data, offset, length);
        if (rc1 == -1) {
            int rc2 = this.last.write(data, offset, length);
            return rc2 == -1 ? -1 : rc2;
        }
        int rc2 = this.last.write(data, offset + rc1, length - rc1);
        return rc2 == -1 ? rc1 : rc1 + rc2;
    }

    public int read(Packet dest) {
        int rc = this.first.read(dest);
        return rc += this.last.read(dest);
    }

    public String toString() {
        return "{position=" + this.position() + ",limit=" + this.limit() + ",capacity=" + this.capacity() + "}";
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        Object object = this.first.narrow(target);
        if (object == null) {
            object = this.last.narrow(target);
        }
        return object;
    }

    public Packet.ByteSequence asByteSequence() {
        return null;
    }

    public byte[] sliceAsBytes() {
        return null;
    }

    public void dispose() {
        this.first.dispose();
        this.last.dispose();
    }
}

