/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import jp.co.argo21.nautica.workflow.filter.FilterConverter;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;

public class DefinitionFilterConverter
implements FilterConverter {
    public String convertToSQL(Filter filter) throws InvalidFilterException {
        if (filter == null) {
            return "";
        }
        if (filter instanceof NameFilter) {
            return this.convertToSQL((NameFilter)filter);
        }
        if (filter instanceof StateFilter) {
            return this.convertToSQL((StateFilter)filter);
        }
        if (filter instanceof GroupFilter) {
            return this.convertToSQL((GroupFilter)filter);
        }
        String errMsg = StringManager.get("E0004");
        throw new InvalidFilterException(errMsg);
    }

    private String convertToSQL(NameFilter filter) throws InvalidFilterException {
        return "PROC_DEF_ID" + this.getComparisonString(filter.getComparison()) + "'" + filter.getFilterString() + "'";
    }

    private String convertToSQL(StateFilter filter) throws InvalidFilterException {
        return "DEF_STATE = '" + filter.getFilterString() + "'";
    }

    private String convertToSQL(GroupFilter filter) throws InvalidFilterException {
        Filter[] children = filter.getChild();
        int count = children.length;
        if (count == 0) {
            return "";
        }
        String s = this.convertToSQL(children[0]);
        for (int i = 1; i < count; ++i) {
            s = s + " AND " + this.convertToSQL(children[i]);
        }
        return s;
    }

    private String getComparisonString(int comparison) {
        switch (comparison) {
            case 1: {
                return " = ";
            }
            case 6: {
                return " >= ";
            }
            case 5: {
                return " > ";
            }
            case 4: {
                return " <= ";
            }
            case 3: {
                return " < ";
            }
            case 2: {
                return " <> ";
            }
            case 7: {
                return " LIKE ";
            }
        }
        return " <> ";
    }
}

