/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityHistoryDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLActivityHistoryDAO
extends AbstractDAO
implements ActivityHistoryDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String PROC_ID = "PROC_ID";
    public static final String ACT_ID = "ACT_ID";
    public static final String ACT_DEF_ID = "ACT_DEF_ID";
    public static final String ACTOR_ID = "ACTOR_ID";
    public static final String PREV_STATE = "PREV_STATE";
    public static final String NEW_STATE = "NEW_STATE";
    public static final String UPDATE_DATE = "UPDATE_DATE";
    public static final String REASON = "REASON";
    private static final String SQL_INSERT = "insert into ACTIVITYHIST (PROC_ID, ACT_ID, ACT_DEF_ID, ACTOR_ID, PREV_STATE, NEW_STATE, UPDATE_DATE, REASON) values (?,?,?,?,?,?,?,?)";

    MySQLActivityHistoryDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ActivityHistoryBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getProcID());
            st.setString(2, bean.getActID());
            st.setString(3, bean.getActDefID());
            st.setString(4, bean.getActorID());
            st.setInt(5, bean.getPrevState());
            st.setInt(6, bean.getNewState());
            st.setTimestamp(7, bean.getUpdateDate());
            st.setString(8, bean.getReason());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0012");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private ActivityHistoryBean createBean(ResultSet rs) throws SQLException {
        ActivityHistoryBean bean = new ActivityHistoryBean();
        bean.setProcID(rs.getString(PROC_ID));
        bean.setActID(rs.getString(ACT_ID));
        bean.setActDefID(rs.getString(ACT_DEF_ID));
        bean.setActorID(rs.getString(ACTOR_ID));
        bean.setPrevState(rs.getInt(PREV_STATE));
        bean.setNewState(rs.getInt(NEW_STATE));
        bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
        bean.setReason(rs.getString(REASON));
        return bean;
    }
}

