/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.DefinitionFilterConverter;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import org.apache.log4j.Logger;

public class MySQLDefinitionDAO
extends AbstractDAO
implements DefinitionDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String PROC_DEF_ID = "PROC_DEF_ID";
    public static final String PATH = "PATH";
    public static final String INTERNAL_PDID = "INTERNAL_PDID";
    public static final String REGISTER_DATE = "REGISTER_DATE";
    public static final String DEF_STATE = "DEF_STATE";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from DEFINITION where PROC_DEF_ID = ? ";
    private static final String SQL_SELECT_BY_PATH_AND_ID = "select * from DEFINITION where PATH = ? and INTERNAL_PDID = ? ";
    private static final String SQL_SELECT = "select * from DEFINITION ";
    private static final String SQL_INSERT = "insert into DEFINITION (PROC_DEF_ID, PATH, INTERNAL_PDID, REGISTER_DATE, DEF_STATE) values (?,?,?,?,?)";
    private static final String SQL_UPDATE_STATE = "update DEFINITION set DEF_STATE = ? where PROC_DEF_ID = ? AND DEF_STATE = ? ";

    MySQLDefinitionDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinitionBean findByPrimaryKey(String pdid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, pdid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            DefinitionBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            DefinitionBean definitionBean = bean;
            return definitionBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinitionBean findByPathAndID(String path, String ipdid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PATH_AND_ID);
        try {
            st.setString(1, path);
            st.setString(2, ipdid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            DefinitionBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            DefinitionBean definitionBean = bean;
            return definitionBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findByFilter(Filter filter) throws SQLException, DAOException, InvalidFilterException {
        DefinitionFilterConverter converter = new DefinitionFilterConverter();
        String where = converter.convertToSQL(filter);
        if (!where.equals("")) {
            where = " where " + where;
        }
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT + where);
        eLog.debug((Object)st.toString());
        try {
            ResultSet rs = st.executeQuery();
            ArrayList<DefinitionBean> list = new ArrayList<DefinitionBean>();
            while (rs.next()) {
                DefinitionBean bean = this.createBean(rs);
                list.add(bean);
            }
            ArrayList<DefinitionBean> arrayList = list;
            return arrayList;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(DefinitionBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getProcessDefinitionID());
            st.setString(2, bean.getPath());
            st.setString(3, bean.getInternalPDID());
            st.setTimestamp(4, bean.getRegisterDate());
            st.setInt(5, bean.getState());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0016");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(String pdid, int oldState, int newState) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_STATE);
        try {
            st.setInt(1, newState);
            st.setString(2, pdid);
            st.setInt(3, oldState);
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0017");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private DefinitionBean createBean(ResultSet rs) throws SQLException {
        DefinitionBean bean = new DefinitionBean();
        bean.setProcessDefinitionID(rs.getString(PROC_DEF_ID));
        bean.setPath(rs.getString(PATH));
        bean.setInternalPDID(rs.getString(INTERNAL_PDID));
        bean.setRegisterDate(rs.getTimestamp(REGISTER_DATE));
        bean.setState(rs.getInt(DEF_STATE));
        return bean;
    }
}

