/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationBean;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.UserBean;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.MySQLUserManagerDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import org.apache.log4j.Logger;

public class MySQLOrganizationManagerDAO
extends AbstractDAO
implements OrganizationManagerDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    private static final String ORG_ID = "ORG_ID";
    private static final String ORG_NAME = "ORG_NAME";
    private static final String SQL_SELECT_BY_ORG_ID = "select * from ORGANIZATION where ORG_ID = ?";
    private static final String SQL_SELECT_USERS_BY_ORG_ID = "select USER.* from USER, ORGUSERMAP where ORGUSERMAP.ORG_ID = ? and USER.USER_ID = ORGUSERMAP.USER_ID;";
    private static final String SQL_SELECT_BY_USER_ID = "select ORGANIZATION.* from ORGANIZATION, ORGUSERMAP where ORGUSERMAP.USER_ID = ? and ORGANIZATION.ORG_ID = ORGUSERMAP.ORG_ID;";
    private static final String SQL_SELECT_HIGHER_BY_ORG_ID = "SELECT ORG_HIGH.* FROM ORGANIZATION ORG_HIGH, ORGANIZATION ORG_LOW WHERE ORG_HIGH.ORG_ID = ORG_LOW.HIGHER_ORG_ID AND ORG_LOW.ORG_ID = ?";

    MySQLOrganizationManagerDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationBean findByOrganizationID(String oid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_ORG_ID);
        try {
            st.setString(1, oid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            OrganizationBean bean = null;
            if (rs.next()) {
                bean = MySQLOrganizationManagerDAO.createBean(rs);
            }
            OrganizationBean organizationBean = bean;
            return organizationBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserBean[] findUsersByOrganizationID(String oid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_USERS_BY_ORG_ID);
        try {
            st.setString(1, oid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<UserBean> beanList = new ArrayList<UserBean>();
            while (rs.next()) {
                beanList.add(MySQLUserManagerDAO.createBean(rs));
            }
            UserBean[] userBeanArray = beanList.toArray(new UserBean[beanList.size()]);
            return userBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationBean[] findByUserID(String uid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_USER_ID);
        try {
            st.setString(1, uid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<OrganizationBean> beanList = new ArrayList<OrganizationBean>();
            while (rs.next()) {
                beanList.add(MySQLOrganizationManagerDAO.createBean(rs));
            }
            OrganizationBean[] organizationBeanArray = beanList.toArray(new OrganizationBean[beanList.size()]);
            return organizationBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationBean findHigherByOrganizationID(String oid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_HIGHER_BY_ORG_ID);
        try {
            st.setString(1, oid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            OrganizationBean bean = null;
            if (rs.next()) {
                bean = MySQLOrganizationManagerDAO.createBean(rs);
            }
            OrganizationBean organizationBean = bean;
            return organizationBean;
        }
        finally {
            st.close();
        }
    }

    static OrganizationBean createBean(ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            columnNames.add(rs.getMetaData().getColumnName(i));
        }
        OrganizationBean bean = new OrganizationBean();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = ((String)columnNames.get(i)).toUpperCase();
            String attribute = (String)rs.getObject(columnName);
            if (columnName.equals(ORG_ID)) {
                bean.setID(attribute);
            }
            if (columnName.equals(ORG_NAME)) {
                bean.setName(attribute);
            }
            if (columnName.equals(ORG_ID) || columnName.equals(ORG_NAME)) continue;
            bean.setAttribute(columnName, attribute);
        }
        return bean;
    }
}

