/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.SequencerDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import org.apache.log4j.Logger;

public class MySQLSequencerDAO
extends AbstractDAO
implements SequencerDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String SEQ = "SEQ";
    public static final String NAME = "NAME";
    private static final String SQL_INSERT_SEQUENCER = "INSERT INTO KEYSEQ (NAME, SEQ) VALUES (?, 0) ";
    private static final String SQL_UPDATE_SEQUENCER = "UPDATE KEYSEQ SET SEQ = ? WHERE (NAME = ?) AND (SEQ < ?) ";
    private static final String SQL_GET_SEQUENCER = "SELECT SEQ FROM KEYSEQ WHERE NAME = ? ";

    MySQLSequencerDAO(Connection conn) {
        super(conn);
    }

    public int nextForInt(String seqName) throws SQLException {
        long seq = this.next(seqName);
        if (seq > Integer.MAX_VALUE) {
            throw new ArithmeticException("Value is out of INTEGER range.");
        }
        return (int)seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next(String seqName) throws SQLException {
        Connection conn = this.getConnection();
        this.init(conn, seqName);
        long seq = this.current(conn, seqName);
        int result = 0;
        PreparedStatement statement = conn.prepareStatement(SQL_UPDATE_SEQUENCER);
        try {
            while (result < 1) {
                statement.setLong(1, ++seq);
                statement.setString(2, seqName);
                statement.setLong(3, seq);
                eLog.debug((Object)statement.toString());
                result = statement.executeUpdate();
            }
        }
        finally {
            statement.close();
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Connection conn, String seqName) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(SQL_INSERT_SEQUENCER);
        try {
            statement.setString(1, seqName);
            eLog.debug((Object)statement.toString());
            int i = statement.executeUpdate();
        }
        catch (SQLException ex) {
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long current(Connection conn, String seqName) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(SQL_GET_SEQUENCER);
        try {
            statement.setString(1, seqName);
            eLog.debug((Object)statement.toString());
            long seq = -1L;
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                seq = rs.getLong(SEQ);
            }
            rs.close();
            long l = seq;
            return l;
        }
        finally {
            statement.close();
        }
    }
}

