/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import org.apache.log4j.Logger;

public class MySQLWorkItemDAO
extends AbstractDAO
implements WorkItemDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String WORK_ID = "WORK_ID";
    public static final String PROC_ID = "PROC_ID";
    public static final String ACT_ID = "ACT_ID";
    public static final String PARTICIPANT_TYPE = "PARTICIPANT_TYPE";
    public static final String PARTICIPANT_NAME = "PARTICIPANT_NAME";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from WORKITEM where WORK_ID = ? ";
    private static final String SQL_SELECT_BY_PID_AND_AID = "select * from WORKITEM where PROC_ID = ? AND ACT_ID = ? ";
    private static final String SQL_SELECT_COUNT_BY_PARTICIPANT = "select count(*) from WORKITEM where PARTICIPANT_NAME = ? and PARTICIPANT_TYPE = ? ";
    private static final String SQL_SELECT_BY_PARTICIPANT = "select * from WORKITEM where  PARTICIPANT_NAME = ? and PARTICIPANT_TYPE = ? ";
    private static final String SQL_SELECT_WITH_VAR = "select distinct w.* from WORKITEM w, VARIABLE v ";
    private static final String SQL_SELECT = "select distinct w.* from WORKITEM w ";
    private static final String SQL_INSERT = "insert into WORKITEM (WORK_ID, PROC_ID, ACT_ID, PARTICIPANT_TYPE, PARTICIPANT_NAME) values (?,?,?,?,?)";
    private static final String SQL_UPDATE_PARTICIPANT = "update WORKITEM set PARTICIPANT_TYPE = ?, PARTICIPANT_NAME = ? where WORK_ID = ? and PARTICIPANT_TYPE = ? and PARTICIPANT_NAME = ? ";
    private static final String SQL_DELETE = "delete from WORKITEM where WORK_ID = ? ";
    private static final String SQL_DELETE_BY_PID_AND_AID = "delete from WORKITEM where PROC_ID = ? AND ACT_ID = ? ";

    MySQLWorkItemDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemBean findByPrimaryKey(String wid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, wid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            WorkItemBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            WorkItemBean workItemBean = bean;
            return workItemBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemBean findByProcessIDANDActivityID(String pid, String aid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PID_AND_AID);
        try {
            st.setString(1, pid);
            st.setString(2, aid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            WorkItemBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            WorkItemBean workItemBean = bean;
            return workItemBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findCountByParticipant(String name, int type) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_COUNT_BY_PARTICIPANT);
        try {
            st.setString(1, name);
            st.setInt(2, type);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            return n;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemBean[] findByParticipant(String name, int type) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PARTICIPANT);
        try {
            st.setString(1, name);
            st.setInt(2, type);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<WorkItemBean> beans = new ArrayList<WorkItemBean>();
            while (rs.next()) {
                WorkItemBean bean = this.createBean(rs, "w.");
                beans.add(bean);
            }
            WorkItemBean[] workItemBeanArray = beans.toArray(new WorkItemBean[beans.size()]);
            return workItemBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemBean[] findBySQLPart(String s, boolean hasAttrbuteFilter) throws SQLException, DAOException {
        PreparedStatement st = null;
        st = hasAttrbuteFilter ? this.getConnection().prepareStatement(SQL_SELECT_WITH_VAR + s) : this.getConnection().prepareStatement(SQL_SELECT + s);
        try {
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<WorkItemBean> beans = new ArrayList<WorkItemBean>();
            while (rs.next()) {
                WorkItemBean bean = this.createBean(rs, "w.");
                beans.add(bean);
            }
            WorkItemBean[] workItemBeanArray = beans.toArray(new WorkItemBean[beans.size()]);
            return workItemBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(WorkItemBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getID());
            st.setString(2, bean.getProcessID());
            st.setString(3, bean.getActivityID());
            st.setInt(4, bean.getParticipantType());
            st.setString(5, bean.getParticipantName());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0035");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    public void updateParticipant(String wid, Participant src, Participant target) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_UPDATE_PARTICIPANT);
        try {
            if (target == null) {
                st.setNull(1, 4);
                st.setNull(2, 12);
                st.setString(3, wid);
                st.setInt(4, src.getType());
                st.setString(5, src.getID());
            } else {
                st.setInt(1, target.getType());
                st.setString(2, target.getID());
                st.setString(3, wid);
                st.setInt(4, src.getType());
                st.setString(5, src.getID());
            }
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0036");
                throw new DAOException(errMsg);
            }
        }
        catch (WorkflowException ex) {
            String errMsg = StringManager.get("E0036");
            throw new DAOException(errMsg, ex);
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String wid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_DELETE);
        try {
            st.setString(1, wid);
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0034");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByProcessIDANDActivityID(String pid, String aid) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_DELETE_BY_PID_AND_AID);
        try {
            st.setString(1, pid);
            st.setString(2, aid);
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0034");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private WorkItemBean createBean(ResultSet rs) throws SQLException {
        WorkItemBean bean = new WorkItemBean();
        bean.setID(rs.getString(WORK_ID));
        bean.setProcessID(rs.getString(PROC_ID));
        bean.setActivityID(rs.getString(ACT_ID));
        bean.setParticipantType(rs.getInt(PARTICIPANT_TYPE));
        bean.setParticipantName(rs.getString(PARTICIPANT_NAME));
        return bean;
    }

    private WorkItemBean createBean(ResultSet rs, String prefix) throws SQLException {
        WorkItemBean bean = new WorkItemBean();
        bean.setID(rs.getString(prefix + WORK_ID));
        bean.setProcessID(rs.getString(prefix + PROC_ID));
        bean.setActivityID(rs.getString(prefix + ACT_ID));
        bean.setParticipantType(rs.getInt(prefix + PARTICIPANT_TYPE));
        bean.setParticipantName(rs.getString(prefix + PARTICIPANT_NAME));
        return bean;
    }
}

