/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.VariableFilterConverter;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.engine.ActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.ActivityBehaviorFactory;
import jp.co.argo21.nautica.workflow.engine.BehaviorExecutor;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.DefinitionRepositoryImpl;
import jp.co.argo21.nautica.workflow.engine.EndProcessRequestMessage;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ParticipantImpl;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.ResourceInternal;
import jp.co.argo21.nautica.workflow.engine.ResourceManagerFactory;
import jp.co.argo21.nautica.workflow.engine.SystemMessageTransporter;
import jp.co.argo21.nautica.workflow.engine.WorkItemInternal;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.omg.AlreadyRunningException;
import jp.co.argo21.nautica.workflow.omg.AlreadySuspendedException;
import jp.co.argo21.nautica.workflow.omg.CannotResumeException;
import jp.co.argo21.nautica.workflow.omg.CannotStartException;
import jp.co.argo21.nautica.workflow.omg.CannotStopException;
import jp.co.argo21.nautica.workflow.omg.CannotSuspendException;
import jp.co.argo21.nautica.workflow.omg.HistoryNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.InvalidDataException;
import jp.co.argo21.nautica.workflow.omg.InvalidPerformerException;
import jp.co.argo21.nautica.workflow.omg.InvalidStateException;
import jp.co.argo21.nautica.workflow.omg.NotRunningException;
import jp.co.argo21.nautica.workflow.omg.NotSuspendedException;
import jp.co.argo21.nautica.workflow.omg.ResultNotAvailableException;
import jp.co.argo21.nautica.workflow.omg.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.UpdateNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfAssignment;
import jp.co.argo21.nautica.workflow.omg.WfEvent;
import jp.co.argo21.nautica.workflow.omg.WfNameValue;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfResource;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.ParticipantHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import org.apache.log4j.Logger;

public class ActivityInternal
implements WfActivity {
    private static final long serialVersionUID = 20050000000000001L;
    private static Logger eLog = LogManager.getEngineLogger();
    private Activity activity;

    ActivityInternal(Activity act) {
        this.activity = act;
    }

    public WfProcess getContainer() throws WorkflowException {
        String pid = this.activity.getProcessID();
        ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
        ProcessManager pm = pmf.getOwnerProcessManager(pid);
        WfProcess process = pm.getProcess(pid);
        return process;
    }

    public String getID() throws WorkflowException {
        return this.activity.getActivityID();
    }

    public String getName() throws WorkflowException {
        return this.activity.getName();
    }

    public void setName(String name) throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public String getDescription() throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfState getState() throws WorkflowException {
        return ActivityState.getState(this.activity.getActivityState());
    }

    public WfState[] getTransitableStates() throws WorkflowException {
        return ActivityState.getTransitableStates(this.activity.getActivityState());
    }

    public String getLastStateTime() throws WorkflowException {
        return this.activity.getUpdateDate().toString();
    }

    public WfResource getReqesterResource() throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();
            WorkItemBean workitem = workitemDAO.findByProcessIDANDActivityID(this.activity.getProcessID(), this.activity.getActivityID());
            Participant part = null;
            if (workitem == null) {
                part = ParticipantImpl.getSystemParticipant();
            } else {
                int ptype = workitem.getParticipantType();
                String pname = workitem.getParticipantName();
                ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
                if (ptype == 5) {
                    UserManager um = rmf.getUserManager();
                    User user = um.getUser(pname);
                    part = ParticipantHelper.narrow(user);
                } else if (ptype == 4) {
                    OrganizationManager om = rmf.getOrganizationManager();
                    Organization org = om.getOrganization(pname);
                    part = ParticipantHelper.narrow(org);
                } else if (ptype == 3) {
                    RoleManager rm = rmf.getRoleManager();
                    Role role = rm.getRole(pname);
                    part = ParticipantHelper.narrow(role);
                } else {
                    String E0073 = StringManager.get("E0073");
                    throw new WorkflowException(E0073);
                }
            }
            if (part == null) {
                String E0074 = StringManager.get("E0074");
                throw new WorkflowException(E0074);
            }
            ResourceInternal ret = new ResourceInternal(part);
            return ret;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0075 = StringManager.get("E0075");
            throw new WorkflowException(E0075, ex);
        }
    }

    public WfNameValue[] getContext() throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            WfNameValue[] beans = variableDAO.findByProcessID(this.activity.getProcessID());
            return beans;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0076 = StringManager.get("E0076");
            throw new WorkflowException(E0076, ex);
        }
    }

    public WfNameValue getContext(String name) throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            VariableBean beans = variableDAO.findByName(this.activity.getProcessID(), name);
            return beans;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0076 = StringManager.get("E0076") + "(" + name + ")";
            throw new WorkflowException(E0076, ex);
        }
    }

    public WfNameValue[] getResult() throws ResultNotAvailableException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfAssignment[] getAllAssignment() throws WorkflowException {
        try {
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workitemDAO = daoFactory.getWorkItemDAO();
            WorkItemBean workitem = workitemDAO.findByProcessIDANDActivityID(this.activity.getProcessID(), this.activity.getActivityID());
            WfAssignment[] ret = null;
            ret = workitem == null ? new WorkItemInternal[]{} : new WorkItemInternal[]{new WorkItemInternal(workitem)};
            return ret;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0077 = StringManager.get("E0077");
            throw new WorkflowException(E0077, ex);
        }
    }

    public WfAssignment getAssignment(int index) throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public int getAssignmentCount() throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfProcess[] getAllPerformers() throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfProcess getPerformer(int index) throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public int getPerformerCount() throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfEvent[] getAllHistories() throws HistoryNotAvailableException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public WfEvent getHistory(int index) throws HistoryNotAvailableException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public int getHistoryCount() throws HistoryNotAvailableException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public boolean isMemberOfAssignment(WfAssignment ass) throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public boolean isMemberOfPerformer(WfProcess proc) throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public void setDescription(String desc) throws WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public void setResult(WfNameValue[] result) throws InvalidDataException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    public void setContext(WfNameValue[] context) throws InvalidDataException, UpdateNotAllowedException, WorkflowException {
        try {
            if (context == null) {
                String E0079 = StringManager.get("E0079");
                throw new InvalidDataException(E0079);
            }
            String aid = this.activity.getActivityID();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            for (int i = 0; i < context.length; ++i) {
                if (!(context[i] instanceof Attribute)) {
                    String E0078 = StringManager.get("E0078");
                    throw new InvalidDataException(E0078);
                }
                Attribute attr = (Attribute)context[i];
                VariableBean bean = new VariableBean();
                bean.setName(attr.getName());
                bean.setType(attr.getType());
                bean.setValue(attr.getValue());
                VariableBean check = variableDAO.findByPrimaryKey(bean.getProcessID(), bean.getID());
                if (check == null) {
                    bean.setProcessID(this.activity.getProcessID());
                    bean.setUpdateDate(ts);
                    bean.setID(UniqueKeyGenerator.generate("VRI"));
                    variableDAO.insert(bean, aid);
                    continue;
                }
                variableDAO.update(check, bean.getValue(), aid, ts);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0080 = StringManager.get("E0080");
            throw new WorkflowException(E0080, ex);
        }
    }

    public void setContext(WfNameValue context) throws InvalidDataException, UpdateNotAllowedException, WorkflowException {
        try {
            if (context == null) {
                String E0079 = StringManager.get("E0079");
                throw new InvalidDataException(E0079);
            }
            String aid = this.activity.getActivityID();
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            if (!(context instanceof Attribute)) {
                String E0078 = StringManager.get("E0078");
                throw new InvalidDataException(E0078);
            }
            Attribute attr = (Attribute)context;
            VariableBean bean = new VariableBean();
            bean.setName(attr.getName());
            bean.setType(attr.getType());
            bean.setValue(attr.getValue());
            VariableBean check = variableDAO.findByName(this.activity.getProcessID(), bean.getName());
            if (check == null) {
                bean.setProcessID(this.activity.getProcessID());
                bean.setUpdateDate(ts);
                bean.setID(UniqueKeyGenerator.generate("VRI"));
                variableDAO.insert(bean, aid);
            } else {
                variableDAO.update(check, bean.getValue(), aid, ts);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0080 = StringManager.get("E0080");
            throw new WorkflowException(E0080, ex);
        }
    }

    public void changeState(WfState state) throws InvalidStateException, TransitionNotAllowedException, WorkflowException {
        if (!(state instanceof ActivityState)) {
            String E0081 = StringManager.get("E0081");
            throw new InvalidStateException(E0081);
        }
        if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
            String E0082 = StringManager.get("E0082") + "(" + ((Object)state).toString() + ")";
            throw new TransitionNotAllowedException(E0082);
        }
        if (ActivityState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
            this.suspend();
        } else if (ActivityState.OPEN_RUNNING.equals(state)) {
            if (ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(this.getState())) {
                this.start();
            } else {
                this.resume();
            }
        } else if (ActivityState.CLOSED_COMPLETED.equals(state)) {
            this.complete();
        } else if (ActivityState.CLOSED_TERMINATED.equals(state)) {
            this.terminate();
        } else if (ActivityState.CLOSED_ABORTED.equals(state)) {
            this.abort();
        }
    }

    public void start() throws CannotStartException, AlreadyRunningException, WorkflowException {
        try {
            ActivityState state = (ActivityState)this.getState();
            boolean closedAlready = false;
            if (ActivityState.CLOSED_COMPLETED.equals(state) || ActivityState.CLOSED_TERMINATED.equals(state) || ActivityState.CLOSED_ABORTED.equals(state)) {
                closedAlready = true;
            } else if (!ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state)) {
                // empty if block
            }
            String pid = this.activity.getProcessID();
            String aid = this.activity.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
            ProcessBean pbean = proc.getBean();
            String pdid = pbean.getProcDefinitionID();
            String adid = this.activity.getActivityDefinitionID();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
            ProcessDefinition pd = rep.getProcessDefinition(pdid);
            ActivityDefinition ad = this.findActivity(pd, adid);
            String type = ad.getType();
            if (closedAlready) {
                if (!type.equals("CONCUR_END")) {
                    String E0085 = StringManager.get("E0085");
                    throw new NotRunningException(E0085);
                }
                return;
            }
            if (!ActivityState.OPEN_NOT_RUNNING_NOT_STARTED.equals(state) && !type.equals("CONCUR_END")) {
                String E0083 = StringManager.get("E0083");
                throw new AlreadyRunningException(E0083);
            }
            ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
            ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
            BehaviorExecutor.start(behavior, pd, ad, proc, this);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0087 = StringManager.get("E0087");
            throw new WorkflowException(E0087, ex);
        }
    }

    public void resume() throws CannotResumeException, NotRunningException, NotSuspendedException, WorkflowException {
        try {
            ActivityState state = (ActivityState)this.getState();
            if (ActivityState.CLOSED_COMPLETED.equals(state) || ActivityState.CLOSED_TERMINATED.equals(state) || ActivityState.CLOSED_ABORTED.equals(state)) {
                String E0085 = StringManager.get("E0085");
                throw new NotRunningException(E0085);
            }
            if (!ActivityState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
                String E0086 = StringManager.get("E0086");
                throw new NotSuspendedException(E0086);
            }
            String pid = this.activity.getProcessID();
            String aid = this.activity.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
            ProcessBean pbean = proc.getBean();
            String pdid = pbean.getProcDefinitionID();
            String adid = this.activity.getActivityDefinitionID();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
            ProcessDefinition pd = rep.getProcessDefinition(pdid);
            ActivityDefinition ad = this.findActivity(pd, adid);
            String type = ad.getType();
            ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
            ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
            BehaviorExecutor.resume(behavior, pd, ad, proc, this);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0088 = StringManager.get("E0088");
            throw new WorkflowException(E0088, ex);
        }
    }

    public void suspend() throws CannotSuspendException, NotRunningException, AlreadySuspendedException, WorkflowException {
        try {
            ActivityState state = (ActivityState)this.getState();
            if (ActivityState.CLOSED_COMPLETED.equals(state) || ActivityState.CLOSED_TERMINATED.equals(state) || ActivityState.CLOSED_ABORTED.equals(state)) {
                String E0085 = StringManager.get("E0085");
                throw new NotRunningException(E0085);
            }
            if (ActivityState.OPEN_NOT_RUNNING_SUSPENDED.equals(state)) {
                String E0084 = StringManager.get("E0084");
                throw new AlreadySuspendedException(E0084);
            }
            String pid = this.activity.getProcessID();
            String aid = this.activity.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
            ProcessBean pbean = proc.getBean();
            String pdid = pbean.getProcDefinitionID();
            String adid = this.activity.getActivityDefinitionID();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
            ProcessDefinition pd = rep.getProcessDefinition(pdid);
            ActivityDefinition ad = this.findActivity(pd, adid);
            String type = ad.getType();
            ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
            ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
            BehaviorExecutor.suspend(behavior, pd, ad, proc, this);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0089 = StringManager.get("E0089");
            throw new WorkflowException(E0089, ex);
        }
    }

    public void complete() throws CannotStopException, NotRunningException, WorkflowException {
        try {
            boolean closedAlready = false;
            ActivityState state = (ActivityState)this.getState();
            if (ActivityState.CLOSED_COMPLETED.equals(state) || ActivityState.CLOSED_TERMINATED.equals(state) || ActivityState.CLOSED_ABORTED.equals(state)) {
                closedAlready = true;
            }
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ActivityDAO actDAO = daoFactory.getActivityDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            if (closedAlready) {
                actDAO.updateDate(this.getBean(), ts);
            } else {
                String pid = this.activity.getProcessID();
                ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                ProcessManager pm = pmf.getOwnerProcessManager(pid);
                ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
                ProcessBean pbean = proc.getBean();
                String pdid = pbean.getProcDefinitionID();
                String adid = this.activity.getActivityDefinitionID();
                WorkflowEngine engine = WorkflowEngine.getInstance();
                DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
                ProcessDefinition pd = rep.getProcessDefinition(pdid);
                ActivityDefinition ad = this.findActivity(pd, adid);
                String type = ad.getType();
                ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
                ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
                BehaviorExecutor.complete(behavior, pd, ad, proc, this);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0090 = StringManager.get("E0090");
            throw new WorkflowException(E0090, ex);
        }
    }

    public void terminate() throws CannotStopException, NotRunningException, WorkflowException {
        this.terminate(true);
    }

    public void abort() throws CannotStopException, NotRunningException, WorkflowException {
        this.abort(true);
    }

    public void receiveEvent(WfEvent event) throws InvalidPerformerException, WorkflowException {
        String E0900 = StringManager.get("E0900");
        throw new UnsupportedOperationException(E0900);
    }

    WfNameValue[] getContext(Filter filter) throws WorkflowException {
        try {
            String sqlPart = new VariableFilterConverter().convertToSQL(filter);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            VariableDAO variableDAO = daoFactory.getVariableDAO();
            WfNameValue[] beans = variableDAO.findBySQLPart(this.activity.getProcessID(), sqlPart);
            return beans;
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0032 = StringManager.get("E0032");
            throw new WorkflowException(E0032, ex);
        }
    }

    ActivityBean getBean() {
        return (ActivityBean)this.activity;
    }

    void terminate(boolean checkChild) throws CannotStopException, NotRunningException, WorkflowException {
        try {
            boolean closedAlready = false;
            ActivityState state = (ActivityState)this.getState();
            if (ActivityState.CLOSED_COMPLETED.equals(state) || ActivityState.CLOSED_TERMINATED.equals(state) || ActivityState.CLOSED_ABORTED.equals(state)) {
                closedAlready = true;
            }
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ActivityDAO actDAO = daoFactory.getActivityDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            if (closedAlready) {
                actDAO.updateDate(this.getBean(), ts);
            } else {
                String pid = this.activity.getProcessID();
                ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                ProcessManager pm = pmf.getOwnerProcessManager(pid);
                ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
                ProcessBean pbean = proc.getBean();
                String pdid = pbean.getProcDefinitionID();
                String adid = this.activity.getActivityDefinitionID();
                WorkflowEngine engine = WorkflowEngine.getInstance();
                DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
                ProcessDefinition pd = rep.getProcessDefinition(pdid);
                ActivityDefinition ad = this.findActivity(pd, adid);
                String type = ad.getType();
                ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
                ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
                BehaviorExecutor.terminate(behavior, pd, ad, proc, this, checkChild);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0091 = StringManager.get("E0091");
            throw new WorkflowException(E0091, ex);
        }
    }

    void abort(boolean checkChild) throws CannotStopException, NotRunningException, WorkflowException {
        try {
            boolean closedAlready = false;
            ActivityState state = (ActivityState)this.getState();
            if (ActivityState.CLOSED_COMPLETED.equals(state) || ActivityState.CLOSED_TERMINATED.equals(state) || ActivityState.CLOSED_ABORTED.equals(state)) {
                closedAlready = true;
            }
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            ActivityDAO actDAO = daoFactory.getActivityDAO();
            Timestamp ts = DataAccessManager.getAccessTime();
            String pid = this.activity.getProcessID();
            if (closedAlready) {
                actDAO.updateDate(this.getBean(), ts);
            } else {
                ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                ProcessManager pm = pmf.getOwnerProcessManager(pid);
                ProcessInternal proc = (ProcessInternal)pm.getProcess(pid);
                ProcessBean pbean = proc.getBean();
                String pdid = pbean.getProcDefinitionID();
                String adid = this.activity.getActivityDefinitionID();
                WorkflowEngine engine = WorkflowEngine.getInstance();
                DefinitionRepositoryImpl rep = engine.getDefinitionRepository();
                ProcessDefinition pd = rep.getProcessDefinition(pdid);
                ActivityDefinition ad = this.findActivity(pd, adid);
                String type = ad.getType();
                ActivityBehaviorFactory abf = ActivityBehaviorFactory.getInstance();
                ActivityBehavior behavior = abf.getActivityBehavior(ad.getType());
                BehaviorExecutor.abort(behavior, pd, ad, proc, this, checkChild);
            }
            EndProcessRequestMessage eprmsg = new EndProcessRequestMessage(pid, ActivityState.CLOSED_ABORTED);
            SystemMessageTransporter mt = new SystemMessageTransporter("END_PROCESS_REQUEST");
            mt.sendMessage(eprmsg);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0092 = StringManager.get("E0092");
            throw new WorkflowException(E0092, ex);
        }
    }

    private ActivityDefinition findActivity(ProcessDefinition pd, String adid) throws Exception {
        List acts = pd.getActivities();
        Iterator it = acts.iterator();
        ActivityDefinition ad = null;
        while (it.hasNext()) {
            ActivityDefinition def = (ActivityDefinition)it.next();
            if (!def.getID().equals(adid)) continue;
            ad = def;
            break;
        }
        if (ad == null) {
            String E0093 = StringManager.get("E0093") + "(" + adid + ")";
            throw new WorkflowException(E0093);
        }
        return ad;
    }
}

