/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.SourceActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.AuditDataRecord;
import jp.co.argo21.nautica.workflow.engine.AuditPrefix;
import jp.co.argo21.nautica.workflow.engine.AuditSuffix;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.InterWorkflowConfig;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.RequesterManager;
import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.omg.WfActivity;
import jp.co.argo21.nautica.workflow.omg.WfProcess;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.util.StateHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InterWorkflowConnector;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import org.apache.log4j.Logger;

public class InterWorkflowConnectorImpl
implements InterWorkflowConnector {
    private static Logger eLog = LogManager.getEngineLogger();
    private static Logger audit = LogManager.getAuditLogger();
    private static InterWorkflowConnectorImpl connector;
    private static InterWorkflowConfig config;
    static /* synthetic */ Class class$jp$co$argo21$nautica$workflow$rmi$InterWorkflowConnectorRemote;

    static void create() throws Exception {
        config = new InterWorkflowConfig();
        connector = new InterWorkflowConnectorImpl();
        connector.init();
    }

    static InterWorkflowConnector getInstance() {
        return connector;
    }

    static InterWorkflowConnectorRemote getRemoteInstance(String engineName) throws WorkflowException, RemoteException, NamingException {
        if (engineName == null || engineName.trim().equals("")) {
            String E0212 = StringManager.get("E0212");
            throw new WorkflowException(E0212);
        }
        InterWorkflowConfig.EngineInfo info = config.getEngineInfo(engineName);
        if (info == null) {
            String E0220 = StringManager.get("E0220");
            throw new WorkflowException(E0220);
        }
        String url = info.getURL();
        Context context = InterWorkflowConnectorImpl.getInitialContext(url);
        Object ref = context.lookup(engineName + "/InterWorkflowConnector");
        InterWorkflowConnectorRemote iwc = (InterWorkflowConnectorRemote)PortableRemoteObject.narrow((Object)ref, (Class)(class$jp$co$argo21$nautica$workflow$rmi$InterWorkflowConnectorRemote == null ? (class$jp$co$argo21$nautica$workflow$rmi$InterWorkflowConnectorRemote = InterWorkflowConnectorImpl.class$("jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote")) : class$jp$co$argo21$nautica$workflow$rmi$InterWorkflowConnectorRemote));
        return iwc;
    }

    static String connectToRemoteEngine(InterWorkflowConnectorRemote remote) throws WorkflowException, RemoteException {
        String id = config.getLocalEngineID();
        String pass = config.getPassword();
        String remoteEID = remote.connect(id, pass);
        AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMStartedConversation"), new AuditSuffix(1, "4MIME"));
        data.setDataElement("SourceConverstaionID", id);
        data.setDataElement("TargetConversationID", remoteEID);
        audit.info((Object)data);
        return remoteEID;
    }

    static String getLocalEnginePassword() {
        return config.getPassword();
    }

    private InterWorkflowConnectorImpl() {
    }

    private void init() throws Exception {
    }

    private static Context getInitialContext(String url) throws NamingException {
        Properties prop = new Properties();
        prop.setProperty("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
        prop.setProperty("java.naming.provider.url", url);
        InitialContext context = new InitialContext(prop);
        return context;
    }

    public String connect(String seid, String password) throws WorkflowException {
        String argInfo = "(WfMC API = connect,source engine id = [" + seid + "]," + "password = [**SECURITY**])";
        try {
            InterWorkflowConfig.EngineInfo info = config.getEngineInfo(seid);
            if (info == null) {
                String E0221 = StringManager.get("E0221");
                throw new WorkflowException(E0221);
            }
            String pass = info.getPassword();
            if (pass == null) {
                if (password != null) {
                    String E0222 = StringManager.get("E0222");
                    throw new WorkflowException(E0222);
                }
            } else {
                if (password == null) {
                    String E0222 = StringManager.get("E0222");
                    throw new WorkflowException(E0222);
                }
                if (!password.equals(pass)) {
                    String E0222 = StringManager.get("E0222");
                    throw new WorkflowException(E0222);
                }
            }
            WorkflowEngine engine = WorkflowEngine.getInstance();
            String eid = engine.connect(seid, password);
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMStartedConversation"), new AuditSuffix(1, "4MIME"));
            data.setDataElement("SourceConverstaionID", seid);
            data.setDataElement("TargetConversationID", eid);
            audit.info((Object)data);
            return eid;
        }
        catch (WorkflowException ex) {
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            String E0207 = StringManager.get("E0207") + argInfo;
            eLog.error((Object)E0207, (Throwable)ex);
            throw new WorkflowException(E0207, ex);
        }
    }

    public void disconnect(String eid) throws WorkflowException {
        String argInfo = "(WfMC API = disconnect,engine connection id = [" + eid + "])";
        try {
            WorkflowEngine engine = WorkflowEngine.getInstance();
            engine.disconnect(eid);
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMStoppedConversation"), new AuditSuffix(1, "4MIME"));
            data.setDataElement("TargetConversationID", eid);
            audit.info((Object)data);
        }
        catch (WorkflowException ex) {
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            String E0208 = StringManager.get("E0208") + argInfo;
            eLog.error((Object)E0208, (Throwable)ex);
            throw new WorkflowException(E0208, ex);
        }
    }

    public void changeProcessState(String eid, String pid, ProcessState state) throws WorkflowException {
        String argInfo = "(WfMC API = changeProcessState,engine connection id = [" + eid + "]," + "pid = [" + pid + "]," + "state = [" + state.toString() + "])";
        AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMReceivedRequestChangeProcessInstanceState"), new AuditSuffix(1, "4MIME"));
        data.setDataElement("SourceRequestedState", state);
        data.setDataElement("TargetConversationID", eid);
        audit.info((Object)data);
        try {
            try {
                if (state == null) {
                    String E0218 = StringManager.get("E0218");
                    throw new WorkflowException(E0218);
                }
                DataAccessManager.begin(false);
                String remoteEngineID = this.validateEngineID(eid);
                SourceActivityBean sabean = this.checkRemoteInfo(pid);
                ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                ProcessManager pm = pmf.getOwnerProcessManager(pid);
                WfProcess process = pm.getProcess(pid);
                process.changeState(state);
                DataAccessManager.commit();
                data = new AuditDataRecord(new AuditPrefix("WMChangeProcessInstanceState"), new AuditSuffix(1, "4MIME"));
                data.setDataElement("NewProcessState", state);
                data.setDataElement("TargetConversationID", remoteEngineID);
                audit.info((Object)data);
            }
            catch (WorkflowException ex) {
                this.rollbackAndLogging(ex, argInfo);
                throw ex;
            }
            catch (Exception ex) {
                try {
                    DataAccessManager.rollback();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                String E0156 = StringManager.get("E0156") + argInfo;
                eLog.error((Object)E0156, (Throwable)ex);
                throw new WorkflowException(E0156, ex);
            }
            Object var12_16 = null;
            data = new AuditDataRecord(new AuditPrefix("WMSentChangeProcessInstanceState"), new AuditSuffix(1, "4MIME"));
            data.setDataElement("TargetProcessInstanceID", pid);
            data.setDataElement("TargetNodeID", System.getProperty("nautica.workflow.scope"));
            data.setDataElement("TargetState", state);
            data.setDataElement("TargetConversationID", eid);
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            data = new AuditDataRecord(new AuditPrefix("WMSentChangeProcessInstanceState"), new AuditSuffix(1, "4MIME"));
            data.setDataElement("TargetProcessInstanceID", pid);
            data.setDataElement("TargetNodeID", System.getProperty("nautica.workflow.scope"));
            data.setDataElement("TargetState", state);
            data.setDataElement("TargetConversationID", eid);
            audit.info((Object)data);
            throw throwable;
        }
        audit.info((Object)data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createProcess(String eid, String pdid, int flag, String rootpid, String aid, String userid, String roleid) throws WorkflowException {
        String string;
        String argInfo = "(WfMC API = createProcess,engine connection id = [" + eid + "]," + "pdid = [" + pdid + "]," + "flag = [" + flag + "]," + "rootpid = [" + rootpid + "]," + "aid = [" + aid + "]," + "userid = [" + userid + "]," + "roleid = [" + roleid + "])";
        AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMReceivedRequestCreateProcessInstance"), new AuditSuffix(1, "4MIME"));
        data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
        data.setDataElement("SourceActivityInstanceID", aid);
        data.setDataElement("SourceUserID", userid);
        data.setDataElement("SourceRoleID", roleid);
        data.setDataElement("SourceProcessDefinitionID", pdid);
        data.setDataElement("TargetConversationID", eid);
        audit.info((Object)data);
        try {
            try {
                if (pdid == null || pdid.trim().equals("")) {
                    String E0219 = StringManager.get("E0219");
                    throw new WorkflowException(E0219);
                }
                if (flag != 1 && flag != 0) {
                    String E0224 = StringManager.get("E0224");
                    throw new WorkflowException(E0224);
                }
                this.checkRootProcessID(rootpid);
                this.checkActivityID(aid);
                if (userid == null || userid.trim().equals("")) {
                    String E0166 = StringManager.get("E0166");
                    throw new WorkflowException(E0166);
                }
                if (roleid == null || roleid.trim().equals("")) {
                    String E0213 = StringManager.get("E0213");
                    throw new WorkflowException(E0213);
                }
                DataAccessManager.begin(false);
                String remoteEngineID = this.validateEngineID(eid);
                RequesterManager rqm = RequesterManager.getInstance();
                WfRequester requester = rqm.getRequesterBySession(eid);
                ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                ProcessManager pm = pmf.getProcessManager(pdid);
                String name = "InterWorkflow process by " + remoteEngineID;
                WfProcess process = pm.createProcess(requester, name);
                String pid = process.getID();
                if (flag == 1) {
                    WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
                    SourceActivityDAO saDAO = daoFactory.getSourceActivityDAO();
                    SourceActivityBean sabean = new SourceActivityBean();
                    sabean.setEngineID(remoteEngineID);
                    sabean.setRootProcID(rootpid);
                    sabean.setRootActID(aid);
                    sabean.setProcessID(pid);
                    saDAO.insert(sabean);
                }
                DataAccessManager.commit();
                data = new AuditDataRecord(new AuditPrefix("WMCreatedProcessInstance"), new AuditSuffix(1, "4MIME"));
                data.setDataElement("ProcessDefinitionID", pdid);
                data.setDataElement("TargetConversationID", eid);
                audit.info((Object)data);
                string = pid;
                Object var22_29 = null;
                data = new AuditDataRecord(new AuditPrefix("WMSentCreatedProcessInstance"), new AuditSuffix(1, "4MIME"));
                data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
                data.setDataElement("SourceActivityInstanceID", aid);
                data.setDataElement("SourceUserID", userid);
                data.setDataElement("SourceRoleID", roleid);
                data.setDataElement("SourceProcessDefinitionID", pdid);
                data.setDataElement("TargetConversationID", eid);
            }
            catch (WorkflowException ex) {
                this.rollbackAndLogging(ex, argInfo);
                throw ex;
            }
            catch (Exception ex) {
                try {
                    DataAccessManager.rollback();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                String E0153 = StringManager.get("E0153") + argInfo;
                eLog.error((Object)E0153, (Throwable)ex);
                throw new WorkflowException(E0153, ex);
            }
        }
        catch (Throwable throwable) {
            Object var22_30 = null;
            data = new AuditDataRecord(new AuditPrefix("WMSentCreatedProcessInstance"), new AuditSuffix(1, "4MIME"));
            data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
            data.setDataElement("SourceActivityInstanceID", aid);
            data.setDataElement("SourceUserID", userid);
            data.setDataElement("SourceRoleID", roleid);
            data.setDataElement("SourceProcessDefinitionID", pdid);
            data.setDataElement("TargetConversationID", eid);
            audit.info((Object)data);
            throw throwable;
        }
        audit.info((Object)data);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Attribute[] getProcessAttributes(String eid, String pid, String rootpid, String aid) throws WorkflowException {
        Attribute[] attributeArray;
        String argInfo = "(WfMC API = getProcessAttributes,engine connection id = [" + eid + "]," + "pid = [" + pid + "]," + "rootpid = [" + rootpid + "]," + "aid = [" + aid + "])";
        AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMReceivedRequestGetProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
        data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
        data.setDataElement("SourceActivityInstanceID", aid);
        data.setDataElement("TargetConversationID", eid);
        audit.info((Object)data);
        try {
            try {
                DataAccessManager.begin(false);
                String remoteEngineID = this.validateEngineID(eid);
                SourceActivityBean sabean = this.checkRemoteInfo(rootpid, aid, pid);
                ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                ProcessManager pm = pmf.getOwnerProcessManager(pid);
                ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
                Attribute[] attrs = (Attribute[])process.getContext();
                DataAccessManager.commit();
                attributeArray = attrs;
                Object var15_18 = null;
                data = new AuditDataRecord(new AuditPrefix("WMSentGetProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
                data.setDataElement("TargetProcessInstanceID", pid);
                data.setDataElement("TargetNodeID", System.getProperty("nautica.workflow.scope"));
                data.setDataElement("TargetConversationID", eid);
            }
            catch (WorkflowException ex) {
                this.rollbackAndLogging(ex, argInfo);
                throw ex;
            }
            catch (Exception ex) {
                try {
                    DataAccessManager.rollback();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                String E0032 = StringManager.get("E0032") + argInfo;
                eLog.error((Object)E0032, (Throwable)ex);
                throw new WorkflowException(E0032, ex);
            }
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            data = new AuditDataRecord(new AuditPrefix("WMSentGetProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
            data.setDataElement("TargetProcessInstanceID", pid);
            data.setDataElement("TargetNodeID", System.getProperty("nautica.workflow.scope"));
            data.setDataElement("TargetConversationID", eid);
            audit.info((Object)data);
            throw throwable;
        }
        audit.info((Object)data);
        return attributeArray;
    }

    public ProcessState getProcessState(String eid, String pid) throws WorkflowException {
        String argInfo = "(WfMC API = getProcessState,engine connection id = [" + eid + "]," + "pid = [" + pid + "])";
        try {
            DataAccessManager.begin(false);
            String remoteEngineID = this.validateEngineID(eid);
            SourceActivityBean sabean = this.checkRemoteInfo(pid);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal internal = (ProcessInternal)pm.getProcess(pid);
            ProcessBean proc = internal.getBean();
            ProcessState state = ProcessState.getState(proc.getProcessState());
            DataAccessManager.commit();
            return state;
        }
        catch (WorkflowException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0154 = StringManager.get("E0154") + argInfo;
            eLog.error((Object)E0154, (Throwable)ex);
            throw new WorkflowException(E0154, ex);
        }
    }

    public void processAttributesChanged(String eid, String pid, Attribute[] attrs) throws WorkflowException {
        String argInfo = "(WfMC API = processAttributesChanged,engine connection id = [" + eid + "]," + "pid = [" + pid + "]," + "attribute = [" + attrs + "])";
        AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMReceivedChangedProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
        data.setDataElement(attrs);
        data.setDataElement("TargetConversationID", eid);
        audit.info((Object)data);
        try {
            if (attrs == null) {
                String E0131 = StringManager.get("E0131");
                throw new InvalidProcessInstanceException(E0131);
            }
            DataAccessManager.begin(false);
            String remoteEngineID = this.validateEngineID(eid);
            TargetProcessBean tpbean = this.checkTargetInfo(remoteEngineID, pid);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            WfProcess process = pm.getProcess(pid);
            for (int i = 0; i < attrs.length; ++i) {
                process.setContext(attrs[i]);
            }
            DataAccessManager.commit();
        }
        catch (WorkflowException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0031 = StringManager.get("E0031") + argInfo;
            eLog.error((Object)E0031, (Throwable)ex);
            throw new WorkflowException(E0031, ex);
        }
    }

    public void processStateChanged(String eid, String pid, ProcessState state) throws WorkflowException {
        String argInfo = "(WfMC API = processStateChanged,engine connection id = [" + eid + "]," + "pid = [" + pid + "]," + "state = [" + state + "])";
        AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMReceivedChangedProcessInstanceState"), new AuditSuffix(1, "4MIME"));
        data.setDataElement("NewProcessState", state);
        data.setDataElement("TargetConversationID", eid);
        audit.info((Object)data);
        try {
            if (state == null) {
                String E0214 = StringManager.get("E0214");
                throw new InvalidProcessInstanceException(E0214);
            }
            DataAccessManager.begin(false);
            String remoteEngineID = this.validateEngineID(eid);
            TargetProcessBean tpbean = this.checkTargetInfo(remoteEngineID, pid);
            String rootpid = tpbean.getRootProcID();
            String rootaid = tpbean.getRootActID();
            if (ProcessState.CLOSED_COMPLETED.equals(state) || ProcessState.CLOSED_TERMINATED.equals(state) || ProcessState.CLOSED_ABORTED.equals(state)) {
                ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                ProcessManager pm = pmf.getOwnerProcessManager(rootpid);
                WfProcess process = pm.getProcess(rootpid);
                WfActivity activity = process.getStep(rootaid);
                ActivityState astate = StateHelper.convert(state);
                activity.changeState(astate);
                this.relinquishProcessLocal(remoteEngineID, pid);
            }
            DataAccessManager.commit();
        }
        catch (WorkflowException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0156 = StringManager.get("E0156") + argInfo;
            eLog.error((Object)E0156, (Throwable)ex);
            throw new WorkflowException(E0156, ex);
        }
    }

    public void setProcessAttributes(String eid, String rootpid, String aid, String pid, Attribute[] attrs) throws WorkflowException {
        String argInfo = "(WfMC API = setProcessAttributes,engine connection id = [" + eid + "]," + "rootpid = [" + rootpid + "]," + "aid = [" + aid + "]," + "pid = [" + pid + "]," + "attrs = [" + attrs + "])";
        AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMReceivedRequestChangeProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
        data.setDataElement("SourceCurrentProcessInstanceID", rootpid);
        data.setDataElement("SourceActivityInstanceID", aid);
        data.setDataElement(attrs);
        data.setDataElement("TargetConversationID", eid);
        audit.info((Object)data);
        try {
            try {
                if (attrs == null) {
                    String E0131 = StringManager.get("E0131");
                    throw new InvalidProcessInstanceException(E0131);
                }
                DataAccessManager.begin(false);
                String remoteEngineID = this.validateEngineID(eid);
                SourceActivityBean sabean = this.checkRemoteInfo(rootpid, aid, pid);
                ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
                ProcessManager pm = pmf.getOwnerProcessManager(pid);
                ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
                process.setContext(attrs);
                DataAccessManager.commit();
                data = new AuditDataRecord(new AuditPrefix("WMAssignedProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
                data.setDataElement(attrs);
                data.setDataElement("TargetConversationID", eid);
                audit.info((Object)data);
            }
            catch (WorkflowException ex) {
                this.rollbackAndLogging(ex, argInfo);
                throw ex;
            }
            catch (Exception ex) {
                try {
                    DataAccessManager.rollback();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                String E0080 = StringManager.get("E0080") + argInfo;
                eLog.error((Object)E0080, (Throwable)ex);
                throw new WorkflowException(E0080, ex);
            }
            Object var14_18 = null;
            data = new AuditDataRecord(new AuditPrefix("WMSentChangeProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
            data.setDataElement("TargetProcessInstanceID", pid);
            data.setDataElement("TargetNodeID", System.getProperty("nautica.workflow.scope"));
            data.setDataElement(attrs);
            data.setDataElement("TargetConversationID", eid);
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            data = new AuditDataRecord(new AuditPrefix("WMSentChangeProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
            data.setDataElement("TargetProcessInstanceID", pid);
            data.setDataElement("TargetNodeID", System.getProperty("nautica.workflow.scope"));
            data.setDataElement(attrs);
            data.setDataElement("TargetConversationID", eid);
            audit.info((Object)data);
            throw throwable;
        }
        audit.info((Object)data);
    }

    public void triggerActivity(String eid, String rootpid, String aid, String pid) throws WorkflowException {
        String argInfo = "(WfMC API = triggerActivity,engine connection id = [" + eid + "]," + "rootpid = [" + rootpid + "]," + "aid = [" + aid + "]," + "pid = [" + pid + "])";
        try {
            DataAccessManager.begin(false);
            String remoteEngineID = this.validateEngineID(eid);
            SourceActivityBean sabean = this.checkRemoteInfo(rootpid, aid, pid);
            DataAccessManager.commit();
        }
        catch (WorkflowException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0123 = StringManager.get("E0123") + argInfo;
            eLog.error((Object)E0123, (Throwable)ex);
            throw new WorkflowException(E0123, ex);
        }
    }

    public String[] listProcesses(String eid, Filter filter) throws WorkflowException {
        String argInfo = "(WfMC API = listProcesses,engine connection id = [" + eid + "]," + "filter = [" + filter + "])";
        try {
            DataAccessManager.begin(false);
            String remoteEngineID = this.validateEngineID(eid);
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            Process[] procs = pmf.getProcesses(filter);
            DataAccessManager.commit();
            return null;
        }
        catch (WorkflowException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0199 = StringManager.get("E0199") + argInfo;
            eLog.error((Object)E0199, (Throwable)ex);
            throw new WorkflowException(E0199, ex);
        }
    }

    public void relinquishProcess(String eid, String pid) throws WorkflowException {
        String argInfo = "(WfMC API = relinquishProcess,engine connection id = [" + eid + "]," + "pid = [" + pid + "])";
        try {
            DataAccessManager.begin(false);
            String remoteEngineID = this.validateEngineID(eid);
            SourceActivityBean sabean = this.checkRemoteInfo(pid);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            SourceActivityDAO saDAO = daoFactory.getSourceActivityDAO();
            saDAO.delete(pid);
            DataAccessManager.commit();
        }
        catch (WorkflowException ex) {
            this.rollbackAndLogging(ex, argInfo);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0209 = StringManager.get("E0209") + argInfo;
            eLog.error((Object)E0209, (Throwable)ex);
            throw new WorkflowException(E0209, ex);
        }
    }

    void processAttributesChangedLocal(String pid, Attribute[] attrs) throws WorkflowException {
        try {
            TargetProcessBean tpbean = this.checkTargetInfo(pid);
            if (tpbean != null) {
                String engineName = tpbean.getEngineID();
                InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(engineName);
                String eid = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
                AuditDataRecord data = new AuditDataRecord(new AuditPrefix(pid, "WMSentChangedProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
                data.setDataElement("TargetProcessInstanceID", pid);
                data.setDataElement("TargetNodeID", System.getProperty("nautica.workflow.scope"));
                data.setDataElement(attrs);
                data.setDataElement("TargetConversationID", eid);
                audit.info((Object)data);
                iwc.processAttributesChanged(eid, pid, attrs);
                iwc.disconnect(eid);
                data = new AuditDataRecord(new AuditPrefix(pid, "WMAssignedProcessInstanceAttribute"), new AuditSuffix(1, "4MIME"));
                data.setDataElement(attrs);
                data.setDataElement("TargetConversationID", "eid");
                audit.info((Object)data);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0210 = StringManager.get("E0210");
            throw new WorkflowException(E0210, ex);
        }
    }

    void processStateChangedLocal(String pid, ProcessState state) throws WorkflowException {
        try {
            SourceActivityBean sabean = this.checkSourceInfo(pid);
            if (sabean != null) {
                String engineName = sabean.getEngineID();
                InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(engineName);
                String eid = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
                AuditDataRecord data = new AuditDataRecord(new AuditPrefix("WMSentChangedProcessInstanceState"), new AuditSuffix(1, "4MIME"));
                data.setDataElement("TargetProcessInstanceID", pid);
                data.setDataElement("NewProcessState", state);
                data.setDataElement("TargetConversationID", eid);
                audit.info((Object)data);
                iwc.processStateChanged(eid, pid, state);
                iwc.disconnect(eid);
                data = new AuditDataRecord(new AuditPrefix("WMChangedProcessInstanceState"), new AuditSuffix(1, "4MIME"));
                data.setDataElement("NewProcessState", state);
                data.setDataElement("TargetConversationID", eid);
                audit.info((Object)data);
            }
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0211 = StringManager.get("E0211");
            throw new WorkflowException(E0211, ex);
        }
    }

    void relinquishProcessLocal(String engineName, String pid) throws WorkflowException {
        try {
            InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(engineName);
            String eid = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
            iwc.relinquishProcess(eid, pid);
            iwc.disconnect(eid);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
            tpDAO.delete(engineName, pid);
        }
        catch (WorkflowException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0209 = StringManager.get("E0209");
            throw new WorkflowException(E0209, ex);
        }
    }

    private void rollbackAndLogging(Exception ex, String argInfo) {
        try {
            DataAccessManager.rollback();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        String msg = ex.getMessage() + argInfo;
        eLog.error((Object)msg, (Throwable)ex);
    }

    private void checkRootProcessID(String rootpid) throws InvalidProcessInstanceException {
        if (rootpid == null || rootpid.trim().equals("")) {
            String E0215 = StringManager.get("E0215");
            throw new InvalidProcessInstanceException(E0215);
        }
    }

    private void checkActivityID(String aid) throws InvalidActivityInstanceException {
        if (aid == null || aid.trim().equals("")) {
            String E0216 = StringManager.get("E0216");
            throw new InvalidActivityInstanceException(E0216);
        }
    }

    private String validateEngineID(String eid) throws InvalidSessionException, WorkflowException {
        if (eid == null || eid.trim().equals("")) {
            String E0217 = StringManager.get("E0217");
            throw new InvalidSessionException(E0217);
        }
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
        SessionManager manager = factory.getSessionManager();
        manager.validateSession(eid);
        String uid = null;
        try {
            User user = manager.getSessionUser(eid);
            uid = user.getID();
        }
        catch (Exception ex) {
            String E0225 = StringManager.get("E0225");
            throw new WorkflowException(E0225, ex);
        }
        InterWorkflowConfig.EngineInfo info = config.getEngineInfo(uid);
        if (info == null) {
            String E0221 = StringManager.get("E0221");
            throw new WorkflowException(E0221);
        }
        String remoteEngineID = info.getID();
        return remoteEngineID;
    }

    private SourceActivityBean checkSourceInfo(String pid) throws Exception {
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        SourceActivityDAO saDAO = daoFactory.getSourceActivityDAO();
        SourceActivityBean sabean = saDAO.findByPrimaryKey(pid);
        return sabean;
    }

    private TargetProcessBean checkTargetInfo(String eid, String pid) throws WorkflowException, Exception {
        if (eid == null || eid.trim().equals("")) {
            String E0162 = StringManager.get("E0162");
            throw new WorkflowException(E0162);
        }
        if (pid == null || pid.trim().equals("")) {
            String E0189 = StringManager.get("E0189");
            throw new WorkflowException(E0189);
        }
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
        TargetProcessBean tpbean = tpDAO.findByPrimaryKey(eid, pid);
        if (tpbean == null) {
            String E0226 = StringManager.get("E0226");
            throw new WorkflowException(E0226);
        }
        String teid = tpbean.getEngineID();
        if (teid == null || !teid.equals(eid)) {
            String E0223 = StringManager.get("E0223");
            throw new WorkflowException(E0223);
        }
        return tpbean;
    }

    private TargetProcessBean checkTargetInfo(String pid) throws WorkflowException, Exception {
        if (pid == null || pid.trim().equals("")) {
            String E0189 = StringManager.get("E0189");
            throw new WorkflowException(E0189);
        }
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
        TargetProcessBean tpbean = tpDAO.findByProcessID(pid);
        return tpbean;
    }

    private SourceActivityBean checkRemoteInfo(String pid) throws WorkflowException, Exception {
        if (pid == null || pid.trim().equals("")) {
            String E0189 = StringManager.get("E0189");
            throw new WorkflowException(E0189);
        }
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        SourceActivityDAO saDAO = daoFactory.getSourceActivityDAO();
        SourceActivityBean sabean = saDAO.findByPrimaryKey(pid);
        if (sabean == null) {
            String E0226 = StringManager.get("E0226");
            throw new WorkflowException(E0226);
        }
        return sabean;
    }

    private SourceActivityBean checkRemoteInfo(String rootpid, String rootaid, String pid) throws WorkflowException, Exception {
        SourceActivityBean sabean = this.checkRemoteInfo(pid);
        String rpid = sabean.getRootProcID();
        String raid = sabean.getRootActID();
        if (rootpid == null || !rpid.equals(rootpid)) {
            String E0215 = StringManager.get("E0215");
            throw new WorkflowException(E0215);
        }
        if (rootaid == null || !raid.equals(rootaid)) {
            String E0216 = StringManager.get("E0216");
            throw new WorkflowException(E0216);
        }
        return sabean;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

