/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class SessionManagerFactory {
    private static Logger eLog = LogManager.getEngineLogger();
    private static Logger sLog = LogManager.getSercurityLogger();
    private static SessionManagerFactory singleton;
    private SessionManager sessionManager;

    static void create() throws Exception {
        singleton = new SessionManagerFactory();
        try {
            singleton.init();
        }
        catch (Exception ex) {
            eLog.error((Object)StringManager.get("E1006"));
            throw ex;
        }
    }

    static SessionManagerFactory getInstance() {
        return singleton;
    }

    private SessionManagerFactory() {
    }

    private void init() throws Exception {
        String value = System.getProperty("nautica.workflow.sessionManager");
        if (value == null || value.trim().equals("")) {
            String E1001 = StringManager.get("E1001");
            sLog.error((Object)E1001);
            throw new WorkflowException(E1001);
        }
        this.sessionManager = (SessionManager)Class.forName(value).newInstance();
        String I1001 = StringManager.get("I1001");
        eLog.info((Object)I1001);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

