/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.security.simple;

import javax.naming.InitialContext;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationBean;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.security.InvalidOrganizationException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.simple.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.simple.OrganizationManagerPO;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;
import org.apache.log4j.Logger;

public class SimpleOrganizationManager
implements OrganizationManager {
    private static final String WORKFLOW_ORGANIZATION_MANAGER = "WorkflowOrganizationManager";
    private static Logger sLog = LogManager.getSercurityLogger();

    public SimpleOrganizationManager() throws Exception {
        try {
            OrganizationManagerPO omPO = new OrganizationManagerPO(this);
            InitialContext context = new InitialContext();
            context.rebind(WORKFLOW_ORGANIZATION_MANAGER, (Object)omPO);
            sLog.info((Object)StringManager.get("I1006"));
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E1007");
            sLog.error((Object)errMsg, (Throwable)ex);
            throw ex;
        }
    }

    public Organization getOrganization(String oid) throws WorkflowSecurityException {
        try {
            OrganizationManagerDAO orgmanagerDAO = this.getOrganizationManagerDAO();
            OrganizationBean org = orgmanagerDAO.findByOrganizationID(oid);
            return org;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1018") + "(OrganizationID = " + oid + ")";
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    public User[] getAssignedUser(Organization org) throws WorkflowSecurityException {
        try {
            OrganizationManagerDAO orgmanagerDAO = this.getOrganizationManagerDAO();
            User[] users = orgmanagerDAO.findUsersByOrganizationID(org.getID());
            return users;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1019");
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    public Organization[] getOrganizationByUser(User user) throws WorkflowSecurityException {
        try {
            OrganizationManagerDAO orgmanagerDAO = this.getOrganizationManagerDAO();
            Organization[] orgs = orgmanagerDAO.findByUserID(user.getID());
            return orgs;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1020");
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    public Organization getHigherOrganization(Organization org) throws InvalidOrganizationException, WorkflowSecurityException {
        try {
            OrganizationManagerDAO orgmanagerDAO = this.getOrganizationManagerDAO();
            OrganizationBean higher = orgmanagerDAO.findHigherByOrganizationID(org.getID());
            return higher;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1021");
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    private OrganizationManagerDAO getOrganizationManagerDAO() throws Exception {
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        return daoFactory.getOrganizationManagerDAO();
    }
}

