#! /bin/sh

if [ -z ${NAUTICA_HOME} ] 
then
 echo NAUTICA_HOME environmental variable is not set.
 echo Please set directory installed Nautica in NAUTICA_HOME 
 echo environmental variable.
 exit 0
fi

NAUTICA_LIB=${NAUTICA_HOME}/lib
ENGINESTARTER=jp.co.argo21.nautica.workflow.WorkflowEngineStarter

for PATH in ${NAUTICA_LIB}/*.jar
do
 CLASSPATH=${CLASSPATH}:${PATH}
done

cd ${NAUTICA_HOME}

${JAVA_HOME}/bin/orbd -defaultdb ${NAUTICA_HOME}/temp -ORBInitialPort 1050&

${JAVA_HOME}/bin/java -classpath ${CLASSPATH} -Xms64m -Xmx256m  ${ENGINESTARTER} -home ${NAUTICA_HOME} $@
