/* $Id: AppSelectionAction.java,v 1.17 2005/08/26 04:45:20 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.util.Calendar;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.argo21.nautica.workflow.sample.actionform.TimeBean;
import jp.co.argo21.nautica.workflow.sample.actionform.UserBean;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.model.dao.OvertimeAppDAO;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.StatusConstants;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.sample.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * \ʖ̏sANVNXB
 *  
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.17 $
 * @since   Nautica Workflow 0.9
 */
public class AppSelectionAction extends Action {

    /**
     * \쐬sB
     * 
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return ANVtH[h
     */
    public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
        
        // NGXg\ʂу[U擾
        String appKindName = request.getParameter("appkind");
        UserBean user  = (UserBean)request.getSession().getAttribute("user");
        String sessionID = user.getSessionID();
        
        try {
            // \ԍ̎擾
            AppKind appKind = DAOFactory.getAppKindDAO().getAppKindFromID(appKindName);
            String appKindID = appKind.getAppkindID();
            String appID = UniqueKeyGenerator.generate(appKindID);
            
            // \gUNVe[uɃR[hǉ
            AppTransactionDAO apptransDao = DAOFactory.getAppTransactionDAO();
            apptransDao.insertForOverTime(appID, appKindID, user.getUserID());
            
            // e\̃e[uɐ\ԍ̋󃌃R[hǉ
            OvertimeAppDAO appKindDao 
                = (OvertimeAppDAO) DAOFactory.getApplicationDAOFromAppKindID(appKindName);
            appKindDao.insertAppNo(appID);
            ApplicationDAO appDao = DAOFactory.getApplicationDAO();
            appDao.insert(appID, appKindID, user.getUserID());
                    
            // vZX
            WorkflowEngineHandler engine = SingletonServices.getInstance().getWfEngineHandler();
            String pdid = SingletonServices.getInstance().getProcessDefID(Constants.OVERTIME_PDID);
            String pid = engine.createProcess(sessionID, pdid, appID);
               
            // evZXϐݒ
            Attribute appIdAttr = new Attribute();
            appIdAttr.setName(Constants.APPLICANT_ID);
            appIdAttr.setValue(user.getUserID());
            appIdAttr.setType(1);
            engine.assignProcessAttribute(sessionID, pid, appIdAttr);
            
            Attribute appNameAttr = new Attribute();
            appNameAttr.setName(Constants.APPLICANT_NAME);
            appNameAttr.setValue(user.getName());
            appNameAttr.setType(1);
            engine.assignProcessAttribute(sessionID, pid, appNameAttr);
            
            Attribute orgCode = new Attribute();
            orgCode.setName(Constants.ORGANIZATION_CODE);
            orgCode.setValue(user.getOrganizationID());
            orgCode.setType(1);
            engine.assignProcessAttribute(sessionID, pid, orgCode);
            
            Attribute appTypeCode = new Attribute();
            appTypeCode.setName(Constants.APPLICATION_TYPE_CODE);
            appTypeCode.setValue(appKind.getAppkindID());
            appTypeCode.setType(1);
            engine.assignProcessAttribute(sessionID, pid, appTypeCode);
            
            Attribute appTypeName = new Attribute();
            appTypeName.setName(Constants.APPLICATION_TYPE_NAME);
            appTypeName.setValue(appKind.getAppkindName());
            appTypeName.setType(1);
            engine.assignProcessAttribute(sessionID, pid, appTypeName);
            
            Attribute appNo = new Attribute();
            appNo.setName(Constants.APPLICATION_NO);
            appNo.setValue(appID);
            appNo.setType(1);
            engine.assignProcessAttribute(sessionID, pid, appNo);
            
            Attribute status = new Attribute();
            status.setName(Constants.STATUS);
            status.setValue(StatusConstants.APPLY_WAIT);
            status.setType(1);
            engine.assignProcessAttribute(sessionID, pid, status);
            
            //vZXJn
            engine.startProcess(sessionID, pid);
            
            // \ԍNGXgɓo^
            request.setAttribute("appid", appID);
            
            // \͂tNGXgɓo^
            request.setAttribute("time", new TimeBean(Calendar.getInstance()));
            
            return mapping.findForward(Constants.SUCCESS);
            
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        }
    }    
}