/* $Id: ShowApplicationAction.java,v 1.9 2005/08/26 04:45:05 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.argo21.nautica.workflow.sample.actionform.ApplicationFormInBean;
import jp.co.argo21.nautica.workflow.sample.actionform.BeanFactory;
import jp.co.argo21.nautica.workflow.sample.actionform.TimeBean;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.Constants;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * \͉̓ʕ\邽߂̏ANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class ShowApplicationAction extends Action {

    /**
     * \͉ʂ̕\OsB
     * 
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return ANVtH[h
     */
    public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
        
        // NGXg\ԍ擾
        String appID = (String) request.getAttribute("appid");
        
        try {
            // \ʃR[hɑΉ\擾
            ApplicationDAO appdao = DAOFactory.getApplicationDAO();
            Application app = appdao.getApplicationByID(appID);
            String appKindID = app.getKind().getAppkindID();
            BeanFactory factory = BeanFactory.getInstance(appKindID);
            ApplicationFormInBean formbean = factory.getFormBeanFromModel(app);

            // NGXgɒlZbg
            request.getSession().setAttribute("appformbean", formbean);
            request.getSession().setAttribute("appkind", app.getKind());
            request.getSession().setAttribute("appid", appID);
            request.setAttribute("time", TimeBean.getCurrentTimeBean());
            
            return mapping.findForward(Constants.SUCCESS);
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);            
        }
    }
}