/* $Id: ShowApprovalListAction.java,v 1.8 2005/08/26 04:45:12 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.ServiceException;

import jp.co.argo21.nautica.workflow.sample.actionform.UserBean;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.StatusConstants;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * F҂\ꗗN̏sANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class ShowApprovalListAction extends Action {

    /**
     * F҂\ꗗ擾B
     * 
	 * @param mapping ANV}bsO
	 * @param form ANVtH[
	 * @param request NGXg
	 * @param response X|X
	 * @return ANVtH[h
	 */
	public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {

        // NGXg烆[U擾    
        UserBean userBean = (UserBean) request.getSession().getAttribute("user");
        String sessionID = userBean.getSessionID();
    
        try {
            // vZXϐ[]"APPROVAL_WAIT"Ɉvƍڂ̃Xg擾
            WorkItemHandler wfWorkitemHandler = SingletonServices.getInstance().getWfWorkitemHandler();
            Filter[] filter = new Filter[1];
            Filter status = new Filter();
            status.setType(5003);
            status.setFilterName(Constants.STATUS);
            status.setFilterString(StatusConstants.APPROVAL_WAIT);
            status.setComparison(1);
            filter[0] = status;
            WorkItem[] items = wfWorkitemHandler.getWorkItems(sessionID, filter);
            
            // ƍIDAvZXϐ[\ԍ]擾A
            // \ԍɌʃe[u\̓e擾
            ArrayList appList = new ArrayList();
            Map wids = new HashMap();
            for (int i = 0; i < items.length; i++) {
                WorkItem item = items[i];
                String wid = item.getID();
                
                String appID = wfWorkitemHandler.getWorkItemAttributeValue(
                        sessionID, wid, Constants.APPLICATION_NO).getValue();
                
                AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
                AppTransaction appTrans = appTransDao.getAppTransactionByAppIDUserID(appID, userBean.getUserID());
                if (appTrans != null && (appTrans.getAppStatus()).equals(StatusConstants.STATUS_TRANS_WAIT)) {
                    Application app = DAOFactory.getApplicationDAO().getApplicationByID(appID);
                    wids.put(appID, wid);
                    
                    appList.add(app);
                } else {
                    // OC[Ul̈ʎЈ̏ꍇAF\
                    RoleManagerRemote rmr = SingletonServices.getInstance().getRoleManager();
                    Role[] roles = rmr.getAttachedRoles(userBean.getUser());
                    List roleList = new ArrayList();
                    for (int j =0; j < roles.length; j++) {
                        roleList.add(roles[j].getID());
                    }
                    if (!roleList.contains(AppTransactionDAO.JINJI_BUCHO_ROLE) && 
                            !roleList.contains(AppTransactionDAO.JINJI_KACHO_ROLE)) {
                        appTrans = appTransDao.getAppTransactionByAppIDRoleID(appID, AppTransactionDAO.JINJI_ROLE);
                        if (appTrans != null && (appTrans.getAppStatus()).equals(StatusConstants.STATUS_TRANS_WAIT)) {
                            Application app = DAOFactory.getApplicationDAO().getApplicationByID(appID);
                            wids.put(appID, wid);
                            
                            appList.add(app);
                        }
                    }                    
                }
            }
            
            if (appList.size() == 0) {
                // Ɖ\ȍڂȂ
                List errMsgs = new ArrayList();
                ResourceManager rm = ResourceManager.getInstance();
                errMsgs.add(rm.getValue("error.nolist"));
                request.setAttribute("errorMsg", errMsgs.toArray());
                return mapping.findForward(Constants.ERROR);
            }            
            
            Application[] application = (Application[]) appList.toArray(new Application[appList.size()]);
            
            request.setAttribute("applications", application);
            request.getSession().setAttribute("wids", wids);

            return mapping.findForward(Constants.SUCCESS);
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (RemoteException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (ServiceException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);
        }
    }
}