/* $Id: OvertimeAppBeanFactory.java,v 1.10 2005/08/26 04:45:36 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.actionform;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.simple.OrganizationManagerRemote;

/**
 * ԊOJ\BeanNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
public class OvertimeAppBeanFactory extends BeanFactory {
    
    /**
     * w肳ꂽ\ContentBeanԂB
     * 
     * @param \
     * @return ContentBean
     */
    public ApplicationContentBean getContentBeanFromModel(Application appold) {
        OvertimeApp app = (OvertimeApp)appold;
        
        OvertimeAppContentBean bean  = new OvertimeAppContentBean();
        bean.setAppID(app.getId());
        bean.setAppKindName(app.getKind().getAppkindName());
        bean.setAppDateString(DateFormat.getDateInstance(DateFormat.FULL).format(app.getDate()));
        
        int startHour = app.getStartHour();
        int startMin = app.getStartMin();
        Date workDay = app.getWorkday();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(workDay);
        startCal.set(Calendar.HOUR_OF_DAY, startHour);
        startCal.set(Calendar.MINUTE, startMin);
        bean.setWorkstarttime(DateFormat.getTimeInstance(DateFormat.SHORT).format(startCal.getTime()));
  
        int endHour = app.getEndHour();
        int endMin = app.getEndMin();
        workDay = app.getWorkday();
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(workDay);
        endCal.set(Calendar.HOUR_OF_DAY, endHour);
        endCal.set(Calendar.MINUTE, endMin);
        bean.setWorkendtime(DateFormat.getTimeInstance(DateFormat.SHORT).format(endCal.getTime()));
        
        bean.setWorkDay(DateFormat.getDateInstance(DateFormat.FULL).format(app.getWorkday()));
        
        bean.setComp(app.isComp());
        if (app.isComp()) {
            bean.setCompday(DateFormat.getDateInstance(DateFormat.FULL).format(app.getCompDay()));
        } else {
            bean.setCompday("");
        }       
        bean.setOvertimeHoursString(Float.toString(app.getOvertimeHours()));
        bean.setReason(app.getReason());
        bean.setRemark(app.getRemark());
        bean.setApplicantString(getApplicantString(app.getUser()));
        
        return bean;
        
    }
    
    /**
     * w肳ꂽ\̃tH[FormBeanԂB
     * 
     * @param app \
     * @return FormBean
     */
    public ApplicationFormInBean getFormBeanFromModel( Application appold ) {
        OvertimeApp app = (OvertimeApp)appold;
        
        AppOvertimeInBean bean = new AppOvertimeInBean();
        
        bean.setCompDay(app.isComp()?"true":"false");
        
        Date compDay = app.getCompDay();
        if (compDay!=null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(compDay);
            bean.setCompDayDay(Integer.toString(calendar.get(Calendar.DAY_OF_MONTH)));
            bean.setCompDayMonth(Integer.toString(calendar.get(Calendar.MONTH)+1));
            bean.setCompDayYear(Integer.toString(calendar.get(Calendar.YEAR)));
        }
        
        bean.setEndHour(Integer.toString(app.getEndHour()));
        bean.setEndMin(Integer.toString(app.getEndMin()));
        bean.setOvertimeHours(Float.toString(app.getOvertimeHours()));
        bean.setReason(app.getReason());
        bean.setRemark(app.getRemark());
        bean.setStartHour(Integer.toString(app.getStartHour()));
        bean.setStartMin(Integer.toString(app.getStartMin()));
        
        Date workday = app.getWorkday();
        if (workday!=null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(workday);
            bean.setWorkDayDay(Integer.toString(calendar.get(Calendar.DAY_OF_MONTH)));
            bean.setWorkDayMonth(Integer.toString(calendar.get(Calendar.MONTH)+1));
            bean.setWorkDayYear(Integer.toString(calendar.get(Calendar.YEAR)));
        }
        
        return bean;
        
    }
    
    /**
     * \҂̕ԂB
     * `́ugD@\Җ@i\ҔԍjvłB
     * 
     * @param user \
     * @return \҂̕
     */
    private String getApplicantString(User user) {
        try {
            OrganizationManagerRemote orgManager = SingletonServices.getInstance().getOrganizationManager();
            Organization[] orgs = orgManager.getOrganizationByUser(user);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < orgs.length; i++) {
                sb.append(orgs[i].getName());
            }
            sb.append(user.getName());
            sb.append("(").append(user.getID()).append(")");
            return sb.toString();
            
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
