/* $id:$
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved. 
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.sample.model.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;

/**
 * L[V[PXe[uɑ΂ANZXsNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class KeySeqDAO {
    
    public static final String SEQ = "SEQ";
    public static final String NAME = "NAME";

    // \[X}l[W
    private static ResourceManager locator = ResourceManager.getInstance();
    
    // VV[PTǉ邽߂SQL
    private static final String SQL_INSERT_SEQUENCER
        = "INSERT INTO KEYSEQ (NAME, SEQ) VALUES (?, 0) ";
    // V[PT̒lXV邽߂SQL
    private static final String SQL_UPDATE_SEQUENCER
        = "UPDATE KEYSEQ SET SEQ = ? WHERE (NAME = ?) AND (SEQ < ?) ";
    // V[PT̒l擾邽߂SQL
    private static final String SQL_GET_SEQUENCER
        = "SELECT SEQ FROM KEYSEQ WHERE NAME = ? ";

    /**
     * ̃V[PXl擾B
     *
     * @param seqName V[PT
     * @return V[PXl
     * @throws SQLException SQLO
     */
    public int next(String seqName) throws SQLException {
        Connection conn = locator.getConnection();
        init(conn, seqName);
        int seq = current(conn, seqName);

        int result = 0;
        while (result< 1) {
            seq++;
            PreparedStatement statement = conn.prepareStatement(SQL_UPDATE_SEQUENCER);
            try {
                statement.setLong(1, seq);
                statement.setString(2, seqName);
                statement.setLong(3, seq);
                result = statement.executeUpdate();
            } finally {
                statement.close();
            }
        }
        return seq;
    }

    /**
     * V[PTB
     *
     * @param conn     JDBCڑ
     * @param seqName V[PT
     * @throws SQLException SQLO
     */
    private void init(Connection conn, String seqName) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(SQL_INSERT_SEQUENCER);
        try {
            statement.setString(1, seqName);
            statement.executeUpdate();
        } catch (SQLException ex) {
            //R[h}ŗONĂƂ肠B
        } finally {
            statement.close();
        }
    }

    /**
     * ݂̃V[PXl擾B
     *
     * @param conn    JDBCڑ
     * @param seqName V[PT
     * @return V[PXl
     * @throws SQLException SQLO
     */
    private int current(Connection conn, String seqName) throws SQLException {
        PreparedStatement statement = conn.prepareStatement(SQL_GET_SEQUENCER);
        try {
            statement.setString(1, seqName);

            int seq = 0;
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                seq = rs.getInt(SEQ);
            }
            rs.close();

            return seq;
        } finally {
            statement.close();
        }
    }
    
}
