/* $Id: ResourceManager.java,v 1.5 2005/08/26 04:45:03 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 * \[Xɑ΂ăANZXNXłB
 * ̃NXANZX郊\[X͈ȉ̂QłB
 * Ef[^\[XE\[X
 * 		̃NXMySqlJNDIw肷BTomcat̋@\păf[^\[X
 * 		IuWFNg擾B܂A擾f[^\[XIuWFNg瓾
 * 		RlNVIuWFNg̃I[vƃN[YB
 * 
 * E\[XohE\[X
 * 		̃NX̓[ݒp̃\[Xoh̃pXw肷B
 * 		āA[ݒ擾B
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class ResourceManager {
    
    /** MySQL p  DataSource 擾邽߂ JNDI  */
	private static final String MYSQL_JNDI = "java:comp/env/jdbc/mysql";
    
    /** ResourceBundle IuWFNg */
    private static final ResourceBundle bundle 
            = ResourceBundle.getBundle("jp.co.argo21.nautica.workflow.sample.resource.ApplicationResources");
    
    /** g̃CX^X */
	private static ResourceManager locator = new ResourceManager();
	
    /** InitialContext IuWFNg */
	private InitialContext context = null;
    
    /** DataSource IuWFNg */
	private DataSource source = null;
	
    /**
     * ftHgRXgN^B
     * VOgł邽߁Aprivate ƂĐ錾B
     */
	private ResourceManager() {
		try {
			context = new InitialContext();
			source = (DataSource) context.lookup(MYSQL_JNDI);
            
		} catch(NamingException e) {
            // ĂӖȂ߁AWo͂ɕ\
            System.err.println(e.getMessage());
		}
	}
	
    /**
     * ResourceManager ̃CX^X擾B
     * 
     * @return ResourceManager ̃CX^X
     */
	public static ResourceManager getInstance() {
		return locator;
	}
	
    /**
     * f[^x[XRlNV擾B
     * 
     * @return f[^x[XRlNV
     * @throws SQLException
     */
	public Connection getConnection() throws SQLException {
    	return source.getConnection();	
	}
	
    /**
     * f[^x[XRlNVB
     * 
     * @param conn RlNVIuWFNg
     * @param stmt Xe[ggIuWFNg
     * @throws SQLException CӂSQLO
     */
	public void closeConnection(Connection conn, Statement stmt) throws SQLException {
		if (stmt != null) {
			stmt.close();
		}
		if ( (conn != null) && (!conn.isClosed())) {		
			conn.close();
		}
	}
    
    public void closeConnection(Connection conn) throws SQLException {
        if ( (conn != null) && (!conn.isClosed())) {        
            conn.close();
        }
    }

    /**
     * vpeBt@Cɐݒ肳ꂽ key ɑΉ value ԂB
     * 
     * @param key vpeBt@C key ƂȂ镶
     * @return key ɑΉ value
     */
    public String getValue(String key) {
        return bundle.getString(key);
    }
}
