/* $Id: IconManager.java,v 1.9 2005/08/26 04:46:00 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import java.util.HashMap;
import java.util.Map;

import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * Nautica[Nt[^pǗc[ŎgpACRꊇǗB
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.9 $
 * @since   Nautica Workflow 0.9
 */
public class IconManager
{
	/** ACRꗗ */
	static private Map icons;
	
	/**
	 * ꗗ
	 */
	static
	{
		icons = new HashMap();
		Class c = IconManager.class;
		String path = "/jp/co/argo21/nautica/tool/wfadm/images/";
		String ext = ".png";
		String[] names = {
			"application",
			"automatic",
			"automatic-gs",
			"complete",
			"concurrent-end",
			"concurrent-start",
			"concurrent-end-gs",
			"concurrent-start-gs",
			"end",
			"interactive",
			"end-gs",
			"interactive-gs",
			"package",
			"participant",
			"process",
			"start",
			"start-gs",
			"subprocess",
			"subprocess-gs",
			"variable",
			"attribute-mini",
			"process-frameicon",
			"property",
			"abort",
			"reload",
			"resume",
			"suspend",
			"varlist"
		};

		for (int i = 0; i < names.length; i++) {
			String n = names[i];
			Icon icon = new ImageIcon(c.getResource(path + n + ext));
			icons.put(n, icon);
		}
	}

	/**
	 * L[ɑΉACRԂB
	 * 
	 * @param key	L[
	 * @return	ACR
	 */
	static public Icon getIcon(String key)
	{
		return (Icon)icons.get(key);
	}
}
