/* $Id: MenuBar.java,v 1.4 2005/08/26 04:45:58 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.action.ActionNames;

/**
 * Nautica[Nt[^pǗc[̃j[o[łB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
final class MenuBar extends JMenuBar
{
	/** t@C */
	private JMenu     fileMenu            = new JMenu();
	/** `o^ */
	private JMenuItem registerDefItem     = new JMenuItem();
	/** J */
	private JMenuItem openItem            = new JMenuItem();
	/** Vbg_E */
	private JMenuItem shutdownItem        = new JMenuItem();
	/** I */
	private JMenuItem exitItem            = new JMenuItem();


	/** c[ */
	private JMenu     toolMenu            = new JMenu();
	/** Or[A */
	private JMenuItem exceptionViewerItem = new JMenuItem();
	/** ݒ */
	private JMenuItem preferenceItem      = new JMenuItem();

	/** wv */
	private JMenu     helpMenu            = new JMenu();
	/** wv\ */
	private JMenuItem helpItem            = new JMenuItem();
	/** o[W\ */
	private JMenuItem versionItem         = new JMenuItem();

	/**
	 * j[o[\zB
	 */
	public MenuBar()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();
		ActionMap am = WorkflowAdminManager.getActionMap();
		
		initFileMenu(rm, am);
		initToolMenu(rm, am);
		initHelpMenu(rm, am);
	}
	
	/**
	 * t@Cj[\zB
	 * 
	 * @param rm	\[X}l[W
	 * @param am	ANV}bv
	 */
	private void initFileMenu(ResourceManager rm, ActionMap am)
	{
		registerDefItem.setText(rm.getResource("Menu.file.register"));
		registerDefItem.setMnemonic('R');
		registerDefItem.addActionListener(am.get(ActionNames.REGISTER_DEF));

		openItem.setText(rm.getResource("Menu.file.open"));
		openItem.setMnemonic('O');
		openItem.addActionListener(am.get(ActionNames.OPEN_ENGINE));

		shutdownItem.setText(rm.getResource("Menu.file.shutdown"));
		shutdownItem.setMnemonic('D');
		shutdownItem.addActionListener(am.get(ActionNames.SHUTDOWN_ENGINE));

		exitItem.setText(rm.getResource("Menu.file.exit"));
		exitItem.setMnemonic('X');
		exitItem.addActionListener(am.get(ActionNames.EXIT));

		fileMenu.setText(rm.getResource("Menu.file"));
		fileMenu.setMnemonic('F');
		fileMenu.add(registerDefItem);
		fileMenu.add(openItem);
		fileMenu.add(shutdownItem);
		fileMenu.addSeparator();
		fileMenu.add(exitItem);

		add(fileMenu);
	}
	
	/**
	 * c[j[\zB
	 * 
	 * @param rm	\[X}l[W
	 * @param am	ANV}bv
	 */
	private void initToolMenu(ResourceManager rm, ActionMap am)
	{
		exceptionViewerItem.setText(rm.getResource("Menu.tool.exception"));
		exceptionViewerItem.setMnemonic('E');
		exceptionViewerItem.addActionListener(am.get(ActionNames.EXCEPTION_VIEWER));

		preferenceItem.setText(rm.getResource("Menu.tool.preference"));
		preferenceItem.setMnemonic('O');
		preferenceItem.addActionListener(am.get(ActionNames.PREFERENCES));

		toolMenu.setText(rm.getResource("Menu.tool"));
		toolMenu.setMnemonic('T');
		toolMenu.add(exceptionViewerItem);
		toolMenu.addSeparator();
		toolMenu.add(preferenceItem);

		add(toolMenu);
	}
	
	/**
	 * wvj[\zB
	 * 
	 * @param rm	\[X}l[W
	 * @param am	ANV}bv
	 */
	private void initHelpMenu(ResourceManager rm, ActionMap am)
	{
		helpItem.setText(rm.getResource("Menu.help.help"));
		helpItem.setMnemonic('H');
		helpItem.addActionListener(am.get(ActionNames.HELP));

		versionItem.setText(rm.getResource("Menu.help.version"));
		versionItem.setMnemonic('A');
		versionItem.addActionListener(am.get(ActionNames.ABOUT));

		helpMenu.setText(rm.getResource("Menu.help"));
		helpMenu.setMnemonic('H');
		helpMenu.add(helpItem);
		helpMenu.addSeparator();
		helpMenu.add(versionItem);

		add(helpMenu);
	}
}
