/* $Id: StatusBar.java,v 1.3 2005/08/26 04:45:59 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Xe[^Xo[B
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class StatusBar extends JPanel
{
	/** \pxB */
	private JLabel message = new JLabel();

	/**
	 * Xe[^Xo[𐶐B
	 */
	public StatusBar()
	{
		Dimension size = new Dimension(20, 20);
		message.setPreferredSize(size);

		BorderLayout layout = new BorderLayout();
		this.setLayout(layout);
		this.setBorder(BorderFactory.createLoweredBevelBorder());

		/* xXe[^Xo[ɒǉ */
		this.add(message, BorderLayout.CENTER);
	}

	/**
	 * Xe[^Xo[ɃbZ[W\B
	 * 
	 * @param s bZ[W
	 */
	void setMessage(String s)
	{
		if (s != null) {
			message.setText(s);
		} else {
			clearMessage();
		}
	}

	/**
	 * Xe[^Xo[̃bZ[WNAB
	 */
	void clearMessage()
	{
		message.setText("");
	}
}
