/* $Id: VersionWindow.java,v 1.3 2005/08/26 04:46:00 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;

/**
 * Nautica[Nt[^pǗc[̃o[W\ʂłB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public final class VersionWindow extends JWindow
{
	/** iSC[W\[XpX */
	static private final String path
		= "/jp/co/argo21/nautica/tool/wfadm/images/versionlogo.png";

	/** o[W\ */
	static private final String version = "Version 0.9";

	/** 쌠\ */
	static private final String copyright
		= "Copyright \u00a92005 ARGO 21, Corp. all rights reserved.";

	/** iSC[W */
	static private Icon logo;

	/** iStHg */
	static private Font font = new Font("SansSerif", Font.BOLD, 12);

	/**
	 * S̏
	 */
	static
	{
		logo = new ImageIcon(VersionWindow.class.getResource(path));
	}

	/**
	 * o[W\ʂ𐶐B
	 */
	public VersionWindow()
	{
		VersionPanel panel = new VersionPanel();
		setContentPane(panel);
		pack();

		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension size = getSize();
		setBounds(
			(screenSize.width - size.width) / 2,
			(screenSize.height - size.height) * 2 / 5,
			size.width,
			size.height
			);
	}
	
	/**
	 * o[W\ʂ\B
	 * 
	 * @see java.awt.Component#show()
	 */
	public void show()
	{
		//JWindow͌ɉƑOɏoȂ̂ŁAĊJȂB
		this.hide();
		super.show();
	}

	/**
	 * o[W\pplłB
	 *
	 */
	private final class VersionPanel extends JPanel
	{
		/**
		 * o[W\pGA𐶐B
		 */
		private VersionPanel() {
			// \GA[hC[W̃TCYɂ킹B
			Dimension size = new Dimension(logo.getIconWidth(), logo.getIconHeight());
			this.setPreferredSize(size);

			addMouseListener(
				new MouseAdapter() {
					public void mouseReleased(MouseEvent e) {
						VersionWindow.this.hide();
					}
				}
			);
		}

		/**
		 * o[W\`悷B
		 *
		 * @param	g	`ΏۃOtBbNX
		 */
		public void paint(Graphics g)
		{
			logo.paintIcon(this, g, 0, 0);

			Dimension size = this.getSize();
			FontMetrics metrics = g.getFontMetrics(font);
			int height = metrics.getHeight();
			int descent = metrics.getDescent();

			g.setColor(Color.gray);
			g.setFont(font);

			int width = metrics.stringWidth(version);
			int dx = (size.width - width) / 2;
			int dy = size.height - (height + descent + 35);
			g.drawString(version, dx, dy);

			width = metrics.stringWidth(copyright);
			dx = (size.width - width) / 2;
			dy = size.height - (descent + 10);
			g.drawString(copyright, dx, dy);

			g.dispose();
		}
	}
}
