/* $Id: WorkflowAdmin.java,v 1.4 2005/08/26 04:45:58 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import javax.swing.UIManager;

import jp.co.argo21.commons.swing.ExceptionViewer;

/**
 * Nautica[Nt[^pǗc[Np̃CNXłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowAdmin
{
	/**
	 * Nautica[Nt[^pǗc[{̃[hpmain\bhłB
	 *
	 * @param	args	N̈
	 */
	static public void main(String[] args)
	{
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

			WorkflowAdminManager.boot();
		} catch (Exception ex) {
			WorkflowAdmin.shutdownWithException(ex);
		}
	}
	
	/**
	 * Nautica[Nt[^pǗc[̃u[gs
	 * 
	 * @param ex Cӂ̗O
	 */
	static private void shutdownWithException(Exception ex)
	{
		ExceptionViewer exceptionViewer = new ExceptionViewer(null, true);
		exceptionViewer.setThrowable(ex);
		exceptionViewer.setMessage(
			"Nautica WorkflowAdmin boot process failed.\n"
			+ "Please press CLOSE button for shutdown.");
		exceptionViewer.show();
	}
}
