/* $Id: WorkflowAdminFrame.java,v 1.12 2005/08/26 04:46:01 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfadm;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.action.ActionNames;
import jp.co.argo21.nautica.tool.wfadm.common.BusyTask;
import jp.co.argo21.nautica.tool.wfadm.common.OpenEngineDialog;
import jp.co.argo21.nautica.tool.wfadm.definition.register.RegisterDialog;
import jp.co.argo21.nautica.tool.wfadm.definition.register.RegisterInfo;
import jp.co.argo21.nautica.tool.wfadm.definition.register.RegisterInfoComponent;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewController;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewFrame;
import jp.co.argo21.nautica.tool.wfadm.pref.EngineInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.rmi.DefinitionRepositoryRemote;
import jp.co.argo21.nautica.workflow.rmi.WorkflowAdminHandlerRemote;

/**
 * Nautica[Nt[^pǗc[̃CʂłB
 *
 * @author  nito(Argo 21, Corp.)
 * @version $Revision: 1.12 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowAdminFrame extends JFrame
{
	/** j[o[ */
	private MenuBar menuBar;
	/** fXNgbv */
	private DesktopPane desktop;
	/** Xe[^Xo[ */
	private StatusBar statusBar;
	
	
	
	/**
	 * Cʂ𐶐B
	 * 
	 * @throws java.awt.HeadlessException	j^[Ȃꍇ
	 */
	public WorkflowAdminFrame() throws HeadlessException
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();

		initInputMap();

		Toolkit toolkit = Toolkit.getDefaultToolkit();
		Dimension screen = toolkit.getScreenSize();
		int sw = screen.width;
		int sh = screen.height;
		
		menuBar = new MenuBar();

		desktop = new DesktopPane();
		statusBar = new StatusBar();

		setTitle(rm.getResource("WorkflowAdminFrame.title"));
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		setJMenuBar(menuBar);

		Container contentPane = getContentPane();
		BorderLayout layout = new BorderLayout();
		contentPane.setLayout(layout);
		contentPane.add(desktop, BorderLayout.CENTER);
		contentPane.add(statusBar, BorderLayout.SOUTH);

		//EBhE𒆉ɔzu
		int fw = (int)(sw * 0.95);
		int fh = (int)(sh * 0.95);
		setSize(new Dimension(fw, fh));
		setLocation((sw - fw) / 2, 0);
		setIconImage(((ImageIcon)IconManager.getIcon("application")).getImage());

		this.validate();
	}

	/**
	 * EBhECxg𐧌䂷B
	 *
	 * @param	e		WindowEvent
	 */
	protected void processWindowEvent(WindowEvent e)
	{
		super.processWindowEvent(e);

		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			ActionMap am = WorkflowAdminManager.getActionMap();
			Action action = am.get(ActionNames.EXIT);
			action.actionPerformed(null);
		} else {
			repaint();
		}
	}

	/**
	 * I
	 */
	public void notifyApplicationWillExit()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();
		setVisible(false);
		dispose();
	}
	
	/**
	 * V[gJbgL[̃}bsOsB
	 */
	private void initInputMap()
	{
		JComponent c = (JComponent)this.getContentPane();
		
		//ANV}bvo^
		ActionMap am = WorkflowAdminManager.getActionMap();
		c.setActionMap(am);
		
		//Cvbg}bvo^
		InputMap inputmap = c.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
		inputmap.put(KeyStroke.getKeyStroke('O', Event.CTRL_MASK), ActionNames.OPEN_ENGINE);
		inputmap.put(KeyStroke.getKeyStroke('Q', Event.CTRL_MASK), ActionNames.EXIT);
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_F11, 0),   ActionNames.EXCEPTION_VIEWER);
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0),    ActionNames.HELP);
		inputmap.put(KeyStroke.getKeyStroke('H', Event.CTRL_MASK), ActionNames.HELP);
	}

	/**
	 * `t@C̓o^sB
	 */	
	public void registerDefinition()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();
		EngineInfo einfo = OpenEngineDialog.showDialog(this);
		
		//GW񂪑IȂꍇ
		if (einfo == null) return;

		RegisterInfoComponent comp = new RegisterInfoComponent();
		RegisterInfo rinfo = null;
		if (RegisterDialog.showDialog(this, comp)) {
			rinfo = comp.getRegisterInfo();
		} else {
			return;
		}
		
		if (rinfo == null) return;
		
		BusyTask task = new RegisterDefinitionTask(einfo, rinfo);
		WorkflowAdminManager.runBusyTask(task);
	}

	/**
	 * GWJB
	 */	
	public void openEngine()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();
		EngineInfo einfo = OpenEngineDialog.showDialog(this);
		
		//GW񂪑IȂꍇ
		if (einfo == null) return;
		
		BusyTask task = new OpenEngineTask(einfo);
		WorkflowAdminManager.runBusyTask(task);
	}

	/**
	 * GWVbg_E鏈B
	 */	
	public void shutdownEngine()
	{
		ResourceManager rm = WorkflowAdminManager.getResourceManager();
		EngineInfo einfo = OpenEngineDialog.showDialog(this);
		
		//GW񂪑IȂꍇ
		if (einfo == null) return;

		int ret = DialogUtilities.showYesNoConfirm(rm.getResource("I9006")
				+ " " + einfo.getName() + " "
				+ rm.getResource("I9006-1"));
		if (ret == JOptionPane.NO_OPTION) return;
		
		BusyTask task = new ShutdownEngineTask(einfo);
		WorkflowAdminManager.runBusyTask(task);
	}
	
	/**
	 * `t@C̓o^s^XNB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.12 $
	 * @since   Nautica Workflow 0.9
	 */
	class RegisterDefinitionTask implements BusyTask
	{
		/** GW */
		private EngineInfo einfo;
		/** o^ */
		private RegisterInfo rinfo;
		/**  */
		private int state = INIT;
		
		/**
		 * `t@C̓o^s^XN𐶐B
		 *
		 * @param einfo GW
		 * @param rinfo o^
		 */
		RegisterDefinitionTask(EngineInfo einfo, RegisterInfo rinfo)
		{
			this.einfo = einfo;
			this.rinfo = rinfo;
		}

		/**
		 * ԂԂB
		 *
		 * @return 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#getState()
		 */
		public int getState()
		{
			return state;
		}

		/**
		 * m[h̍ēǂݍ݂sB
		 * 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#run()
		 */
		public void run()
		{
			state = EXEC;

			ResourceManager rm = WorkflowAdminManager.getResourceManager();
			
			String adminKey = einfo.getAdminKey();
			String pname = rinfo.getPackageName();
			String rpath = rinfo.getRegisterPath();
			WorkflowServiceAccessor wsa = einfo.getWorkflowServiceAccessor();
			String session = null;
			try {
				session = wsa.open();
				DefinitionRepositoryRemote dr = wsa.getDefinitionRepository();
				dr.registerDefinition(session, pname, rpath);
				DialogUtilities.showInfo(rm.getResource("I9002") + "(" + pname + ")");
			} catch (Exception ex) {
				ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
				ev.setThrowable(ex);
				DialogUtilities.showError(rm.getResource("E9025") + "(" + pname + ")");
			} finally {
				if (session != null) {
					try {
						wsa.close();
					} catch (Exception ex) {
						ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
						ev.setThrowable(ex);
					}
				}
				state = COMPLETE;
			}
		}
	}
	
	/**
	 * GWJ^XNB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.12 $
	 * @since   Nautica Workflow 0.9
	 */
	class OpenEngineTask implements BusyTask
	{
		/** GW */
		private EngineInfo einfo;
		/**  */
		private int state = INIT;
		
		/**
		 * GWJ^XN𐶐B
		 *
		 * @param einfo GW
		 */
		OpenEngineTask(EngineInfo einfo)
		{
			this.einfo = einfo;
		}

		/**
		 * ԂԂB
		 *
		 * @return 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#getState()
		 */
		public int getState()
		{
			return state;
		}

		/**
		 * GWJsB
		 * 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#run()
		 */
		public void run()
		{
			state = EXEC;

			try {
				ResourceManager rm = WorkflowAdminManager.getResourceManager();

				EngineViewController evc = new EngineViewController(einfo);
				if (evc.checkEngineConnection()) {
					String title = einfo.getName();
					EngineViewFrame view = new EngineViewFrame(title, evc);
					Point p = desktop.getNextLocation();
					desktop.add(view);
					view.setLocation(p);
					view.setVisible(true);
				} else {
					DialogUtilities.showError(rm.getResource("E9013") + "(" + einfo.getName() + ")");
				}
			} finally {
				state = COMPLETE;
			}
		}
	}
	
	/**
	 * GWVbg_E^XNB
	 *
	 * @author  nito(Argo 21, Corp.)
	 * @version $Revision: 1.12 $
	 * @since   Nautica Workflow 0.9
	 */
	class ShutdownEngineTask implements BusyTask
	{
		/** GW */
		private EngineInfo einfo;
		/**  */
		private int state = INIT;
		
		/**
		 * GWVbg_E^XN𐶐B
		 *
		 * @param einfo GW
		 * @param rinfo o^
		 */
		ShutdownEngineTask(EngineInfo einfo)
		{
			this.einfo = einfo;
		}

		/**
		 * ԂԂB
		 *
		 * @return 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#getState()
		 */
		public int getState()
		{
			return state;
		}

		/**
		 * GWVbg_EsB
		 * 
		 * @see jp.co.argo21.nautica.tool.wfadm.common.BusyTask#run()
		 */
		public void run()
		{
			state = EXEC;

			ResourceManager rm = WorkflowAdminManager.getResourceManager();

			String adminKey = einfo.getAdminKey();
			WorkflowServiceAccessor wsa = einfo.getWorkflowServiceAccessor();
			String session = null;
			try {
				session = wsa.open();
				WorkflowAdminHandlerRemote wah = wsa.getWorkflowAdminHandler();
				wah.shutdown(session, adminKey);
				DialogUtilities.showInfo(rm.getResource("I9001") + "(" + einfo.getName() + ")");
			} catch (Exception ex) {
				ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
				ev.setThrowable(ex);
				DialogUtilities.showError(rm.getResource("E9020") + "(" + einfo.getName() + ")");
			} finally {
				if (session != null) {
					try {
						wsa.close();
					} catch (Exception ex) {
						ExceptionViewer ev = WorkflowAdminManager.getExceptionViewer();
						ev.setThrowable(ex);
					}
				}
				state = COMPLETE;
			}
		}
	}
}
